/*******************************************************************************
 * Copyright (c) 2004 Duke University
 *
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.cs.duke.edu/csed/ambient/copyright.html
 * 
*******************************************************************************/
package edu.duke.ambient.ui.checkin.jobs;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSWorkspaceSubscriber;
import org.eclipse.team.internal.ccvs.ui.operations.AddOperation;

import edu.duke.ambient.ui.checkin.Shared;

public class AddFilesJob extends Job {

	IProject project;
	private final boolean DEBUG = true;
	private final static String ADD_STR = "Adding your files...";
	public AddFilesJob(IProject proj) {
		super(ADD_STR);
		this.project = proj;
	}

	protected IStatus run(IProgressMonitor monitor) {
		try {
			monitor.beginTask(ADD_STR, 100);
			try {

				IResource[] resources = new Shared(project).getResources();

				CVSWorkspaceSubscriber s = CVSProviderPlugin.getPlugin()
						.getCVSWorkspaceSubscriber();

				new AddOperation(null, resources).run(monitor);
				return Status.OK_STATUS;
			} catch (InvocationTargetException e) {
				if (DEBUG) {
					e.printStackTrace();
				}
			} catch (InterruptedException e) {
				if (DEBUG) {
					e.printStackTrace();
				}
			}

		} finally {
			monitor.done();
		}
		return Status.CANCEL_STATUS;
	}
}
