/*******************************************************************************
 * Copyright (c) 2004 Duke University
 *
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.cs.duke.edu/csed/ambient/copyright.html
 * 
*******************************************************************************/
package edu.duke.ambient.ui.checkin.jobs;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Commit;
import org.eclipse.team.internal.ccvs.ui.operations.CommitOperation;

public class CommitOp extends CommitOperation{
	public CommitOp(IResource[] res){
		super(null,res,null);
	}
	
	public void execute(IProgressMonitor monitor) throws CVSException, InterruptedException {
		
		if (!Command.MESSAGE_OPTION.isElementOf(getLocalOptions())) {
			String comment = promptForComment(getResources());
			if (comment == null) return;
			addLocalOption(Commit.makeArgumentOption(Command.MESSAGE_OPTION, comment));
		}
		super.execute(monitor);
	}
	protected String promptForComment(IResource[] resourcesToCommit) {
		return "";
	}
}
