/*******************************************************************************
 * Copyright (c) 2004 Duke University
 *
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.cs.duke.edu/csed/ambient/copyright.html
 * 
*******************************************************************************/
package edu.duke.ambient.ui.checkin.jobs;


import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.ui.operations.ReplaceOperation;
import org.eclipse.team.internal.ccvs.ui.operations.ShareProjectOperation;

import edu.duke.ambient.ui.checkin.Shared;


public class RestoreJob extends Job {
	private static String RESTORE_STR = "Restoring your files...";
	private IProject myProject;
	private CVSTag myTag;
	private ICVSRemoteFolder myRemoteFolder;
	private Shell myShell;
	
	public RestoreJob(IProject proj, CVSTag tag, ICVSRemoteFolder remote,Shell shell) {
		super(RESTORE_STR);
		myProject = proj;
		myTag = tag;
		myRemoteFolder = remote;
		myShell = shell;
	}

	protected IStatus run(IProgressMonitor monitor) {
		try {
			monitor.beginTask(RESTORE_STR, 100);

			Shared sh = new Shared(myProject);
			sh.deleteResources();
			IResource[] res = sh.getWorkspaceResources();
			if (res != null) {
				CommitOp commit = new CommitOp(res);
				try {
					commit.execute(monitor);
				} catch (CVSException e) {
					e.printStackTrace();
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
			}
		
			try {
				ReplaceOperation replace = new ReplaceOperation(null, sh
						.getWorkspaceResources(), myTag, true);
				replace.execute(monitor);
				ICVSRepositoryLocation location = myRemoteFolder.getRepository();
				
				ShareProjectOperation op = new ShareProjectOperation(
						myShell, location, 
						myProject,myRemoteFolder.getRepositoryRelativePath());
				op.run(monitor);
				
				return Status.OK_STATUS;
			} catch (CVSException e1) {
				e1.printStackTrace();

			} catch (InterruptedException e) {
				e.printStackTrace();
			}catch(Exception e){
				e.printStackTrace();
			}

		} finally {
			new CommitJob(myProject).schedule();
			monitor.done();
		}

		return Status.CANCEL_STATUS;
	}
}