/*******************************************************************************
 * Copyright (c) 2004 Duke University
 *
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.cs.duke.edu/csed/ambient/copyright.html
 * 
*******************************************************************************/
package edu.duke.ambient.ui.checkin.jobs;

import java.lang.reflect.InvocationTargetException;
import java.util.Date;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.operations.TagOperation;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.core.runtime.Status;

public class TagJob extends Job {
	private final String TAG_STR = "tagging";
	private IResource[] myResources;
	private final boolean DEBUG = true;
	
	public TagJob(IResource[] res) {
		super("tagging");
		this.myResources = res;
	
	}

	protected IStatus run(IProgressMonitor monitor) {
		try {
			monitor.beginTask(TAG_STR, 100);
					
			String tagStr = makeTagString();
			
			CVSTag tag = new CVSTag(tagStr, CVSTag.VERSION);
			IWorkbenchPart part = null;
			TagOperation op = new TagOperation(part, myResources);
			op.setTag(tag);
			try {
				op.run(monitor);
			} catch (InvocationTargetException e) {
				if (DEBUG){
					e.printStackTrace();
				}
			} catch (InterruptedException e) {
				if (DEBUG){
					e.printStackTrace();
				}
			}
			return Status.OK_STATUS;
			
		} finally {
			monitor.done();
			
		}
	}
	
	private String makeTagString(){
		Date d = new Date();
		
		ICVSResource res = CVSWorkspaceRoot.getCVSResourceFor(myResources[0]);
		String tagPrefix = "";
		try {
			tagPrefix = res.getParent().getRepositoryRelativePath();
			tagPrefix = tagPrefix.replace('.','^');
		} catch (CVSException e) {
		}
		
		String tag = tagPrefix +d.getTime();
		return tag;
		
	}
}
