/*******************************************************************************
 * Copyright (c) 2004 Duke University
 *
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.cs.duke.edu/csed/ambient/copyright.html
 * 
*******************************************************************************/
package edu.duke.ambient.ui.checkin.pages;

//import java.awt.Toolkit;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;


import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.model.AllRootsElement;
import org.eclipse.team.internal.ccvs.ui.model.CVSModelElement;
import org.eclipse.team.internal.ccvs.ui.model.CVSTagElement;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryManager;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryRoot;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.DialogUtil;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchLabelProvider;

import edu.duke.ambient.AmbientGlobals;
import edu.duke.ambient.MessageResources;
import edu.duke.ambient.ui.checkin.AmbientRemoteContentProvider;
import edu.duke.ambient.ui.checkin.AmbientResourceTreeGroup;
import edu.duke.ambient.ui.checkin.NameReader;
import edu.duke.ambient.ui.checkin.Shared;
import edu.duke.ambient.ui.checkin.jobs.AddFilesJob;
import edu.duke.ambient.ui.checkin.jobs.CheckoutOp;
import edu.duke.ambient.ui.checkin.jobs.CommitOp;
import edu.duke.ambient.ui.preferences.AmbientPreferenceConstants;
import org.eclipse.team.internal.ccvs.ui.operations.CheckoutIntoOp;
import org.eclipse.team.internal.ccvs.ui.operations.DisconnectOperation;
import org.eclipse.team.internal.ccvs.ui.operations.ShareProjectOperation;

public class AmbientCheckoutPage extends WizardPage {

	public final static int PROGRESS_DIALOG = 1;
	public final static int PROGRESS_BUSYCURSOR = 2;

	// JOB Names
	private final String CHECKOUT_STR = "Fetching Project...";
	private final String RESHARE_STR = "Resharing Project...";
	private boolean JOB_DONE = false;
	private IProject myProject = null;
	private final boolean DEBUG = false;
	private AmbientRemoteContentProvider contentProvider;
	private IProject newProject;
	private AllRootsElement root;
	private String myModuleName,myVersion;
	protected AmbientResourceTreeGroup myViewer;
	protected boolean myBasicFlag = false;
	private boolean myUpdateFlag = false;
	protected ICVSRemoteFolder mySkeletonFolder, myStudentFolder,
	                            myUpdatesFolder;
	//private Toolkit myBeeper = Toolkit.getDefaultToolkit();

	public static final int BASIC_TYPE = 0;
	public static final int UPDATE_TYPE = 1;
	public static final int STANDARD_TYPE = 2;
	
	public AmbientCheckoutPage(int type) {
	    super("AmbientCheckoutPage");

	    if (type == BASIC_TYPE){
	    	myBasicFlag = true;
	    }
	    
	    if (type == UPDATE_TYPE){
	    	myUpdateFlag = true;
	    }

		putMessages();
		checkRepository();
		root = new AllRootsElement();
	}


	
	 protected  void putMessages(){
	 	if (myUpdateFlag){
	    	setTitle("Updating Project");
	    	setDescription("Please select the project you would like to update\n" +
	    			"The update will be downloaded into package " +
					AmbientGlobals.UPDATE_DOWNLOAD_DIR);
	    	return;
	 	}
	    if (!myBasicFlag){
	    	setTitle("Checkout Project");
			setDescription("Please select the project you would like to work on");
	    }else{
	    	setTitle("Checkout Basic Project");
			setDescription("Please select the project you would like to work on.\n "+
					"WARNING: This will delete all files in your current project. ");
	    }

	}
	public void checkRepository() {
		IPreferenceStore store = WorkbenchPlugin.getDefault()
				.getPreferenceStore();

		if ((!store.getBoolean(AmbientPreferenceConstants.CVS_SET_UP))
				|| (!store
						.contains(AmbientPreferenceConstants.AMBIENT_PREFERENCES_SET))) 
		{
			//myBeeper.beep();
			MessageDialog
					.openInformation(
							getShell(),
							"Error", MessageResources.REPOSITORY_NOT_SET_ERROR);
			
			return;
		}
	}
	
	public void createControl(Composite parent) {
		Composite composite = new Composite(parent, SWT.NULL);
		composite.setLayout(new GridLayout());
		GridData data = new GridData(GridData.FILL_BOTH);
		data.heightHint = 200;
		composite.setLayoutData(data);
		composite.setFont(parent.getFont());

		Label projectLabel = new Label(composite, SWT.NONE);
		projectLabel.setText("Available Projects");

		try {
			if (DEBUG) {
				System.out.println("In AmbientCheckoutPage");
				System.out.println("     initing the tree myViewer");
			}
			myViewer = new AmbientResourceTreeGroup(composite, getTreeInput(),
					getContentProvider(), WorkbenchLabelProvider
							.getDecoratingWorkbenchLabelProvider(), null,
					WorkbenchLabelProvider
							.getDecoratingWorkbenchLabelProvider(), SWT.NONE,
					DialogUtil.inRegularFontMode(parent));
		} catch (NegativeArraySizeException e) {
			if (DEBUG) {
				System.out.println("In AmbientCheckoutPage ");
				System.out.println("     could not create myViewer");
				e.printStackTrace();
			}
			return;
		}
		setControl(composite);
		return;

	}

	public boolean finish() {
		if (myViewer == null)
			return false;		
		Object[] selectedProject = myViewer.getSelectedResources().toArray();

		getFolders((ICVSRemoteFolder) selectedProject[0]);
		if (mySkeletonFolder == null) {
			//myBeeper.beep();
			MessageDialog.openInformation(getContainer().getShell(), "Error",
					MessageResources.PROJECT_UNAVAILABLE_FOR_CHECKOUT_ERROR);
			getShell().setEnabled(true);
			return false;
		}

		CheckoutProjectJob checkout = null;
		String projectName = mySkeletonFolder.getParent().getName();
		IProject pro = 
			ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
		
		if (myUpdateFlag){
			if (myUpdatesFolder == null){
				MessageDialog.openError(getContainer().getShell(),
						"No Project Found",
						MessageResources.UPDATE_UNAVAILABLE);
				return false;
			}
			if (!pro.exists()){
				MessageDialog.openError(getContainer().getShell(),
						"No Project Found",
						MessageResources.UPDATE_NO_PROJECT_ERROR);
				return false;
			}
			MessageDialog.openInformation(getContainer().getShell(),
					"Upadet Ino","The update for project " + 
					     mySkeletonFolder.getParent().getName() +
						 " will be checked-out into the update folder."
					);
			
			CheckoutIntoProjectJob updateJob = 
				new CheckoutIntoProjectJob(mySkeletonFolder);
			updateJob.setSystem(false);
			updateJob.schedule();
			return true;
		}
		if (myModuleName==null){
			//myBeeper.beep();
			if (pro.exists()){
				if(!MessageDialog.openQuestion(getContainer().getShell(),
						"Basic Check-out",
						MessageResources.OUTSIDER_CHECKOUT_WARNING+"\n"+
						MessageResources.BASIC_CHECKOUT_WARNING)){
					return true;
				}
			}else{
				MessageDialog.openInformation(getContainer().getShell(),
						"Basic Check-out",
						MessageResources.OUTSIDER_CHECKOUT_WARNING);
			}
			
			
			checkout = new CheckoutProjectJob(mySkeletonFolder, true);
			checkout.setSystem(false);
			checkout.schedule();
		}else if (myStudentFolder == null || myBasicFlag) {
			//myBeeper.beep();
			if (pro.exists()){
				if(!MessageDialog.openQuestion(getContainer().getShell(),
						"Basic Check-out",
						MessageResources.BASIC_CHECKOUT_WARNING)){
					return true;
				}
			}else{
				MessageDialog.openInformation(getContainer().getShell(),
						"First Check-out", 
						MessageResources.FIRST_CHECKOUT_INFO);
			}
			checkout = new CheckoutProjectJob(mySkeletonFolder, true);
			checkout.setSystem(false);
			checkout.schedule();
			ReshareProjectJob reshare = new ReshareProjectJob((ICVSRemoteFolder) mySkeletonFolder.getParent());
			reshare.setSystem(false);
			reshare.schedule();
		} else {
		CheckoutIntoProjectJob test =  new CheckoutIntoProjectJob(mySkeletonFolder);
			checkout = new CheckoutProjectJob(myStudentFolder, false);
			checkout.setSystem(false);
			checkout.schedule();
		}
		return true;
	}

	protected IWorkbenchAdapter getAdapter(Object o) {
		if (!(o instanceof IAdaptable)) {
			return null;
		}
		return (IWorkbenchAdapter) ((IAdaptable) o)
				.getAdapter(IWorkbenchAdapter.class);
	}

	protected AmbientRemoteContentProvider getContentProvider() {
		if (contentProvider == null) {
			contentProvider = new AmbientRemoteContentProvider();
		}
		return contentProvider;
	}

	/**
	 * Convenience method that maps the selected resources to their providers.
	 * The returned Hashtable has keys which are ITeamProviders, and values
	 * which are Lists of IResources that are shared with that provider.
	 * 
	 * @return a hashtable mapping providers to their selected resources
	 */
	protected Hashtable getProviderMapping() {
		return getProviderMapping(getSelectedResources());
	}
	/**
	 * Convenience method that maps the given resources to their providers. The
	 * returned Hashtable has keys which are ITeamProviders, and values which
	 * are Lists of IResources that are shared with that provider.
	 * 
	 * @return a hashtable mapping providers to their resources
	 */
	protected Hashtable getProviderMapping(IResource[] resources) {
		Hashtable result = new Hashtable();
		for (int i = 0; i < resources.length; i++) {
			RepositoryProvider provider = RepositoryProvider
					.getProvider(resources[i].getProject());
			List list = (List) result.get(provider);
			if (list == null) {
				list = new ArrayList();
				result.put(provider, list);
			}
			list.add(resources[i]);
		}
		return result;
	}

	protected RepositoryManager getRepositoryManager() {
		return CVSUIPlugin.getPlugin().getRepositoryManager();
	}

	protected IResource[] getSelectedResources() {
		IResource[] newProjects = {newProject};
		return newProjects;
	}

	protected void getFolders(ICVSRemoteFolder remoteFolder) {
		IPreferenceStore store = WorkbenchPlugin.getDefault()
				.getPreferenceStore();
		String userName = store.getString(AmbientPreferenceConstants.USER_ID);
		mySkeletonFolder = null;
		myStudentFolder = null;
		try {
			ICVSRemoteResource[] children = remoteFolder
					.members(new NullProgressMonitor());
			String folderName = "";
			myModuleName=null;
			for (int i = 0; i < children.length; i++) {
				folderName = children[i].getName();
				
				NameReader nameReader = new NameReader();
				nameReader.processString(folderName);
				
				if (nameReader.hasMember(userName)) {
					myModuleName = folderName;
					ICVSRemoteResource[] files = ((ICVSRemoteFolder) children[i])
							.members(new NullProgressMonitor());
					for (int j = 0; j < files.length; j++) {
						if (files[j].getName().equalsIgnoreCase(".project")) {
							myStudentFolder = (ICVSRemoteFolder) children[i];
							return;
						}
					}
				}
				if (folderName.equalsIgnoreCase(AmbientGlobals.SKELETON)) {
					mySkeletonFolder = (ICVSRemoteFolder) children[i];
				}
				
				if (folderName.equalsIgnoreCase(AmbientGlobals.UPDATES)){
					myUpdatesFolder = (ICVSRemoteFolder) children[i];
				}
			}
		} catch (TeamException e) {

		}
	}

	protected Object getTreeInput() {
		IPreferenceStore store = WorkbenchPlugin.getDefault()
				.getPreferenceStore();
		IWorkbenchAdapter adapter = getAdapter(root);

		if (adapter instanceof CVSModelElement) {
			Object[] children = ((CVSModelElement) adapter).getChildren(root);
			for (int i = 0; i < children.length; i++) {
				if (children[i] instanceof RepositoryRoot) {
					//we need to find the repository that stores the projects
					//for this class
					if ((((RepositoryRoot) children[i]).getRoot().getHost()
							.equalsIgnoreCase(store
									.getString(AmbientPreferenceConstants.HOST)))
							&& (((RepositoryRoot) children[i]).getRoot()
									.getRootDirectory()
									.equalsIgnoreCase(store
											.getString(AmbientPreferenceConstants.ROOT)))) {
						//we need to find the head of the repository
						IWorkbenchAdapter adapterRep = getAdapter(children[i]);
						Object[] grandChildren = ((CVSModelElement) adapterRep)
								.getChildren(children[i]);
						for (int j = 0; j < grandChildren.length; j++) {
							if (grandChildren[j] instanceof CVSTagElement)
								return grandChildren[j];

						}
					}
				}
			}
		}
		return root;
	}

	final protected void run(final IRunnableWithProgress runnable,
			boolean cancelable, int progressKind)
			throws InvocationTargetException, InterruptedException {
		final Exception[] exceptions = new Exception[]{null};
		final IRunnableWithProgress innerRunnable = new IRunnableWithProgress() {
			public void run(IProgressMonitor monitor)
					throws InvocationTargetException, InterruptedException {
				getRepositoryManager().run(runnable, monitor);
			}
		};

		switch (progressKind) {
			case PROGRESS_DIALOG :
			default :
				new ProgressMonitorDialog(getShell()).run(cancelable, true,
						innerRunnable);
				break;
		}
		if (exceptions[0] != null) {
			if (exceptions[0] instanceof InvocationTargetException)
				throw (InvocationTargetException) exceptions[0];
			else
				throw (InterruptedException) exceptions[0];
		}
	}
	
	class ReshareProjectJob extends Job {
		ICVSRemoteFolder targetFolder;

		public ReshareProjectJob(ICVSRemoteFolder folder) {
			super(RESHARE_STR);
			this.targetFolder = folder;
		}

		protected IStatus run(IProgressMonitor monitor) {
			while (JOB_DONE == false) {
			}

			try {
				monitor.beginTask(RESHARE_STR, 100);
				IPreferenceStore store = WorkbenchPlugin.getDefault()
						.getPreferenceStore();
				String userName = myModuleName;
				String module = targetFolder.getRepositoryRelativePath() + "/"
						+ userName;
				ICVSRepositoryLocation location = targetFolder.getRepository();

				try {
					ShareProjectOperation op = new ShareProjectOperation(
							getShell(), location, myProject, module);
					op.run(monitor);
					return Status.OK_STATUS;

				} catch (InvocationTargetException e) {
					if (DEBUG) {
						System.out.println("In AmbientCheckoutPage");
						System.out.println("     cannot reshare project");
						e.printStackTrace();
					}
				} catch (InterruptedException e) {
					if (DEBUG) {
						System.out.println("In AmbientCheckoutPage");
						System.out.println("     cannot reshare project");
						e.printStackTrace();
					}
				}

			} finally {
				AddFilesJob cvsAdd = new AddFilesJob(myProject);
				cvsAdd.setSystem(false);
				cvsAdd.schedule();
				monitor.done();
			}
			return Status.CANCEL_STATUS;
		}
	}

	class CheckoutProjectJob extends Job {
		ICVSRemoteFolder remoteFolder;
		boolean IS_BASIC;
		public CheckoutProjectJob(ICVSRemoteFolder folder, boolean is_basic) {
			super(CHECKOUT_STR);
			remoteFolder = folder;
			JOB_DONE = false;
			IS_BASIC = is_basic;
		}

		protected IStatus run(IProgressMonitor monitor) {
			try {
				ICVSRemoteFolder[] folders = {remoteFolder};
				List targetProjects = new ArrayList();
				Map targetFolders = new HashMap();
				for (int i = 0; i < folders.length; i++) {
					String name = folders[i].getParent().getName();
					if (name.endsWith(AmbientGlobals.PROJECT_EXT)){
						name = name.split(AmbientGlobals.PROJECT_EXT)[0];
					}
					IProject project = ResourcesPlugin.getWorkspace().getRoot()
							.getProject(name);
					targetFolders.put(name, folders[i]);
					targetProjects.add(project);
					newProject = project;
				}

				IResource[] projects = (IResource[]) targetProjects
						.toArray(new IResource[targetProjects.size()]);

				monitor.beginTask(CHECKOUT_STR, 100);
				if (projects.length != 0) {
					IProject[] localFolders = new IProject[projects.length];
					ICVSRemoteFolder[] remoteFolders = new ICVSRemoteFolder[projects.length];
					for (int i = 0; i < projects.length; i++) {
						localFolders[i] = (IProject) projects[i];
						remoteFolders[i] = (ICVSRemoteFolder) targetFolders
								.get(projects[i].getName());
					}

					if (DEBUG) {
						System.out.println("In AmbientCheckoutPage "
								+ "Starting checkout operation!");
					}

					Shared sh = new Shared(localFolders[0]);

					if (IS_BASIC) {
						sh.deleteResources();
						IResource[] res = sh.getWorkspaceResources();
						if (res != null) {
							CommitOp commit = new CommitOp(res);
							try {
								commit.execute(monitor);
							} catch (CVSException e) {
								e.printStackTrace();
							} catch (InterruptedException e) {
								e.printStackTrace();
							} catch(Exception e){
								e.printStackTrace();
							}
						}
					}

					try {
						new CheckoutOp(localFolders[0],
								remoteFolder).execute(monitor);
					} catch (CVSException e) {
						e.printStackTrace();
					} catch (InterruptedException e) {
						e.printStackTrace();
					}

					myProject = localFolders[0];
					if (IS_BASIC){
						IProject[] projectsToUnmanage = 
							new IProject[1];
						projectsToUnmanage[0] = myProject;
				
						try {
							new DisconnectOperation(null, 
									projectsToUnmanage,
									true).run(monitor);
						} catch (InvocationTargetException e1) {
						} catch (InterruptedException e1) {
						} catch (NullPointerException e1){}
					}
				
					return Status.OK_STATUS;
				}
			} finally {
				JOB_DONE = true;
				monitor.done();
			}
			return Status.CANCEL_STATUS;
		}
	}


	class CheckoutIntoProjectJob extends Job {
		private ICVSRemoteFolder remoteFolder;
		private IFolder myUpdateFolder = null;
		private File myUpdateDir = null;
	
		public CheckoutIntoProjectJob(ICVSRemoteFolder folder) {
			super(CHECKOUT_STR);
			remoteFolder = folder;
			JOB_DONE = false;
		}

		protected IStatus run(IProgressMonitor monitor) {
			try {
				ICVSRemoteFolder[] folders = {remoteFolder};
				List targetProjects = new ArrayList();
				Map targetFolders = new HashMap();
				for (int i = 0; i < folders.length; i++) {
					String name = folders[i].getParent().getName();
					IProject project = ResourcesPlugin.getWorkspace().getRoot()
							.getProject(name);
					targetFolders.put(name, folders[i]);
					targetProjects.add(project);
					newProject = project;
				}

				IResource[] projects = (IResource[]) targetProjects
						.toArray(new IResource[targetProjects.size()]);

				monitor.beginTask(CHECKOUT_STR, 100);
				if (projects.length != 0) {
					IProject[] localFolders = new IProject[projects.length];
					ICVSRemoteFolder[] remoteFolders = new ICVSRemoteFolder[projects.length];
					for (int i = 0; i < projects.length; i++) {
						localFolders[i] = (IProject) projects[i];
						remoteFolders[i] = (ICVSRemoteFolder) targetFolders
								.get(projects[i].getName());
					}
					
					IProject i = localFolders[0];
			
					try {
						IResource[] res = i.members();

						myUpdateDir  = new File(
								i.getLocation().toFile().getPath() + File.separator +
								AmbientGlobals.UPDATE_DOWNLOAD_DIR);
				
						if (!myUpdateDir.exists()){
							myUpdateDir.mkdir();
						}

						i.refreshLocal(2,monitor);
						i.refreshLocal(2,monitor);
						if (!myUpdateDir.exists()){
							return Status.CANCEL_STATUS;
						}

						for (int k=0;k<res.length;k++){
							if (res[k].getName().equalsIgnoreCase(
									AmbientGlobals.UPDATE_DOWNLOAD_DIR)){
								myUpdateFolder = (IFolder) res[k];
							}
						}
						
						if (myUpdateFolder == null){
							new CheckoutIntoProjectJob(remoteFolder).schedule();
							return Status.OK_STATUS;
						}
					} catch (CoreException e1) {
					}
				
					try {
						new CheckoutIntoOp(null,remoteFolder,myUpdateFolder,true).
						     execute(monitor);
					} catch (CVSException e) {
					} catch (InterruptedException e) {
					}
					return Status.OK_STATUS;
				}
			} finally {
				new Shared().unmanage(myUpdateDir);
				try {
					myUpdateFolder.refreshLocal(1,new NullProgressMonitor());
				} catch (Exception  e) {
				}
				monitor.done();
			}
			return Status.CANCEL_STATUS;
		}
	}
}