/*******************************************************************************
 * Copyright (c) 2004 Duke University
 *
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.cs.duke.edu/csed/ambient/copyright.html
 * 
*******************************************************************************/
/*******************************************************************************
 * This class is edited from the original WizardFileSystemResourceExportPage1 in
 * org.eclipse.ui.wizards.datatransfer
 *******************************************************************************/
package edu.duke.ambient.ui.checkin.pages;

//import java.awt.Toolkit;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryManager;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.internal.WorkbenchPlugin;

import edu.duke.ambient.MessageResources;
import edu.duke.ambient.ui.checkin.Shared;
import edu.duke.ambient.ui.checkin.jobs.CommitJob;
import edu.duke.ambient.ui.checkin.jobs.TagJob;
import edu.duke.ambient.ui.preferences.AmbientPreferenceConstants;
import edu.duke.ambient.ui.wizards.AmbientExportWizard;

public class AmbientExportPage extends AmbientExportResourcesPage {
	public final static int PROGRESS_BUSYCURSOR = 2;


	public final static int PROGRESS_DIALOG = 1;
	private String destinationNameField;
	private int numberOfProjects;
	private IResource[] resourcesToCommit = new IResource[10];
	private final boolean DEBUG = false;
	protected Wizard myWizard;

	public AmbientExportPage(IStructuredSelection selection,AmbientExportWizard wiz) {
		this("AmbientExportPage", selection);
		setTitle("Check-in Project");
		setDescription("Please select the project to be checked-in.");
		myWizard = wiz;
		((AmbientExportWizard)myWizard).enableFinish(!isWorkspaceEmpty());
	}

	
	protected boolean isWorkspaceEmpty(){
		if (ResourcesPlugin.getWorkspace().getRoot().getProjects().length == 0)
		{
			return true;
		}
		return false;
	}
	
	protected AmbientExportPage(
		String pageName,
		IStructuredSelection selection) {
		super(pageName, selection);
	}

	
	protected void createDestinationGroup(Composite parent) {
		
	}

	protected boolean cvsExportOperation() {
		if (!checkCVS()){
			return false;
		}
		
		List resourcesToExport = getSelectedResources();
		project = ((IResource) (resourcesToExport.get(0))).getProject();
		if (!new Shared().isShared(project)){
			MessageDialog.openInformation(
					getShell(),"Error",
					MessageResources.CHECKIN_IMPOSSIBLE_ERROR);
			return false;
		}

		CommitJob commit =new CommitJob(project);
		commit.setSystem(false);
		commit.schedule();
		TagJob tagJob = new TagJob(new Shared(project).getResources());
		tagJob.setSystem(false);
		tagJob.schedule();
		
		return true;
	}
	
	protected boolean checkCVS(){
		IPreferenceStore store =
			WorkbenchPlugin.getDefault().getPreferenceStore();

		//if cvs repository isn't set up yet
		if (!store.getBoolean(AmbientPreferenceConstants.CVS_SET_UP)) {
			MessageDialog.openInformation(
				getShell(),
				"Error",
				MessageResources.CHECKIN_PREFERENCES_ERROR);
			getShell().setEnabled(true);
			return false;
		}
		return true;
	}
	protected boolean checkFiles(final IResource[] resourcesToConfirm)
		throws InvocationTargetException, InterruptedException {
		final boolean[] checkFiles = new boolean[] { true };
		run(new WorkspaceModifyOperation() {
			public void execute(IProgressMonitor monitor) {
				monitor.beginTask(null, 100);
				String result = "";
				for (int i = 0; i < resourcesToConfirm.length; i++) {

					ICVSRemoteResource cvsResource;
					try {
						cvsResource =
							CVSWorkspaceRoot.getRemoteResourceFor(
								resourcesToConfirm[i]);
					} catch (CVSException e1) {
						return;
					}
					ICVSRemoteFile remoteFile = (ICVSRemoteFile) cvsResource;
					monitor.setTaskName(remoteFile.getName());

					ILogEntry[] log;
					try {
						log =
							remoteFile.getLogEntries(new NullProgressMonitor());
					} catch (TeamException e2) {
						return;
					}

					String remoteVersion = "";
					String localVersion = "";
					try {
						localVersion = remoteFile.getRevision();
					} catch (TeamException e4) {
						return;
					}
					if (log[0] != null) {
						remoteVersion = log[0].getRevision();
					}

					if (remoteVersion.compareTo(localVersion) != 0)
						checkFiles[0] = false;

					monitor.worked((100 * (i + 1)) / resourcesToConfirm.length);
				}

				monitor.done();
			}
		}, true /* cancelable */
		, PROGRESS_DIALOG);

		return checkFiles[0];
	}


	public boolean finish() {
		List resourcesToExport = getWhiteCheckedResources();
		saveDirtyEditors();
		saveWidgetValues();
		
		return cvsExportOperation();
	}



	/**
	 *	Answer the contents of self's destination specification widget.  If this
	 *	value does not have the required suffix then add it first.
	 */
	protected String getDestinationValue() {
		return destinationNameField.trim();
	}



	protected RepositoryManager getRepositoryManager() {
		return CVSUIPlugin.getPlugin().getRepositoryManager();
	}

	/**
	 *	Set the current input focus to self's destination entry field
	 */
	protected void giveFocusToDestination() {
		//destinationNameField.setFocus();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.dialogs.WizardDataTransferPage#handleEvent(org.eclipse.swt.widgets.Event)
	 */
	public void handleEvent(Event arg0) {
		// nothing to be done

	}

	final protected void run(
		final IRunnableWithProgress runnable,
		boolean cancelable,
		int progressKind)
		throws InvocationTargetException, InterruptedException {
		final Exception[] exceptions = new Exception[] { null };

		// Ensure that no repository view refresh happens until after the action
		final IRunnableWithProgress innerRunnable =
			new IRunnableWithProgress() {
			public void run(IProgressMonitor monitor)
				throws InvocationTargetException, InterruptedException {
				getRepositoryManager().run(runnable, monitor);
			}
		};

		switch (progressKind) {
			case PROGRESS_BUSYCURSOR :
				BusyIndicator.showWhile(Display.getCurrent(), new Runnable() {
					public void run() {
						try {
							innerRunnable.run(new NullProgressMonitor());
						} catch (InvocationTargetException e) {
							exceptions[0] = e;
						} catch (InterruptedException e) {
							exceptions[0] = e;
						}
					}
				});
				break;
			case PROGRESS_DIALOG :
			default :
				new ProgressMonitorDialog(getShell()).run(
					cancelable,
					true,
					innerRunnable);
				break;
		}
		if (exceptions[0] != null) {
			if (exceptions[0] instanceof InvocationTargetException)
				throw (InvocationTargetException) exceptions[0];
			else
				throw (InterruptedException) exceptions[0];
		}
	}
  	
	protected void createOptionsGroupButtons(Group optionsGroup) {
		IPreferenceStore store =
			WorkbenchPlugin.getDefault().getPreferenceStore();

		Font font = optionsGroup.getFont();
		Label destinationLabel = new Label(optionsGroup, SWT.NONE);
		destinationLabel.setText("Choose the project you want " +
		"to check-in. You are allowed to check-in multiple times."
		);
	}
}
	
