/*******************************************************************************
 * Copyright (c) 2004 Duke University
 *
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.cs.duke.edu/csed/ambient/copyright.html
 * 
*******************************************************************************/

package edu.duke.ambient.ui.checkin.pages;

import java.lang.reflect.InvocationTargetException;
import java.util.List;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.IHelpContextIds;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.TagSelectionDialog;
import org.eclipse.team.internal.ccvs.ui.operations.ShareProjectOperation;
import edu.duke.ambient.ui.checkin.TagDialog;
import edu.duke.ambient.ui.checkin.jobs.RestoreJob;


public class AmbientUndoPage extends AmbientExportPage{
	private boolean DEBUG = false;
	private final String VERSION = "VERSION";
	private final String RESHARE_STR = "Resharing the Project";
	public AmbientUndoPage(String pageName,
			IStructuredSelection selection){
		super(pageName, selection);
		
	}
	
	public AmbientUndoPage(IStructuredSelection selection) {
		this("AmbientUndoPage", selection);
		setTitle("Undo");
		setDescription("Please select the project to be restored");
	}
	
	public boolean finish(){
		return performUndo();
	}
	
	private boolean performUndo(){
		if (!checkCVS()){
			return false;
		}
		
		
		List resourcesToExport = getSelectedResources();
		project = ((IResource) (resourcesToExport.get(0))).getProject();
		
		if (!isShared()){
			return false;
		}

		IProject[] projects = {project};
		
		TagDialog dialog = new TagDialog(getShell(), projects, 
				Policy.bind("ReplaceWithTagAction.message"), //$NON-NLS-1$
				Policy.bind("TagSelectionDialog.Select_a_Tag_1"), //$NON-NLS-1$
				TagSelectionDialog.INCLUDE_VERSIONS, 
				false, 
				IHelpContextIds.REPLACE_TAG_SELECTION_DIALOG); //$NON-NLS-1$
		dialog.setBlockOnOpen(true);
		if (dialog.open() == Dialog.CANCEL) {
			return false;
		}	
		CVSTag selectedTag = dialog.getResult();
		ICVSRemoteFolder remote  = null;
		try {
			remote = (ICVSRemoteFolder) CVSWorkspaceRoot.
			    getRemoteResourceFor(project);
		} catch (CVSException e1) {}
		
		RestoreJob restoreJob = 
			new RestoreJob(project,selectedTag,remote,getShell());
		restoreJob.setSystem(false);
		restoreJob.schedule();

		return true;
	}
	
	protected boolean isShared(){
		boolean error =false;
		try {
			ICVSRemoteResource remoteRoot = 
				CVSWorkspaceRoot.getRemoteResourceFor(project);
			if (remoteRoot == null){
				error = true;
			}
		} catch (TeamException e) {
			if (DEBUG){
				e.printStackTrace();
			}
			error = true;
		}
		
		if (error == true){
			MessageDialog.openInformation(
					getShell(),"Error",
					"The selected project cannot be checked-in.\n" +
					"Please make sure that you have checked out\n" +
					"a project before checking-in! ");
				return false;
		}
		return true;
	}
	
	class ReshareProjectJob extends Job {
		private ICVSRemoteFolder myTargetFolder;
		private IProject myProject;
		
		public ReshareProjectJob(ICVSRemoteFolder folder, 
				IProject proj) {
			super(RESHARE_STR);
			this.myTargetFolder = folder;
			this.myProject = proj;
		}

		protected IStatus run(IProgressMonitor monitor) {
			try {
	
				ICVSRepositoryLocation location = myTargetFolder.getRepository();

				try {
					ShareProjectOperation op = new ShareProjectOperation(
							getShell(), location, 
							myProject,myTargetFolder.getRepositoryRelativePath());
					op.run();
					return Status.OK_STATUS;

				} catch (InvocationTargetException e) {
					if (DEBUG) {
						System.out.println("In AmbientCheckoutPage");
						System.out.println("     cannot reshare project");
						e.printStackTrace();
					}
				} catch (InterruptedException e) {
					if (DEBUG) {
						System.out.println("In AmbientCheckoutPage");
						System.out.println("     cannot reshare project");
						e.printStackTrace();
					}
				}

			} finally {
			    monitor.done();
			}
			return Status.CANCEL_STATUS;
		}
	}
	
}
