/*******************************************************************************
 * Copyright (c) 2004 Duke University
 *
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.cs.duke.edu/csed/ambient/copyright.html
 * 
*******************************************************************************/
package edu.duke.ambient.ui.preferences;

import java.lang.reflect.InvocationTargetException;
import java.util.Properties;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.util.KnownRepositories;

public class CheckinPreferencePage
	extends PreferencePage
	implements IWorkbenchPreferencePage {

	//widgets
	private StringFieldEditor hostName;
	private StringFieldEditor root;
	private StringFieldEditor userID;
	private final boolean DEBUG = true;
	
	public void init(IWorkbench workbench) {
		//nothing to do
	}

	protected Control createContents(Composite parent) {
		//make sure all constants are being initialized
		IPreferenceStore store =
			WorkbenchPlugin.getDefault().getPreferenceStore();
		/*if (!store
			.contains(AmbientPreferenceConstants.USER_ID))
			{
			initSettingsUser(store);
			}*/
		if (!store
			.contains(AmbientPreferenceConstants.AMBIENT_PREFERENCES_SET))
			initSettings(store);

		Font font = parent.getFont();
		noDefaultAndApplyButton();

		//The main composite
		Composite composite = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		layout.numColumns = 1;
		layout.marginWidth = 0;
		layout.marginHeight = 0;
		composite.setLayout(layout);
		GridData data = new GridData();
		data.verticalAlignment = GridData.FILL;
		data.horizontalAlignment = GridData.FILL;
		composite.setLayoutData(data);
		composite.setFont(font);

		createSubmitModeGroup(composite);

		return composite;
	}


	private void createCVSSubmitGroup(Composite composite) {
		Composite groupComposite = new Composite(composite, SWT.LEFT);
		GridLayout layout = new GridLayout();
		layout.numColumns = 2;
		groupComposite.setLayout(layout);
		GridData gd = new GridData();
		gd.horizontalAlignment = GridData.FILL;
		gd.grabExcessHorizontalSpace = true;
		groupComposite.setLayoutData(gd);
		groupComposite.setFont(composite.getFont());
		IPreferenceStore store =
			WorkbenchPlugin.getDefault().getPreferenceStore();

		//field to enter host name 		
		hostName =
			new StringFieldEditor(
				AmbientPreferenceConstants.PROJECT_NAME_PREFIX,
				"CVS Host",
				groupComposite);

		hostName.setPreferenceStore(
			WorkbenchPlugin.getDefault().getPreferenceStore());
		hostName.setPreferencePage(this);
		hostName.setStringValue(
			store.getString(AmbientPreferenceConstants.HOST));

		//field to enter the CVS root
		root =
			new StringFieldEditor(
				AmbientPreferenceConstants.TURNIN_COMMAND,
				"CVS Root",
				groupComposite);

		root.setPreferenceStore(
			WorkbenchPlugin.getDefault().getPreferenceStore());
		root.setPreferencePage(this);
		root.setStringValue(store.getString(AmbientPreferenceConstants.ROOT));

		//field to enter user id
		userID =
			new StringFieldEditor(
				AmbientPreferenceConstants.CLASS_ID,
				"User Name",
				groupComposite);

		userID.setPreferenceStore(
			WorkbenchPlugin.getDefault().getPreferenceStore());
		userID.setPreferencePage(this);
		userID.setStringValue(
			store.getString(AmbientPreferenceConstants.USER_ID));

	}
	
	public boolean performOk() {
		IPreferenceStore store =
			WorkbenchPlugin.getDefault().getPreferenceStore();
		store.setValue(
			AmbientPreferenceConstants.HOST,
			hostName.getStringValue());
		store.setValue(AmbientPreferenceConstants.ROOT, root.getStringValue());
		store.setValue(
			AmbientPreferenceConstants.USER_ID,
			userID.getStringValue());

		WorkbenchPlugin.getDefault().savePluginPreferences();

		//check if cvs repository works
		//if cvs is set up already remove the connection
		if (store.getBoolean(AmbientPreferenceConstants.CVS_SET_UP)) {
			CVSProviderPlugin provider = CVSProviderPlugin.getPlugin();
			ICVSRepositoryLocation[] roots = KnownRepositories.getInstance().getRepositories();
			if (roots.length != 0) {
				KnownRepositories.getInstance().disposeRepository(roots[0]);
			}
		}
		//create new connection 
		Properties properties = new Properties();
		properties.put("connection", "extssh");
		properties.put(
			"user",
			store.getString(AmbientPreferenceConstants.USER_ID));
		properties.put(
			"host",
			store.getString(AmbientPreferenceConstants.HOST));
		properties.put(
			"root",
			store.getString(AmbientPreferenceConstants.ROOT));

		//trying to create a new CVS location right here
	    final ICVSRepositoryLocation[] roots = new ICVSRepositoryLocation[1];
		boolean everythingOK = true;
		try {
			roots[0] = CVSRepositoryLocation.fromProperties(properties);
			roots[0] = KnownRepositories.getInstance().addRepository(roots[0],false);
			try {
				new ProgressMonitorDialog(getShell()).run(true, true, new IRunnableWithProgress() {
					public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
					;	try {
							roots[0].validateConnection(monitor);
						} catch (TeamException e) {
							throw new InvocationTargetException(e);
						}
					}
				});
			} catch (InvocationTargetException e) {
				everythingOK = false;
				if(DEBUG){
					System.out.println("in CheckinPreferencePage");
					e.printStackTrace();
				}
			} catch (InterruptedException e) {
				everythingOK = false;
				if (DEBUG){
					System.out.println("In CheckinPreferencePage");
					e.printStackTrace();
				}
			}
		} catch (CVSException e) {
			everythingOK = false;
			if (DEBUG){
				System.out.println("In CheckinPreferencePage ");
				e.printStackTrace();
			}
		}
		
		
		if (everythingOK){
			KnownRepositories.getInstance().addRepository(roots[0],true);
		}else{
			MessageDialog.openInformation(
					getShell(),
					"Error",
					"An error occured while setting up a connection to your CVS server!");
				return false;
		}
		store.putValue(AmbientPreferenceConstants.CVS_SET_UP, "true");
		return true;
	}

	protected static Label createLabel(Composite parent, String text) {
		Label label = new Label(parent, SWT.LEFT);
		label.setText(text);
		label.setFont(parent.getFont());
		GridData data = new GridData();
		data.horizontalSpan = 1;
		data.horizontalAlignment = GridData.FILL;
		label.setLayoutData(data);
		return label;
	}

	/**
	 * Creates a tab of one horizontal spans.
	 *
	 * @param parent  the parent in which the tab should be created
	 */
	protected static void createSpace(Composite parent) {
		Label vfiller = new Label(parent, SWT.LEFT);
		GridData gridData = new GridData();
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.BEGINNING;
		gridData.grabExcessHorizontalSpace = false;
		gridData.verticalAlignment = GridData.CENTER;
		gridData.grabExcessVerticalSpace = false;
		vfiller.setLayoutData(gridData);
	}

	/**
	 * initializes the submit plug-in settings 
	 * (alternatively, these values should be read from a .conf file)
	 */
	public static void initSettings(IPreferenceStore store) {

		store.putValue(
			AmbientPreferenceConstants.AMBIENT_PREFERENCES_SET,
			"true");
		store.putValue(AmbientPreferenceConstants.COMPRESS, "true");
		store.putValue(AmbientPreferenceConstants.CHECKIN_MODE, "false");
		store.putValue(AmbientPreferenceConstants.HOST, "godzilla.acpub.duke.edu");
		store.putValue(AmbientPreferenceConstants.USER_ID, "[your login]");
		store.putValue(AmbientPreferenceConstants.ROOT, "/afs/acpub/project/cps/courses");
	}

	public static void initSettingsUser(IPreferenceStore store) {

		store.putValue(
			AmbientPreferenceConstants.AMBIENT_PREFERENCES_SET,
			"true");
		store.putValue(AmbientPreferenceConstants.COMPRESS, "true");
		store.putValue(AmbientPreferenceConstants.CHECKIN_MODE, "false");
		store.putValue(AmbientPreferenceConstants.HOST, "godzilla.acpub.duke.edu");
		store.putValue(AmbientPreferenceConstants.ROOT, "/afs/acpub/project/cps/courses");
	}
	/**
	 * Create the buttons for the group that determine if the entire or
	 * selected directory structure should be created.
	 */


	private void createSubmitModeGroup(Composite composite) {

		Font font = composite.getFont();

		Group buttonComposite = new Group(composite, SWT.LEFT);
		GridLayout layout = new GridLayout();
		buttonComposite.setLayout(layout);
		GridData data =
			new GridData(
				GridData.HORIZONTAL_ALIGN_FILL | GridData.GRAB_HORIZONTAL);
		buttonComposite.setLayoutData(data);
		buttonComposite.setText("Checkout/Checkin Mode"); //$NON-NLS-1$
		buttonComposite.setFont(font);
		IPreferenceStore store =
			WorkbenchPlugin.getDefault().getPreferenceStore();

		String label = ("using CVS"); //$NON-NLS-1$	
		createCVSSubmitGroup(buttonComposite);
		createSpace(buttonComposite);	
	}
}
