/*******************************************************************************
 * Copyright (c) 2004 Duke University
 *
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.cs.duke.edu/csed/ambient/copyright.html
 * 
*******************************************************************************/
/*******************************************************************************
 * This class is edited from the original ZipFileExportWizard in
 * org.eclipse.ui.wizards.datatransfer
 *******************************************************************************/
package edu.duke.ambient.ui.wizards;

import java.net.MalformedURLException;
import java.net.URL;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

import edu.duke.ambient.ui.checkin.pages.AmbientCheckoutPage;

public class AmbientCheckoutWizard extends Wizard implements IExportWizard {
	private IWorkbench workbench;
	private IStructuredSelection selection;
	private AmbientCheckoutPage mainPage;
	private final boolean DEBUG = false;
	private int myType  = AmbientCheckoutPage.STANDARD_TYPE;
	
	/**
	 * Creates a wizard for submitting workspace resources for grading.
	 */
	public AmbientCheckoutWizard(int type) {
		myType = type;
		AbstractUIPlugin plugin =
			(AbstractUIPlugin) Platform.getPlugin(PlatformUI.PLUGIN_ID);
		IDialogSettings workbenchSettings = plugin.getDialogSettings();
		IDialogSettings section = workbenchSettings.getSection("AmbientCheckoutWizard"); //$NON-NLS-1$
		if (section == null)
			section = workbenchSettings.addNewSection("AmbientCheckoutWizard"); //$NON-NLS-1$
		setDialogSettings(section);
	}
	
	public void addPages() {
		super.addPages();
		if (DEBUG){
			System.out.println("In AmbientChecoutWizard ");
			System.out.println("       Adding the dialog page");
		}
		mainPage = new AmbientCheckoutPage(myType);
		//System.out.println("inited checkout page");
		addPage(mainPage);
	}
	/**
	 * Returns the image descriptor with the given relative path.
	 */
	private ImageDescriptor getImageDescriptor(String relativePath) {
		String iconPath = "icons/full/"; //$NON-NLS-1$
		try {
			AbstractUIPlugin plugin =
				(AbstractUIPlugin) Platform.getPlugin(PlatformUI.PLUGIN_ID);
			URL installURL = plugin.getDescriptor().getInstallURL();
			URL url = new URL(installURL, iconPath + relativePath);
			return ImageDescriptor.createFromURL(url);
		} catch (MalformedURLException e) {
			// Should not happen
			return null;
		}
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.jface.wizard.IWizard#performCancel()
	 */
	
	public void init(IWorkbench workbench,
	            	IStructuredSelection currentSelection) {
		this.workbench = workbench;
		if(DEBUG){
			System.out.println("In AmbientCheckoutWizardPage: ");
			System.out.println("      CheckinWizard GUI is inited");
		}
		selection = currentSelection;
		if (myType == AmbientCheckoutPage.STANDARD_TYPE){
			setWindowTitle("Checking out Project");
		}
		if(myType == AmbientCheckoutPage.BASIC_TYPE){
			setWindowTitle("Checking out Basic Project");
		}
		setDefaultPageImageDescriptor(getImageDescriptor("wizban/exportzip_wiz.gif")); //$NON-NLS-1$
		setNeedsProgressMonitor(true);
	}
	
	public boolean performFinish() {
		return mainPage.finish();
	}
}
