/*******************************************************************************
 * Copyright (c) 2004 Duke University
 *
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.cs.duke.edu/csed/ambient/copyright.html
 * 
*******************************************************************************/
/*******************************************************************************
 * This class is edited from the original NewProjectCreationWizard in
 * org.eclipse.jdt.internal.ui.wizards
 *******************************************************************************/
package edu.duke.ambient.ui.wizards;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.jdt.ui.wizards.NewJavaProjectWizardPage;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

import edu.duke.ambient.AmbientPlugin;

public class AmbientNewProjectCreationWizard
	extends NewElementWizard
	implements IExecutableExtension {

	public static final String NEW_PROJECT_WIZARD_ID = "edu.duke.ambient.ui.wizards.NewProjectCreationWizard"; //$NON-NLS-1$
	//public static final String NEW_PROJECT_WIZARD_ID= "org.eclipse.jdt.ui.wizards.NewProjectCreationWizard"; //$NON-NLS-1$

	private NewJavaProjectWizardPage fJavaPage;
	private WizardNewProjectCreationPage fMainPage;
	private IConfigurationElement fConfigElement;

	private NewClassWizardPage fClassPage;

	public AmbientNewProjectCreationWizard() {
		super();

		setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_NEWJPRJ);
		setDialogSettings(AmbientPlugin.getDefault().getDialogSettings());
		setWindowTitle(NewWizardMessages.getString("NewProjectCreationWizard.title")); //$NON-NLS-1$
	}

	/*
	 * @see Wizard#addPages
	 */
	public void addPages() {
		super.addPages();
		fMainPage = new WizardNewProjectCreationPage("NewProjectCreationWizard"); //$NON-NLS-1$
		fMainPage.setTitle(NewWizardMessages.getString("NewProjectCreationWizard.MainPage.title")); //$NON-NLS-1$
		fMainPage.setDescription(NewWizardMessages.getString("NewProjectCreationWizard.MainPage.description")); //$NON-NLS-1$
		addPage(fMainPage);
		fJavaPage = new NewJavaProjectWizardPage(AmbientPlugin.getWorkspace().getRoot(), fMainPage);
		fClassPage = new NewClassWizardPage();
		fClassPage.setWizard(this);

	}

	/* (non-Javadoc)
	 * @see org.eclipse.jdt.internal.ui.wizards.NewElementWizard#finishPage(org.eclipse.core.runtime.IProgressMonitor)
	 */
	protected void finishPage(IProgressMonitor monitor)
		throws InterruptedException, CoreException {
		//TODO: is this needed, i couldnt find its 3.0 equivalent
	    //fJavaPage.performFinish(monitor); // use the full progress monitor

		//trying to include SavitchIn class path
		IClasspathEntry[] classpath =
			fJavaPage.getNewJavaProject().getRawClasspath();
		IClasspathEntry[] newClasspath =
			new IClasspathEntry[classpath.length + 1];
		ClasspathEntry savitchIn =
			new ClasspathEntry(
				IPackageFragmentRoot.K_SOURCE,
				ClasspathEntry.CPE_VARIABLE,
				new Path("ECLIPSE_HOME/plugins/edu.duke.ambient_0.1/SavitchInSrc.jar"),
				ClasspathEntry.INCLUDE_ALL,
				ClasspathEntry.EXCLUDE_NONE,
				new Path("ECLIPSE_HOME/plugins/edu.duke.ambient_0.1/SavitchInSrc.jar"),
				null,
				null,
				false);

		for (int i = 0; i < classpath.length; i++) {
			newClasspath[i] = classpath[i];
		}
		newClasspath[classpath.length] = savitchIn;
		fJavaPage.getNewJavaProject().setRawClasspath(newClasspath, monitor);

		//trying to pass the newly created project
		StructuredSelection s =
			new StructuredSelection(fJavaPage.getNewJavaProject().getProject());
		fClassPage.init(s);

		fClassPage.setTypeName(
			fJavaPage.getNewJavaProject().getProject().getName(),
			false);
		fClassPage.setMethodStubSelection(true, false, false, true);
		fClassPage.createType(monitor); // use the full progress monitor

		//show the new project
		BasicNewProjectResourceWizard.updatePerspective(fConfigElement);
		selectAndReveal(fJavaPage.getNewJavaProject().getProject());
		ICompilationUnit cu =
			JavaModelUtil.toOriginal(
				fClassPage.getCreatedType().getCompilationUnit());
		if (cu != null) {
			IResource resource = cu.getResource();
			selectAndReveal(resource);
			openResource((IFile) resource);
		}
	}

	protected void handleFinishException(
		Shell shell,
		InvocationTargetException e) {
		String title = NewWizardMessages.getString("NewProjectCreationWizard.op_error.title"); //$NON-NLS-1$
		String message = NewWizardMessages.getString("NewProjectCreationWizard.op_error_create.message"); //$NON-NLS-1$
		ExceptionHandler.handle(e, getShell(), title, message);
	}

	/*
	 * Stores the configuration element for the wizard.  The config element will be used
	 * in <code>performFinish</code> to set the result perspective.
	 */
	public void setInitializationData(
		IConfigurationElement cfig,
		String propertyName,
		Object data) {
		fConfigElement = cfig;
	}

	/* (non-Javadoc)
	 * @see IWizard#performCancel()
	 */
	public boolean performCancel() {
		//TODO: must be needed but cant find Eclipse 3 equivalent
	    //fJavaPage.performCancel();
		return super.performCancel();
	}

}
