/*
 * Created on Jun 6, 2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package edu.duke.ambient.ui.wizards;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

/**
 * @author Administrator
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class UI
{
    private static Display ourDisplay;

    public static Composite createGridPanel(Composite parent, int fill, int cols) {
	Composite panel = new Composite(parent, SWT.NONE);
	panel.setLayoutData(new GridData(fill));
	panel.setLayout(new GridLayout(cols,false));
	return panel;
    }

    public static ProgressBar createProgressBar(Composite parent, int max) {
	ProgressBar bar = new ProgressBar(parent, SWT.BORDER);
	bar.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
	bar.setMinimum(0);
	bar.setMaximum(max);
	bar.setSelection(0);
	return bar;
    }

    public static Text createField(Composite parent)
    {
	return new Text(parent, SWT.BORDER|SWT.SINGLE);
    }

    public static Label createLabel(Composite parent, String text) {
	Label label = new Label(parent, SWT.WRAP);
	label.setText(text);
	label.setLayoutData(new GridData());
	return label;
    }

    public static Text createWideField(Composite parent) {
	Text t = createField(parent);
	t.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
	return t;
    }

    public static Label createWideLabel(Composite parent, String text) {
	Label label = createLabel(parent, text);
	label.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
	return label;
    }

    private static class TextSetter implements Runnable
    {
	private String text;
	private Control c;

	public TextSetter(Control c, String t)
	{
	    this.c = c;
	    text =t;
	}

	public void run ()
	{
	    if (! c.isDisposed())
	    {
		if (c instanceof Text) ((Text)c).setText(text);
		if (c instanceof Label) ((Label)c).setText(text);
	    }
	}
    }

    private static class ProgressSetter implements Runnable
    {
	private ProgressBar bar;
	private int p;

	public ProgressSetter (ProgressBar bar, int p)
	{
	    this.bar = bar;
	    this.p = p;
	}

	public void run ()
	{
	    if (! bar.isDisposed())
	    {
		bar.setSelection(p);
	    }
	}
    }

    public static void setDisplay (Display d)
    {
	ourDisplay = d;
    }

    public static void asyncSetText(Control c, String text)
    {
	ourDisplay.asyncExec(new TextSetter(c,text));
    }

    public static void asyncSetProgress (ProgressBar bar, int p)
    {
	ourDisplay.asyncExec(new ProgressSetter(bar, p));
    }

    public static void syncExec (Runnable r)
    {
	ourDisplay.syncExec(r);
    }

    public static StyledText createStyledField(Composite parent, int style)
    {
	StyledText ret = new StyledText(parent, SWT.SINGLE);
	StyleRange range = new StyleRange();
	range.fontStyle = style;
	ret.setStyleRange(range);
	return ret;
    }
}
