/*******************************************************************************
 * Copyright (c) 2004 Duke University
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Common Public License v1.0 which accompanies
 * this distribution, and is available at
 * http://www.cs.duke.edu/csed/ambient/copyright.html
 *  
 ******************************************************************************/
package edu.duke.eclipse.weekly.dialogs;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Shell;

public class WeekyOutputViewer extends TitleAreaDialog {

	private Browser myBrowser;
	private Composite myBrowserPane;
    private String myURL;


	
	public WeekyOutputViewer(Shell parentShell, String filePath) {
		super(parentShell);
		this.setShellStyle(SWT.DIALOG_TRIM |SWT.RESIZE);
		myURL = filePath;
	}

	/*
	 * (non-Javadoc) Method declared in Window.
	 */
	protected Control createContents(Composite parent) {
		int sashWidth = 900;
		int sashHeight = 500;
		super.createContents(parent);
		this.setTitle("APT Output Tester ");
		this.setTitleAreaColor(new RGB(0,0,0));
		this.setMessage("The following table contains the analyzed ouput of your program:");
		
		dialogArea.setBounds(10, 0, sashWidth, sashHeight);
		Rectangle rec = dialogArea.getBounds();

		//parent.setBounds(rec);

		myBrowserPane.setBounds(rec.x, rec.y, 900, 500);
		myBrowserPane.setSize(900, 500);
		myBrowser.setSize(900, 500);
		return parent;
	}

	protected Control createDialogArea(Composite parent) {
		createPage(parent);
		return parent;
	}

	protected Control createButtonBar(Composite parent) {
		Composite bar = new Composite(parent, SWT.RIGHT);
		bar.setLayout(new GridLayout(1, false));

		Button OKButton = new Button(bar, SWT.RIGHT);
		OKButton.setText("   Close   ");
		getShell().setDefaultButton(OKButton);
		OKButton.setEnabled(true);
		
		OKButton.addListener(SWT.Selection, new Listener(){
			public void handleEvent(Event event){
				close();
			}
		});

		return bar;
	}
	
	public void createPage(Composite parent) {
		myBrowserPane = new Composite(parent, SWT.BORDER | SWT.SINGLE);
		myBrowserPane.setLayout(new GridLayout());
		GridData data = new GridData(GridData.FILL_BOTH);
		myBrowserPane.setLayoutData(data);
		myBrowserPane.setFont(parent.getFont());
		myBrowser = new Browser(myBrowserPane, SWT.BORDER);
		myBrowser.setUrl(myURL);
	}
}