package edu.duke.eclipse.weekly.ui.actions;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

import edu.duke.eclipse.weekly.WeeklyGlobals;
import edu.duke.eclipse.weekly.dialogs.WeekyOutputViewer;
import edu.duke.eclipse.weekly.util.WeeklyResourceFinder;


public class WeeklyRunApplicationAction extends WeeklySelectionAction {
	private Shell myShell;
	
	public WeeklyRunApplicationAction() {
		super();
	}

	public void setShell(Shell sh){
		myShell = sh;
	}
	
	public void init(IWorkbenchWindow window) {
		//do nothing
	}
	public void dispose() {
		//no need to dispose anything
	}

	public void runWeekly() throws CoreException{
	
		PlatformUI.getWorkbench().saveAllEditors(true);
		WeeklyResourceFinder resFinder =  new WeeklyResourceFinder();
		
		ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
		   ILaunchConfigurationType type =
		      manager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.
		      		ID_JAVA_APPLICATION);
		ILaunchConfiguration[] configurations =
		      manager.getLaunchConfigurations(type);
		
		ILaunchConfigurationWorkingCopy workingCopy =
			type.newInstance(null, "WeeklyLauncher");
		workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME,
				resFinder.getCorrespondingProject().getName());
		workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME,WeeklyGlobals.MAIN_TYPE_NAME);
       
		IPath jarPath = resFinder.getCorrespodningProjectPath().append(WeeklyGlobals.WEEKLY_JAR);
	
		IRuntimeClasspathEntry weeklyJarEntry = JavaRuntime.newArchiveRuntimeClasspathEntry(jarPath);
		   weeklyJarEntry.setClasspathProperty(IRuntimeClasspathEntry.USER_CLASSES);
		
		
		IRuntimeClasspathEntry projectEntry  = 
			JavaRuntime.newProjectRuntimeClasspathEntry
			(JavaCore.create(resFinder.getCorrespondingProject()));

		
		IPath systemLibs = new Path(JavaRuntime.JRE_CONTAINER);
		IRuntimeClasspathEntry systemLibsEntry=
			JavaRuntime.newRuntimeContainerClasspathEntry(systemLibs,
					IRuntimeClasspathEntry.STANDARD_CLASSES);
		
		List classpath = new ArrayList();
		classpath.add(weeklyJarEntry.getMemento());
		classpath.add(systemLibsEntry.getMemento());
		classpath.add(projectEntry.getMemento());
		
		workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH,classpath);
		workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH,false);

		DebugUITools.launch(workingCopy,ILaunchManager.RUN_MODE);
		
		IPath outputFilePath = resFinder.getCorrespodningProjectPath().append(WeeklyGlobals.OUTPUT_FILENAME);
	
		new Thread(new OutputDisplay(outputFilePath.toFile(),myShell),"Display").start();
	}
	
	public static boolean saveDirtyEditors() {
		return (PlatformUI.getWorkbench()).saveAllEditors(true);
	}
	public void run() {
		IWorkbenchWindow wb = PlatformUI.getWorkbench()
				.getActiveWorkbenchWindow();
		if (wb != null) {
			IWorkbenchPage page = wb.getActivePage();
			if (page != null) {
				ISelection selection = page.getSelection();
				//update the selection.
				selectionChanged(null, selection);
			}
		}

		saveDirtyEditors();
		//run the action as null; there is no other action to run besides this
		// one.
		run(null);
	}
	
	public void run(IAction action) {
		try {
			runWeekly();
		} catch (CoreException e) {
			e.printStackTrace();
		}

	}
	
	class OutputDisplay implements Runnable{
		private File myOutputFile;
		private Shell myShell;
		
		OutputDisplay(File outputFile, Shell sh){
			myOutputFile = outputFile;
			myShell =sh;
		}
		
		public void run(){
			final File f = myOutputFile;
			f.delete();
			
			while(!f.exists()){
				try {
					Thread.sleep(1000);
				} catch (InterruptedException e) {
					//wake up
				}
			}
			Display.getDefault().asyncExec(new Runnable(){
				public void run(){
					WeekyOutputViewer viewer = new WeekyOutputViewer(
							myShell,f.getAbsolutePath());
					viewer.open();
					f.delete();
				}
			});
		}
	}
}
