
package edu.duke.eclipse.weekly.util;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

import edu.duke.ambient.AmbientPlugin;

public class WeeklyResourceFinder {
	IResource myResource;

	public WeeklyResourceFinder() throws JavaModelException {
		IEditorPart myCurrentEditor = AmbientPlugin.getWorkbenchPage().getActiveEditor();
        IEditorInput input = myCurrentEditor.getEditorInput();
        IJavaElement je = (IJavaElement) input.getAdapter(IJavaElement.class);
		myResource = je.getCorrespondingResource();
	}
	
	
	/*
	private IResource[] getSiblingResources(IResource res) throws CoreException{
		IResource parent = res.getParent();
		if (parent instanceof IFolder){
			return ((IFolder)parent).members();
		}
		
		if (parent instanceof Project){
			return ((Project)parent).members();
		}
		
		return null;
	}
	*/
	
	
	public IProject getCorrespondingProject() throws JavaModelException{		
		return myResource.getProject();
	}
	
	public IPath getCorrespodningProjectPath(){
		return myResource.getProject().getLocation();
	}
	/*
	public IResource getMain() throws CoreException{
		IResource[] res = getSiblingResources(myResource);
		for (int k=0;k<res.length;k++){
			if (res[k].getName().equalsIgnoreCase(WeeklyGlobals.WEEKLY_MAIN)){
				return res[k];
			}
		}
		
		return null;
	}*/
}
