/*******************************************************************************
 * Copyright (c) 2004 Duke University
 *
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.cs.duke.edu/csed/ambient/copyright.html
 * 
*******************************************************************************/

/*
 * Created on Jun 3, 2003
 *
 */
package edu.duke.submit.eclipse;

import org.eclipse.swt.widgets.*;
import org.eclipse.jface.dialogs.Dialog;
import java.util.*;

/**
 * @author jett
 *
 */
public abstract class ClientWindow extends Dialog implements Listener,Observer
{
	public ClientWindow(Shell sh, EclipseClient ec)
	{
		super(sh);
		myClient = ec;
		//setShellStyle(SWT.DIALOG_TRIM);
	}

	public void update(Observable o, Object arg)
	{
		if(arg.getClass().isInstance(new String()))
		{
			setProgressText((String)arg);
		}
	}
	protected void setProgressText(String prog){};

	public abstract void reEnable();	
	public void handleEvent(Event e){}
	
	protected EclipseClient myClient; 
}
