/*******************************************************************************
 * Copyright (c) 2004 Duke University
 *
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.cs.duke.edu/csed/ambient/copyright.html
 * 
*******************************************************************************/
/*
 * Created on Jun 4, 2003
 * for Duke Eclipse project
 *
 */
package edu.duke.submit.eclipse;

import java.io.*;
import org.eclipse.jface.viewers.*;
/**
 * @author jett
 *
 */
public class FileTreeContentProvider implements ITreeContentProvider
{
	public Object[] getChildren(Object element)
	{
		Object[] kids = ((File)element).listFiles();
		return kids == null ? new Object[0] : kids;
	}
	public Object[] getElements(Object element)
	{
		return getChildren(element);
	}
	public boolean hasChildren(Object element)
	{
		return getChildren(element).length > 0;
	}
	public Object getParent(Object element) throws NullPointerException
	{
		try
		{
			String f = ((File)element).getParent();
			return f;
		}
		catch (ClassCastException e)
		{
			return null;
		}
	}
	public void dispose()
	{
	}
	public void inputChanged(Viewer viewer, Object old_input, Object new_input)
	{
	}
}
