/*******************************************************************************
 * Copyright (c) 2004 Duke University
 *
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.cs.duke.edu/csed/ambient/copyright.html
 * 
*******************************************************************************/
/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package edu.duke.submit.eclipse;
import org.eclipse.jface.preference.*;
import org.eclipse.ui.internal.WorkbenchPlugin;
//import edu.purdue.penumbra.PenumbraPlugin;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.jface.preference.IPreferenceStore;


/**
 * This class represents a preference page that
 * is contributed to the Preferences dialog. By 
 * subclassing <samp>FieldEditorPreferencePage</samp>, we
 * can use the field support built into JFace that allows
 * us to create a page that is small and knows how to 
 * save, restore and apply itself.
 * <p>
 * This page is used to modify preferences only. They
 * are stored in the preference store that belongs to
 * the main plug-in class. That way, preferences can
 * be accessed directly via the preference store.
 */

public class SubmitPreferencePage extends FieldEditorPreferencePage
	implements IWorkbenchPreferencePage 
	{
	public static final String P_HOST = "submit.host";
	public static final String P_PORT = "submit.cs.port";
	

	public SubmitPreferencePage() {
		super(GRID);
		setPreferenceStore(WorkbenchPlugin.getDefault().getPreferenceStore());
		setDescription("Settings for Duke's Submit tool.");
		initializeDefaults();
	}
/**
 * Sets the default values of the preferences.
 */
	private void initializeDefaults() {
		IPreferenceStore store = getPreferenceStore();
		store.setDefault(P_PORT, 31415);
		store.setDefault(P_HOST, "submit.cs.duke.edu");
		return;
	}
	
/**
 * Creates the field editors. Field editors are abstractions of
 * the common GUI blocks needed to manipulate various types
 * of preferences. Each field editor knows how to save and
 * restore itself.
 */

	public void createFieldEditors() {
		addField(new StringFieldEditor(P_HOST, 
				"&Submit server address", getFieldEditorParent()));
		addField(new IntegerFieldEditor(P_PORT, 
				"&Submit server port", getFieldEditorParent()));
	}
	
	public void init(IWorkbench workbench) {
	}
}