package edu.duke.cs.publisher;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Vector;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;

import edu.duke.cs.snarfer.PackageException;
import edu.duke.cs.snarfer.PackageInfo;
import edu.duke.cs.snarfer.PackageSite;
import edu.duke.cs.util.Util;

/**
 * @author jett
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class AddPackageWindow extends JFrame
{
	private PackageSite myPackageSite;
	private JButton myAddButton;
	private JButton myRemoveButton;
	private JButton myOkButton;
	private JButton myCancelButton;
	private JButton myBrowseButton;
	private Vector myFilesToAdd;
	private JComboBox myNameField;
	private JComboBox myVersionField;
	private JComboBox myCategoryField;
	private JComboBox myPublisherField;
	private JComboBox myURLField;	
	private JComboBox myTypeField;	
	private JTextField myLocalField;
	private JTextArea myDescField;
	private JFrame myFrame;
	private JPanel myAddFrame;
	private JList myList;

	private int myRoot;
	private JButton myPlusButton;
	private JButton myMinusButton;
	private JButton myBoxButton;
	private JLabel myRootLabel;
	private JLabel myTypeLabel;
	private boolean myPreserveFlag;
	private JCheckBox myBox;
	private JPanel myTypePanel;
	
	private JCheckBox myDescBox;
	private JButton myDescButton;
	
	
	private static class Windows{
		public static void centerOnScreen(Window window)
		{
			Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
				window.setLocation(
					(d.width-window.getSize().width)/2,
					(d.height-window.getSize().height)/2);
				}
		}
	
	public AddPackageWindow(PackageSite site)
	{
		myPackageSite = site;
		initGui();
		Windows.centerOnScreen(this);
	}
	
	private String ParseCategory(String[] c)
	{
		String s = "";
		for (int k = 0; k < c.length; k++)
		{
			s = s + c[k] + "/";	
		}
		s = s.substring(0, s.length() - 1);
		return s;
	}
	
	private JPanel fileButtons()
	{
		JPanel panel = new JPanel(new BorderLayout());
		panel.add(myAddButton, BorderLayout.NORTH);
		panel.add(myRemoveButton, BorderLayout.SOUTH);
		return panel;
	}
	
	private JPanel filesToAdd()
	{
		JPanel panel = new JPanel();
		panel.add(new JLabel("Files to publish: "), BorderLayout.NORTH);

		Vector choppedFiles = new Vector();
		
		boolean defined = false;
		
		for (int k = 0; k < myFilesToAdd.size(); k++)
		{
			int root = myRoot;
			File file = ((File) myFilesToAdd.get(k));
			String name = file.getName();
			
			if (name.equals(".project"))
			{
				defined = true;
			}
			
			if (myPreserveFlag == false)
			{
				choppedFiles.add(file.getName());
			}
			else
			{
				String path = file.toString();
				path = Util.stripRoot(path);
					
				int j;
				for (j = 0; j < root; j++)
				{
					int i = path.indexOf(File.separatorChar);
					if (i == -1)
					{
						break;
					}
					path = path.substring(i + 1); //chop off the root					
				}	
				choppedFiles.add(path);
			}
		}
		
		JList list = new JList(choppedFiles);
		
		JScrollPane pane = new JScrollPane(list);
		myList = list;
		pane.setPreferredSize(new Dimension(400,200));
		panel.add(pane,BorderLayout.CENTER);
		panel.add(fileButtons(), BorderLayout.EAST);
		
		setTypePanel(defined);
		
		return panel;
	}
	
	private void setTypePanel(boolean set)
	{
		myTypePanel.removeAll();
		if (set == true)
		{
			myTypeLabel = new JLabel("       Eclipse .project file provided.");
			myTypePanel.add(myTypeLabel);
			myFrame.update(myFrame.getGraphics());
			return;
		}
		Vector types = new Vector();
		types.add("C++");
		types.add("C");
		types.add("Java");
		
		myTypeField = new JComboBox(types);
		myTypeField.setSelectedItem("C++");
		myTypeLabel = new JLabel("       Eclipse .project file not provided.     Import project as...");
		myTypePanel.add(myTypeLabel);
		myTypePanel.add(myTypeField);
		myFrame.update(myFrame.getGraphics());
	}
	
	private Box makeFillIns()
	{
		LinkedHashSet usedNames = new LinkedHashSet();
		LinkedHashSet usedVersions = new LinkedHashSet();
		LinkedHashSet usedCategories = new LinkedHashSet();
		LinkedHashSet usedPublishers = new LinkedHashSet();
		LinkedHashSet usedURLs = new LinkedHashSet();
		
		usedURLs.add("");
		usedNames.add("");
		usedVersions.add("");
		usedCategories.add("");
		usedPublishers.add("");
		
		if (myPackageSite != null)
		{
		for (int k = 0; k < myPackageSite.getPackageCount(); k++)
		{
			PackageInfo i = myPackageSite.getPackageInfo(k);
			usedNames.add(i.getName());
			usedVersions.add(i.getVersion());
			usedPublishers.add(i.getPublisher());
			usedCategories.add(ParseCategory(i.getCategory()));
			String url = i.getURL().toString();
			url = url.substring(0,url.lastIndexOf("/"));
			usedURLs.add(url);
		}
		}
		
		myNameField = new JComboBox(usedNames.toArray());
		
		myVersionField = new JComboBox(usedVersions.toArray());
		myCategoryField = new JComboBox(usedCategories.toArray());
		myPublisherField = new JComboBox(usedPublishers.toArray());
		myURLField = new JComboBox(usedURLs.toArray());
		
		myNameField.setPreferredSize(new Dimension(472,22));
		myVersionField.setPreferredSize(new Dimension(472,22));
		myCategoryField.setPreferredSize(new Dimension(472,22));
		myPublisherField.setPreferredSize(new Dimension(472,22));
		myURLField.setPreferredSize(new Dimension(472,22));
		
		myLocalField = new JTextField(36);
		myDescField = new JTextArea(5,30);

		myNameField.setEditable(true);
		myVersionField.setEditable(true);
		myCategoryField.setEditable(true);
		myPublisherField.setEditable(true);
		myURLField.setEditable(true);
		myDescField.setEditable(true);
		myLocalField.setEditable(true);
		
		myNameField.setBorder(new LineBorder(Color.BLACK));;
		myVersionField.setBorder(new LineBorder(Color.BLACK));
		myCategoryField.setBorder(new LineBorder(Color.BLACK));
		myPublisherField.setBorder(new LineBorder(Color.BLACK));
		myURLField.setBorder(new LineBorder(Color.BLACK));
		myDescField.setBorder(new LineBorder(Color.BLACK));
		myLocalField.setBorder(new LineBorder(Color.BLACK));

		myDescField.setLineWrap(true);

		myNameField.setToolTipText("The name associated with this project.\r\n e.g. Foo, Test, or OOGA");
		myVersionField.setToolTipText("The version associated with this project in the form of number dot number (as many as neccessary).\r\n e.g. \"1.0\" or \"1.2.3\"");
		myCategoryField.setToolTipText("The assocation of the project (split by /).\r\n e.g. \"fall03/cps006/lab\", \"spring03/cps104\"\n Used only for display purposes in fetching.");
		myPublisherField.setToolTipText("The author(s) of the project.\n e.g. \"Sam Heald\", \"Ethan Eade\", \"Will Palmeri\".");
		myURLField.setToolTipText("The location on the WWW from which this project will be snarfed. \r\nMust be valid HTML and end with an XML filename.\r\n e.g. \"http://www.cs.duke.edu/foo.xml\"");
		myDescField.setToolTipText("The description of the project, displayed upon fetching");
		myLocalField.setToolTipText("The directory on the local disk where the project will be stored.\n e.g. \"c:/\"");

		Box list = new Box(BoxLayout.Y_AXIS);

		JPanel FlatPanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
		myBox = new JCheckBox();
		myBoxButton = new JButton("Preserve paths");
		myBoxButton.setBorderPainted(false);
		
		myBoxButton.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e) 
			{
				myBox.doClick();
			}
		});
		
		FlatPanel.add(myBox);
		FlatPanel.add(myBoxButton);
		myRootLabel = new JLabel("Preserve parent directories of filepaths.");
		FlatPanel.add(myRootLabel);
		FlatPanel.add(myPlusButton);
		FlatPanel.add(myMinusButton);
		myRootLabel.setEnabled(false);
		myPlusButton.setEnabled(false);
		myMinusButton.setEnabled(false);
		list.add(FlatPanel);


		setTypePanel(false);
		list.add(myTypePanel);

		JPanel NamePanel =  new JPanel(new FlowLayout(FlowLayout.LEFT));
		NamePanel.add(new JLabel("Project Name      : "));
		NamePanel.add(myNameField);
		list.add(NamePanel);
		
		JPanel VersionPanel =  new JPanel(new FlowLayout(FlowLayout.LEFT));
		VersionPanel.add(new JLabel("Project Version  : "));
		VersionPanel.add(myVersionField);
		list.add(VersionPanel);
		
		JPanel PubPanel =  new JPanel(new FlowLayout(FlowLayout.LEFT));
		PubPanel.add(new JLabel("Project Publisher: "));
		PubPanel.add(myPublisherField);
		list.add(PubPanel);
		
		JPanel CategoryPanel =  new JPanel(new FlowLayout(FlowLayout.LEFT));
		CategoryPanel.add(new JLabel("Project Category : "));
		CategoryPanel.add(myCategoryField);
		list.add(CategoryPanel);
		
		
		myDescBox = new JCheckBox();
		JPanel DescPanel2 = new JPanel(new FlowLayout(FlowLayout.LEFT));
		DescPanel2.add(myDescBox);
		DescPanel2.add(new JLabel(" Import description from text file..."));
		DescPanel2.add(myDescButton);
		list.add(DescPanel2);
		
		JPanel DescPanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
		DescPanel.add(new JLabel("Project Description:"));
		list.add(DescPanel);
		list.add(new JScrollPane(myDescField));
		
		JPanel URLPanel =  new JPanel(new FlowLayout(FlowLayout.LEFT));
		URLPanel.add(new JLabel("Project Directory URL: "));
		URLPanel.add(myURLField);
		list.add(URLPanel);
		
		
		JPanel localPanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
		localPanel.add(new JLabel("Save Project To: "));
		localPanel.add(myLocalField);
		localPanel.add(myBrowseButton);
		list.add(localPanel);

		return list;
	}
	
	private JPanel makeSubmitButton()
	{
		myOkButton = new JButton("Ok");
		myCancelButton = new JButton("Cancel");
		JPanel panel = new JPanel();
		panel.add(myOkButton, BorderLayout.CENTER);
		panel.add(myCancelButton, BorderLayout.SOUTH);
		JPanel panel2 = new JPanel();
		panel2.add(panel, BorderLayout.EAST);
		return panel;
	}
	
	private void extractFiles(File dir, Collection files) {
		if (!dir.isDirectory()) {
			files.add(dir);
			return;
		}
		
		File[] embeddedFiles = dir.listFiles();
		for (int k = 0; k < embeddedFiles.length; k++)		
			extractFiles(embeddedFiles[k], files);
	}

	private ArrayList getAllFiles(File[] myFiles)
	{
		ArrayList files = new ArrayList();
		for (int k = 0; k < myFiles.length; k++)
		{
			File f = new File(myFiles[k].toString());
			if (f != null && (f.isFile() || f.isDirectory()))
			{
				extractFiles(f, files);
			}
		}
		return files;
	}
	
	private void Error(String field, String example)
	{
		JOptionPane.showMessageDialog(null,field + " incorrectly specified. For this model, \"" + example + "\"");
	}

	private void AddListeners()
	{
		myCancelButton.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e) 
			{
				myFrame.dispose();	
			}
		});
		
		myOkButton.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e) 
			{
				String name = (String) myNameField.getSelectedItem();
				String desc = myDescField.getText();
				String local = myLocalField.getText();
				Vector files = myFilesToAdd;
				String version = (String) myVersionField.getSelectedItem();
				String url = (String) myURLField.getSelectedItem();
				String publisher = (String) myPublisherField.getSelectedItem();
				String category = (String) myCategoryField.getSelectedItem();
				
				if (local.equals("")) //check local
				{
					Error("Local Directory","C:/");
					return;
				}
				File l = new File(local);
				if (l.exists() == false || l.isDirectory() == false)
				{
					Error("Local Directory","C:/");
					return;
				}
				local = l.getAbsolutePath();
				
				if (version.equals(""))
				{
					Error("Version Number", "1.0.0");
					return;
				}
				String[] v = version.split("."); //check version
				for (int k = 0; k < v.length; k++)
				{
					for (int j = 0; j < v[k].length(); j++)
					{
						char c = v[k].charAt(j);
						if (c < '0' || c > '9')
						{
							Error("Version Number", "1.0.0");
							return;
						}
					}
				}
				
				if (name.equals(""))
				{
					Error("Project Name", "foo");
					return;
				}
				if (desc.equals(""))
				{
					Error("Project Description", "Foo Assignment");
					return;
				}
				if (publisher.equals(""))
				{
					Error("Project Publisher", "Owen Astrachan");
					return;
				}
				
				//check category
				if (category.equals("") || category.indexOf('\\') != -1 || category.indexOf("//") != -1)
				{
					Error("Project Category", "CPS006/assign/");
					return;
				}

				if (url.indexOf("//") == -1)
				{
					url = "http://" + url;
				}
				
				URL u = null;
				try {
					u = new URL(url);
				} catch (MalformedURLException e1) {
					Error("Project URL Directory", "http://www.cs.duke.edu/courses/spring03/cps108/assign/");
					return;
				}
				url = u.toString();
				
				String myFileName = "";
				
				if (url.endsWith(".xml") == false)
				{
					if (url.endsWith("/") == false)
					{
						url += "/";
					}
					
					//made it here so we're all good!!!
				
					String name2 = name.toLowerCase();
					for (int k = 0; k < name2.length(); k++)
					{
						char c = name2.charAt(k);
						if (c == ' ')
						{
							c = '_';
						}
						myFileName += ("" + c);
					}
	
					myFileName += "_";
					for (int k = 0; k < version.length(); k++)
					{
						char c = version.charAt(k);
						if (c == '.')
						{
							c = '_';
						}
						myFileName += ("" + c);
					}
				}
				else
				{
					myFileName = url.substring(url.lastIndexOf("/") + 1, url.lastIndexOf("."));
				}
				
				String jarName = myFileName + ".jar";
				
				File f = new File(local + jarName);
				if (f.exists())
				{
					JOptionPane.showMessageDialog(null, jarName + " already exist in local directory. Please rename your project name or version, or delete those files from the disk.");
					return;
				}
				
				ArrayList tags = new ArrayList();
				tags.add(myPackageSite.getURL().getFile().toString());
				tags.add("-n");
				tags.add(name);
				tags.add("-v");
				tags.add(version);
				tags.add("-d");
				tags.add(desc);
				tags.add("-c");
				tags.add(category);
				tags.add("-p");
				tags.add(publisher);
				tags.add("-u");
				tags.add(url);
				tags.add("-l");
				tags.add(local);
				if (myTypeLabel.getText() != "Eclipse .project file provided.")
				{
					tags.add("-k");
					tags.add(myTypeField.getSelectedItem().toString());
				}
				if (myPreserveFlag == false)
				{
					tags.add("-flat");
				}
				else
				{
					tags.add("-t");
					tags.add(new Integer(myRoot).toString());
				}

				for (int k = 0; k < myFilesToAdd.size(); k++)
				{
					tags.add(((File) myFilesToAdd.get(k)).getPath());					
				}
				
				
				String[] args = new String[tags.size()];
				for (int k = 0; k < tags.size(); k++)
				{
					args[k] = (String) tags.get(k);
				}
				
				Publish p = new Publish(args);
				try {
					p.CommandLinePublisher();
				} catch (PackageException e2) {
					JOptionPane.showMessageDialog(null,"Unable to generate XML document.");
				} catch (IOException e2) {
					JOptionPane.showMessageDialog(null,"Unable to generate XML document.");
				}
				myFrame.dispose();
			}
		});
		
		myRemoveButton.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e) 
			{
				int[] i = myList.getSelectedIndices();
				
				for (int k = 0; k < i.length; k++)
				{
					myFilesToAdd.remove(i[k] - k);
				}
				myFrame.getContentPane().remove(myAddFrame);
				myAddFrame = filesToAdd();
				myFrame.getContentPane().add(myAddFrame, BorderLayout.NORTH);
				myFrame.pack();
				myFrame.update(myFrame.getGraphics());
			}
		});
		
		myAddButton.setToolTipText("Add one or more files to the project.");
		myRemoveButton.setToolTipText("Removes all of the selected files from the list of files to add to the project.");
		myPlusButton.setToolTipText("Preserve more subdirectories from the filepaths.");
		myMinusButton.setToolTipText("Preserve less subdirectories from the filepaths.");
		myBox.setToolTipText("Enable/Disable preservation of file paths when adding files to the project.");
		
		myAddButton.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e) 
			{
				JFileChooser fc = new JFileChooser();
				fc.setMultiSelectionEnabled(true);
				fc.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
				fc.setAcceptAllFileFilterUsed(true);
				fc.setFileHidingEnabled(false);
				fc.setDialogTitle("Add Files to Project");
				JPanel panel = new JPanel();
				fc.showDialog(panel, "Ok");
				
				File[] toAdd = fc.getSelectedFiles();
				ArrayList AddFiles = getAllFiles(toAdd);
				
				for (int k = 0; k < AddFiles.size(); k++)
				{
					myFilesToAdd.add(AddFiles.get(k));	
				}
				myFrame.getContentPane().remove(myAddFrame);
				myAddFrame = filesToAdd();
				myFrame.getContentPane().add(myAddFrame, BorderLayout.NORTH);
				myFrame.pack();
			}
		});	
		
		myBrowseButton.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e) 
			{
				JFileChooser fc = new JFileChooser();
				fc.setDialogTitle("Select local directory");
				fc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);

				JPanel panel = new JPanel();
				fc.showDialog(panel, "Ok");

				File dir = fc.getSelectedFile();
				if (dir == null)
				{
					return;
				}
				myLocalField.setText(dir.getPath());
				myFrame.update(myFrame.getGraphics());
			}
		});	
		
		myPlusButton.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e) 
			{
				myRoot++;
				int max = 0;
				for (int k = 0; k < myFilesToAdd.size(); k++)
				{
					String path = myFilesToAdd.get(k).toString();
					path = Util.stripRoot(path);
					
					int size = 0;
					while (path.indexOf(File.separatorChar) != -1)
					{
						size++;
						path = path.substring(path.indexOf(File.separatorChar) + 1);
					}
					if (max < size)
					{
						max = size;
					}
				}
				if (myRoot > max)
				{
					myRoot = max;
				}
				
				myFrame.getContentPane().remove(myAddFrame);
				myAddFrame = filesToAdd();
				myFrame.getContentPane().add(myAddFrame, BorderLayout.NORTH);
				myFrame.pack();
				//myFrame.update(myFrame.getGraphics());
			}
		});	
		
		myMinusButton.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e) 
			{
				if (myRoot == 0)
					return;
				myRoot--;
				myFrame.getContentPane().remove(myAddFrame);
				myAddFrame = filesToAdd();
				myFrame.getContentPane().add(myAddFrame, BorderLayout.NORTH);
				myFrame.pack();
				//myFrame.update(myFrame.getGraphics());
			}
		});	

		myBox.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e) 
			{
				myPreserveFlag = ! myPreserveFlag;
				if (myPreserveFlag == true)
				{
					myRootLabel.setEnabled(true);
					myPlusButton.setEnabled(true);
					myMinusButton.setEnabled(true);
				}
				else
				{
					myRootLabel.setEnabled(false);
					myPlusButton.setEnabled(false);
					myMinusButton.setEnabled(false);
				}
				myFrame.getContentPane().remove(myAddFrame);
				myAddFrame = filesToAdd();
				myFrame.getContentPane().add(myAddFrame, BorderLayout.NORTH);
				myFrame.pack();
				myFrame.update(myFrame.getGraphics());
			}
		});	
		
		myDescBox.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e) 
			{
				myDescButton.setEnabled(! myDescButton.isEnabled());
			}
		});	
		
		myDescButton.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e) 
			{
				JFileChooser fc = new JFileChooser();
				fc.setDialogTitle("Select description file");
				JPanel panel = new JPanel();
				fc.showDialog(panel, "Ok");
				File file = fc.getSelectedFile();
				if (file == null && file.exists() != false)
				{
					return;
				}
				myDescField.setText(file.getPath());
				myFrame.update(myFrame.getGraphics());
			}
		});	
	}
	
	private void initGui()
	{   	
		myFrame = this;
		myAddButton = new JButton("Add");
		myRemoveButton = new JButton("Remove");
		myBrowseButton = new JButton("Browse");
		myPlusButton = new JButton("Less");
		myMinusButton = new JButton("More");
		myDescButton = new JButton("Browse");
		myDescButton.setEnabled(false);
		myTypeLabel = new JLabel("");
		myTypePanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
		myRoot = 0;
		
		// add components to frame, make it exit when closed
		// default for contentPane is BorderLayout, use this
		myFilesToAdd = new Vector();
		myAddFrame = filesToAdd();
		//setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		getContentPane().add(myAddFrame, BorderLayout.NORTH);
		getContentPane().add(makeFillIns(), BorderLayout.CENTER);
		getContentPane().add(makeSubmitButton(), BorderLayout.SOUTH);
		pack();
		setTitle("Add Project");
		setIconImage(new ImageIcon(this.getClass().getResource("zip.jpg")).getImage());
		setVisible(true);
		setResizable(false);
		
		AddListeners();
	}
}
