/*
 * Created on May 29, 2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
 
package edu.duke.cs.publisher;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;

import edu.duke.cs.snarfer.Package;
import edu.duke.cs.snarfer.PackageEntry;
import edu.duke.cs.snarfer.PackageException;
import edu.duke.cs.snarfer.PackageInfo;
import edu.duke.cs.snarfer.PackageSite;
import edu.duke.cs.util.*;
/**
 * @author jett
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class Publish 
{
	/*
	 * Usage: given a directory "File d = new File(dirName);
	 *    filter files into file array: File[] files = f.listFiles(new NameFilter(filterName));
	 *
	 * @param fileName is the name of the file you wish to filter (ex: "*.cpp", "test.java", "ugly.j*)
	 */
	private class NameFilter implements FileFilter
	{
		private String myFilter;
		public NameFilter(String fileName)
		{
			myFilter = fileName;
		}
		
		public boolean accept(File f) 
		{
			String name = f.getName();
			String filter = myFilter;
			while (name.length() > 0 || filter.length() > 0)
			{
				char c = filter.charAt(0);
				if (c == '*')
				{
					if (filter.length() == 1) //trailing *
						return true;
					while (filter.charAt(0) == '*')
					{
						if (filter.length() == 1) //trailing *
							return true;
						filter = filter.substring(1);
					}
					if (name.indexOf(filter.charAt(0)) == 0)
					{
						return false;
					}
					if (name.indexOf(filter.charAt(0)) != -1)
					{
						name = name.substring(name.indexOf(filter.charAt(0)));
					}
				}
				else
				{
					if (name.charAt(0) != c)
						return false;
					name = name.substring(1);
					filter = filter.substring(1);
				}
			}
			if (name.length() == 0)
				return true;
			return false;
		}
	}
	
	private BufferedReader myReader;
	private PackageSite myPackageSite;
	private String myName;
	private String myVersion;
	private String myDescription;
	private String[] myCategory;
	private String myPublisher;
	private String myType;
	private URL myURL;
	private String myLocal;
	private String myFileName;
	private String myJarName;
	private int myRoot;
	private String[] myFiles;
	private ArgumentParser ap;
	private String[] myArgs;
	
	private String readLine() {
		try {
			return myReader.readLine();
		} catch (IOException e) {
			System.out.println("Unable to read in data from console.");
			System.exit(1);
		}
		return null;
	}
	
	private void getName() {
		if (ap.isSpecified("name"))
			myName = ap.getInfo("name")[0];
		if (myName != null)
			return;
		System.out.println("Enter name of new assignment: ");
		myName = readLine();
	}
	
	private void getVersion() {
		if (ap.isSpecified("version"))
			myVersion = ap.getInfo("version")[0];
		if (myVersion != null)
			return;
		System.out.println("Enter version number: ");
		myVersion = readLine();
	}
	
	private void getDescription() {
		if (ap.isSpecified("description"))
			myDescription = ap.getInfo("description")[0];
		if (myDescription != null)
			return;
		System.out.println("Enter assignment description: ");
		myDescription = readLine();
	}
	
	private void extractDescription()
	{
		File descFile = new File(myDescription);
		if (descFile.exists() == false)
		{
			return;
		}
		
		String d = "";
		
		String line,word;
		StringTokenizer tokenizer = null;
		try
		{
			FileReader r = new FileReader(descFile);
			char[] c = new char[10000];
			
			int x = r.read(c);
			if (x == -1)
			{
				x = 10000;
			}
			for (int k = 0; k < x; k++)
			{
				d += c[k];
			}
		}

		catch (FileNotFoundException e){
		}
		catch (IOException e){
		}
		myDescription = d;
	}
	
	private void getPublisher() {
		if (ap.isSpecified("publisher"))
			myPublisher = ap.getInfo("publisher")[0];
		if (myPublisher != null)
			return;
		System.out.println("Enter publisher name:");
		myPublisher = readLine();
	}
	
	private void getCategory() {
		if (ap.isSpecified("category"))
			myCategory = ap.getInfo("category")[0].split("/");
		if (myCategory != null)
			return;
		System.out.println("Enter a category: ");
		myCategory = readLine().split("/");
	}
	
	private void getURL() {
		if (ap.isSpecified("url")) {
			try {
				String u = ap.getInfo("url")[0];
				if (u.indexOf("//") == -1)
				{
					u = "http://" + u;
				}
				myURL = new URL(u);
			} catch (MalformedURLException e1) {
				System.out.println("***Invalid URL specified***");
				myURL = null;
			}
		}
		while (myURL == null) {
			System.out.println("Enter the full URL of the directory in which this assignment will lay: ");
			try {
				myURL = new URL(readLine());
			} catch (MalformedURLException e) {
				System.out.println("***Invalid URL specified***");
				myURL = null;
			}
		}
		String url = myURL.toString();
		if (url.endsWith("/") == false && url.endsWith(".xml") == false)
		{
			url += "/";
		}
		try {
			myURL = new URL(url);
		} catch (MalformedURLException e) {
		}
	}
	
	private void getLocal() {
		if (ap.isSpecified("local"))
			myLocal = ap.getInfo("local")[0];
		while (myLocal == null ) {
			System.out.println("Enter directory in which to store " + myFileName + " and " + myJarName + " on your computer: ");
			myLocal = readLine();
			File f = new File(myLocal);
			f.mkdirs();
			f.mkdir();
			if (!f.isDirectory()) {
				System.out.println("***Invalid local directory specified***");
				myLocal = null;	
			}
		}
	}
	
	private void getType() {
		if (ap.isSpecified("kind"))
		{
			myType = ap.getInfo("kind")[0].toLowerCase();
			return;
		}
		myType = "";
	}
	
	private String getNextFilename(StringBuffer sb) {
		String ret=null;
		while (sb.length() >0 && sb.charAt(0)==' ')
			sb.deleteCharAt(0);
		if (sb.length() == 0)
			return null;
		if (sb.charAt(0) == '"') {
			sb.deleteCharAt(0);
			int q = sb.indexOf("\"");
			if (q == -1) {
				ret = sb.toString();
				sb.delete(0,sb.length()+1);
				return ret;
			}
			ret = sb.substring(0, q);
			sb.delete(0,q+1);
			return ret;
		}
		int space = sb.indexOf(" ");
		if (space == -1) {
			ret = sb.toString();
			sb.delete(0,sb.length()+1);
			return ret;
		}
		ret = sb.substring(0,space);
		sb.delete(0, space+1);
		return ret;
	}
	
	private void getFiles() {
		String[] filesArray = ap.getExtras();
		if (filesArray.length > 0) {
			myFiles = filesArray;
			return;
		}
		ArrayList filenames = new ArrayList(Arrays.asList(filesArray));	
		System.out.println("Enter files to jar and include in assignment: ");
		StringBuffer sb = new StringBuffer(readLine());
		String filename = getNextFilename(sb);
		while (filename != null) {
			filenames.add(filename);
			filename = getNextFilename(sb);
		}
		myFiles = new String[filenames.size()];
		System.arraycopy(filenames.toArray(), 0, myFiles, 0, myFiles.length);
	}

	private void extractFiles(File dir, Collection files) {
		if (!dir.isDirectory()) {
			files.add(dir);
			return;
		}
		
		File[] embeddedFiles = dir.listFiles();
		for (int k = 0; k < embeddedFiles.length; k++)		
			extractFiles(embeddedFiles[k], files);
	}

	private ArrayList getAllFiles()
	{
		ArrayList files = new ArrayList();
		for (int k = 0; k < myFiles.length; k++)
		{
			File f = new File(myFiles[k]);
			f = new File(f.getAbsolutePath());
			File directory  = f.getParentFile();
			if (f != null && directory != null) 
			{
				NameFilter n = new NameFilter(f.getName());
				File[] filteredFiles = directory.listFiles(n);
				for (int j = 0; j < filteredFiles.length; j++)
				{
					extractFiles(filteredFiles[j], files);
				}
			}
		}
		return files;
	}

	private void makePackage() {
		getURL();
		getName();
		getVersion();
		myFileName = "";
		
		System.out.println(myURL.toString());
		if (myURL.toString().endsWith(".xml") == false)
		{
			String name = myName.toLowerCase();
			for (int k = 0; k < name.length(); k++)
			{
				char c = name.charAt(k);
				if (c == ' ')
				{
					c = '_';
				}
				myFileName += ("" + c);
			}
	
			myFileName += "_";
			for (int k = 0; k < myVersion.length(); k++)
			{
				char c = myVersion.charAt(k);
				if (c == '.')
				{
					c = '_';
				}
				myFileName += ("" + c);
			}
		}
		else
		{
			myFileName = myURL.toString().substring(myURL.toString().lastIndexOf("/") + 1, myURL.toString().lastIndexOf("."));
		}
		
		myJarName = myFileName + ".jar";
		myFileName += ".xml";

		String url = myURL.toString() + myFileName;
		try {
			myURL = new URL(url);
		} catch (MalformedURLException e1) {
		}

		for (int k = 0; k < myPackageSite.getPackageCount(); k++) {
			PackageInfo p = (PackageInfo) myPackageSite.getPackageInfo(k);
			String xName = p.getURL().toString(); 
			if (xName.equals(myURL.toString())) {
				System.out.println("Found old assignment with this URL: ");
				System.out.println("\t"+p.getName()+" "+p.getVersion());
				System.out.println("Replace this assignment? (y/n)");
				String answer = readLine().toLowerCase();
				if (!(answer.equals("yes") || answer.equals("y")))
					return;
				myPackageSite.removePackageInfo(k);
			}
		}
	
		getDescription();
		getPublisher();
		getCategory();
		
		getLocal();	
		getType();
		getFiles();
		
		ArrayList entries = new ArrayList();	
		ArrayList jarEntries = new ArrayList();
		
		extractDescription();
		
		
		File dir = new File(myLocal);
		dir.mkdirs();
		dir.mkdir();
		
		ArrayList files = getAllFiles();
		Set s = new HashSet(files);
		files = new ArrayList(s);
		for (int i=0;i<files.size();i++)
			System.out.println("Added " + files.get(i) + " to " + myJarName);		
		if (files.size() == 0)
			System.out.println("No files meet the criteria.");
		
		if (ap.isSpecified("treeroot"))
		{
			String root = ap.getInfo("treeroot")[0];
			Integer i = new Integer(root);
			myRoot = i.intValue();
		}
		
		try {
			JarOutputStream myJarOutput;
			File outFile = new File(dir.getPath(),myJarName);
			myJarOutput = new JarOutputStream(new FileOutputStream(outFile));			
			BufferedInputStream myInput;
			File tFile;
			for (int i=0;i<files.size();i++) {
				tFile = (File) files.get(i);
				myInput = new BufferedInputStream(new FileInputStream(tFile));
				
				String path = null;
				int root = myRoot;
			
				if (ap.isSpecified("flat"))
				{
					path = tFile.getName();
				}
				else if (ap.isSpecified("treeroot"))
				{
					path = tFile.toString();
					path = Util.stripRoot(path);
					
					int j;
					for (j = 0; j < root; j++)
					{
						int index = path.indexOf(File.separatorChar);
						if (index == -1)
						{
							break;
						}
						path = path.substring(index + 1); //chop off the root						
					}
				}
				else
				{
					String curdir = System.getProperty("user.dir");
					path = tFile.toString();
					if (path.indexOf(curdir) == 0)
					{
						path = path.substring(curdir.length() + 1);
					}
					else
					{
						path = tFile.getName();
					}
				}
				
				JarEntry newEntry = new JarEntry(path);
				newEntry.setSize(tFile.length());
				newEntry.setTime(tFile.lastModified());
				myJarOutput.putNextEntry(newEntry);					
				Util.copy(myInput, myJarOutput);
				myInput.close();
				myJarOutput.closeEntry();
			}
			myJarOutput.close();
		}		
		catch (IOException e) {
			e.printStackTrace();
			System.out.println("Unable to make file: " + myJarName);
		}
		try {
			URL jarURL = new URL(myURL.toString().substring(0,myURL.toString().lastIndexOf("/") + 1) + myJarName); 
			entries.add(new PackageEntry(jarURL, true));
		} catch (MalformedURLException e2) {
			System.out.println("Invalid URL specified for: " + myJarName);
		}
		PackageInfo info = new PackageInfo(myName, myVersion, myPublisher, myCategory, myURL, myType);
		Package pkg = new Package(info, entries, myDescription);
		myPackageSite.addPackageInfo(info);
		File xmlFile = new File(myLocal, myFileName);
		try {
			Util.writeXML(Util.openOutput(xmlFile), pkg.toDOM());
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
	}
	
	private void removePackage()
	{
		getURL();
		myPackageSite.removePackageInfo(myURL);
	}
	
	private void Help()
	{
		System.out.println("Usage:");
		System.out.println("\t Publish \" root filename\" -flags files");
		System.out.println("Possible Flags (Can be abbreviated to one letter:");
		System.out.println("-name [name of project]");
		System.out.println("-version [version of project]");
		System.out.println("-description [description of project]");
		System.out.println("-category [category of new assignment");
		System.out.println("-publisher [publisher of new assignment");
		System.out.println("-url [directory url where assignment will be snarfed.");
		System.out.println("-local [location on disk to store created xml and jar files]");
		System.out.println("-remove [URL on the web to remove from root XML file]");
		System.out.println("-flat (make file paths flat)");
		System.out.println();
		System.out.println("Example: Publish projects.xml -v 1.0.1 project/*.cpp project/*.h");
		System.out.println("\t Neccessary information that is omitted will be prompted for.");
		
	}
	
	public void CommandLinePublisher() throws PackageException, IOException
	{	
		if (myArgs.length == 0) {
			System.out.println("Must specify a project site XML file, if it does not exist, it will be created for you.");
			Help();
			return;
		}
		String fileName = myArgs[0];
		if (fileName.endsWith(".xml") == false)
		{
			System.out.println("Invalid root Project site specified");
		}
	
		String[] real = new String[myArgs.length - 1];
		for (int k = 1; k < myArgs.length; k++)
		{
			real[k-1] = myArgs[k];
		}
	
		myName = null;
		myVersion = null;
		myDescription = null;
		myCategory = null;
		myPublisher = null;
		myURL = null;
		myLocal = null;
		myJarName = null;
		myFiles = null;
		myFileName = null;
		myType = null;
	
		Argument[] tags = new Argument[]{
			new Argument("name", 1),
			new Argument("version", 1),
			new Argument("description", 1),
			new Argument("category", 1),
			new Argument("publisher", 1),
			new Argument("url", 1),
			new Argument("local",1),
			new Argument("remove", 1),
			new Argument("treeroot", 1),
			new Argument("flat", 0),
			new Argument("kind", 1)
		};
		
		ap = new ArgumentParser(tags,real);
		myReader = new BufferedReader(new InputStreamReader(System.in));	


		File f = new File(fileName);
		f = new File(f.getAbsolutePath());
		
		if (!f.exists()) {
			System.out.print("This file does not exist, do you wish to create a new project site file? (y/n) ");
			String answer = myReader.readLine().toLowerCase();
			if (! answer.equals("yes") && !answer.equals("y"))
				return;
			System.out.println("Type a name for this collection of projects: ");
			String name = readLine();
		
			myPackageSite = new PackageSite(name, new ArrayList());
		}
		else
			myPackageSite = new PackageSite(f.toURL());
		System.out.println("Site has "+myPackageSite.getPackageCount()+" projects.");
		if (ap.isSpecified("remove") == true) {
			removePackage();
			return;
		}
		makePackage();
		System.out.println("Writing "+f+"...");
		OutputStream siteOut = Util.openOutput(f);
		Util.writeXML(siteOut, myPackageSite.toDOM());
		System.out.println("Done.");
	}

	public Publish(String[] args) 
	{
		myArgs = args;
	}

	public static void main(String[] args)
	{		
		try {
			Publish p = new Publish(args);
			p.CommandLinePublisher();
		} catch (PackageException e) {
			System.out.println("Invalid XML in root project file.");
		} catch (IOException e) {
			System.out.println("Unable to generate root project file.");
		}
	}
}
