package edu.duke.cs.publisher;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;

import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.table.AbstractTableModel;

import edu.duke.cs.snarfer.PackageException;
import edu.duke.cs.snarfer.PackageInfo;
import edu.duke.cs.snarfer.PackageSite;
import edu.duke.cs.util.Util;


/**
 *
 * This is the GUI version of Publish, the command-line program that
 * will generate the XML and Jar associated with a Package (that information
 * can then be put on the web for students to access via Eclipse.) 
 */

public class Publisher  extends JFrame
{		
	private JButton myNewButton; 
	private JButton myOpenButton;
	private JButton myAddButton;
	private JButton myDelButton;
	private JButton myNameButton; 
	private JButton myPublisherButton;
	private JButton myVersionButton;
	private JPanel myBrowser;
	private JPanel myBottomPanel;
	private JTable myTable;
	private PackageSite myPackageSite;
	public Publisher()
	{
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		initGui();
		setTitle("Project Publisher");
		setIconImage(new ImageIcon(this.getClass().getResource("zip.jpg")).getImage());
		Windows.centerOnScreen(this);
		pack();
		setVisible(true);
	}
	
	private static class Windows{
		public static void centerOnScreen(Window window)
		{
			Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
				window.setLocation(
					(d.width-window.getSize().width)/2,
					(d.height-window.getSize().height)/2);
				}
		}

	private void makeMenu()
	{
		JMenu fileMenu = new JMenu("File");
	
		JMenu goMenu = new JMenu("Actions");
	
		JMenu helpMenu = new JMenu("Help");
	
		JMenuBar menubar = new JMenuBar();

		menubar.add(fileMenu);
		menubar.add(goMenu);
		menubar.add(helpMenu);
		
		fileMenu.add(new AbstractAction("New Project Site...")
		{	
			public void actionPerformed(ActionEvent e) 
			{
				doNew();
			}
		});

		fileMenu.add(new AbstractAction("Open Project Site...")
		{	
			public void actionPerformed(ActionEvent e) 
			{
				doOpen();
			}
		});		
		
		fileMenu.add(new AbstractAction("Close Project Site")
		{	
			public void actionPerformed(ActionEvent e) 
			{
				doClose();
			}
		});		
		
		goMenu.add(new AbstractAction("Add Project")
		{	
			public void actionPerformed(ActionEvent e) 
			{
				myAddButton.doClick();
			}
		});		

		goMenu.add(new AbstractAction("Remove Project")
		{	
			public void actionPerformed(ActionEvent e) 
			{
				myDelButton.doClick();
			}
		});
		
		goMenu.add(new AbstractAction("Make Stand-Alone Project")
		{	
			public void actionPerformed(ActionEvent e) 
			{
				new AddPackageWindow(null);
			}
		});

		helpMenu.add(new AbstractAction("About")
		{	
			public void actionPerformed(ActionEvent e) 
			{
				JOptionPane.showMessageDialog(null, "Duke Computer Science Dept. \n http://www.cs.duke.edu \n Summer 2003");
			}
		});	

		setJMenuBar(menubar);
	}
	
	protected class XMLFilter extends javax.swing.filechooser.FileFilter 
	{
		public boolean accept(File file) {
			if (file.isDirectory())
				return true;
			String filename = file.getName();
			return (filename.endsWith(".xml") || filename.indexOf('.') == -1);
		}
		public String getDescription() {
			return "*.xml";
		}
	}

	private void doDel()
	{
		final JFrame frame = new JFrame();
		
		JLabel sure = new JLabel("Are you sure you wish to remove this project from your root site?");
		JLabel disclaimer = new JLabel("NOTE: No files will be physically deleted.");

		JButton yesButton = new JButton("YES");
		JButton noButton = new JButton("NO");

		JPanel buttons = new JPanel(new FlowLayout(FlowLayout.CENTER));
		buttons.add(yesButton);
		buttons.add(noButton);

		yesButton.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e) 
			{
				int row = myTable.getSelectedRow();
				System.out.println(row);
				if (row == -1)
				{
					frame.dispose();
					return;
				}	
				myPackageSite.removePackageInfo(row);
				OutputStream siteOut = null;
				try {
					siteOut = Util.openOutput(new File(myPackageSite.getURL().getFile()));
				} catch (FileNotFoundException e1) {
					JOptionPane.showMessageDialog(null,"Unable to open Project Site.");
				}
				Util.writeXML(siteOut, myPackageSite.toDOM());
				update();
				frame.dispose();
			}
		});

		noButton.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e) 
			{
				frame.dispose();
			}
		});		
		frame.getContentPane().add(sure,    BorderLayout.NORTH);
		frame.getContentPane().add(disclaimer, BorderLayout.CENTER);
		frame.getContentPane().add(buttons,BorderLayout.SOUTH);
		frame.pack();
		Windows.centerOnScreen(frame);
		frame.setVisible(true);

	}
	

	private void doClose()
	{
		myPackageSite = null;
		update();
	}

	private void doOpen()
	{    	
		JFileChooser fc = new JFileChooser(new File(System.getProperty("user.dir")));
		fc.addChoosableFileFilter(new XMLFilter());
		fc.setApproveButtonText("OK");
		fc.setDialogTitle("Open Project Site");
		fc.showOpenDialog(new JFrame());
		File f = fc.getSelectedFile();
    	try {
    		if (f == null)
    		{
    			return;
    		}
			myPackageSite = new PackageSite(f.toURL());

			update();

		} catch (MalformedURLException e) {
			JOptionPane.showMessageDialog(null,"Invalid file selected.");
		} catch (PackageException e) {
			JOptionPane.showMessageDialog(null,"Invalid Project Site chosen.");
		}	
	}
	
	protected class MakeFileAction extends AbstractAction 
	{
		JTextField myNameField;
		File myFile;
		JFrame myFrame;
		Publisher myPub;
    
		MakeFileAction(JTextField NameField, File file, JFrame frame, Publisher p) 
		{
			super("Make Project Site");
			myNameField = NameField;
			myFile = file;
			myFrame = frame;
			myPub = p;
		}
    
		public void actionPerformed(ActionEvent evt) 
		{
			// Show dialog; this method does not return until dialog is closed
			String name = myNameField.getText();
			
			myPackageSite = new PackageSite(name, myFile);
			OutputStream siteOut = null;
			try {
				siteOut = Util.openOutput(myFile);
			} catch (FileNotFoundException e1) {
				JOptionPane.showMessageDialog(null,"Could not make file.");
			}
			
			Util.writeXML(siteOut, myPackageSite.toDOM());

			myFrame.dispose();
			
			myPub.update();
		}
	};

    private void doNew()
    {
    	JFileChooser fc = new JFileChooser(new File(System.getProperty("user.dir")));
    	fc.setDialogTitle("New Project Site");
    	fc.setSelectedFile(new File("root.xml"));
		fc.setApproveButtonText("OK");
		fc.setApproveButtonToolTipText("Make new root site");
		fc.addChoosableFileFilter(new XMLFilter());
		fc.showOpenDialog(new JFrame());
    	File f = fc.getSelectedFile();
    	
    	if (f == null)
    		return;
    	
    	if (f.getPath().indexOf(".") == -1)
    	{
    		System.out.println(f.getPath() + ".xml");
    		f = new File (f.getPath() + ".xml");
    	}
    	
    	if (f.getName().endsWith(".xml") == false || f.exists() == true)
    	{
			JOptionPane.showMessageDialog(null,"Invalid file specified!");
    		return;
    	}

		JFrame j = new JFrame();
		JTextField NameField = new JTextField(35);
		NameField.setToolTipText("The name of the Project Site, e.g. \"CPS108\"");
		NameField.setBorder(new LineBorder(Color.BLACK));
		
		JPanel npanel = new JPanel();
		npanel.add(new JLabel("Name of Project Site: "), BorderLayout.NORTH);
		npanel.add(NameField, BorderLayout.CENTER);
	
		JPanel panel = new JPanel(new BorderLayout());
		panel.add(npanel, BorderLayout.NORTH);

		JButton makeButton = new JButton(new MakeFileAction(NameField, f, j, this));
		
		JPanel bottom = new JPanel();
		bottom.add(makeButton, BorderLayout.EAST);
		
		j.getContentPane().add(panel, BorderLayout.CENTER);
		j.getContentPane().add(bottom, BorderLayout.SOUTH);
		j.pack();
		j.setTitle("Enter Project Site Information");
		j.setVisible(true);
		j.setResizable(false);
		Windows.centerOnScreen(j);
    }
    
    private void doAdd()
    {
    	if (myPackageSite == null)
    	{
    		return;	
    	}
    	AddPackageWindow add = new AddPackageWindow(myPackageSite);

		
		add.addWindowListener(new WindowAdapter()
		{
			public void windowClosed(WindowEvent e)
			{
				try {
						myPackageSite.update();
					} catch (PackageException e2) {
					JOptionPane.showMessageDialog(null,"Unable to edit Project Site");
					}
					update();
			}
		});
    }
  
    public void update()
    {
		this.getContentPane().remove(myBrowser);
		this.getContentPane().remove(myBottomPanel);
		initGui();
		if (myPackageSite != null)
		{
			URL url = myPackageSite.getURL();
			String f = new File(url.toString()).getName();
			this.setTitle("Project Publisher - " + f);
		}
    }
    
	private JPanel makeButtons()
	{
		
		myNewButton = new JButton(new ResizableIcon(this.getClass().getResource("new.jpg")));
		myOpenButton = new JButton(new ResizableIcon(this.getClass().getResource("open.jpg")));
		myAddButton = new JButton(new ResizableIcon(this.getClass().getResource("add.jpg")));
		myDelButton = new JButton(new ResizableIcon(this.getClass().getResource("delete.jpg")));

		myNewButton.setPreferredSize(new Dimension(56,56));
		myOpenButton.setPreferredSize(new Dimension(56,56));
		myAddButton.setPreferredSize(new Dimension(56,56));
		myDelButton.setPreferredSize(new Dimension(56,56));
		
		myNewButton.setBorderPainted(false);
		myOpenButton.setBorderPainted(false);
		myAddButton.setBorderPainted(false);
		myDelButton.setBorderPainted(false);
		
		myNewButton.setRolloverEnabled(true);
		myOpenButton.setRolloverEnabled(true);
		myAddButton.setRolloverEnabled(true);
		myDelButton.setRolloverEnabled(true);
		
		// add listener so backButton calls doBack()
		myDelButton.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e) 
			{
				doDel();
			}
		});

		myOpenButton.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e) 
			{
				doOpen();
			}
		});

		// add listener so nextButton calls doNew()
		myNewButton.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e) 
			{
				doNew();
			}
		});	
	    
		myAddButton.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e) 
			{
				doAdd();			}
		});	
		
	    
		JPanel buttonpanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
		buttonpanel.add(myNewButton);
		buttonpanel.add(myOpenButton);
		buttonpanel.add(myAddButton);
		buttonpanel.add(myDelButton);
		buttonpanel.setBackground(Color.WHITE);
		return buttonpanel;
	}
	

	protected class MyTableModel extends AbstractTableModel 
	{
		final String[] columnNames = {"Project Name", 
									  "Publisher",
									  "Version",
									  "Category"};
									  
		private Object[][] data;

		private String ParseCategory(String[] c)
		{
			String s = "";
			for (int k = 0; k < c.length; k++)
			{
			 	s = s + c[k] + "/";	
			}
			s = s.substring(0, s.length() - 1);
			return s;
		}
		
		public MyTableModel(PackageInfo[] infos)
		{
			if (infos == null)
			{
				data = new Object[0][0];
			}
			else
			{
				data = new Object[infos.length][4];
				for (int k = 0; k < infos.length; k++)
				{
					data[k][0] = infos[k].getName();
					data[k][1] = infos[k].getPublisher();
					data[k][2] = infos[k].getVersion();
					data[k][3] = ParseCategory(infos[k].getCategory());		
				}
			}
		}

		public int getColumnCount() {
			return columnNames.length;
		}
        
		public int getRowCount() {
			return data.length;
		}

		public String getColumnName(int col) {
			return columnNames[col];
		}

		public Object getValueAt(int row, int col) {
			return data[row][col];
		}
		
		public boolean isCellEditable(int row, int col)
		{
			return false;
		}
	}

	private JScrollPane fillPackages()
	{
		PackageInfo[] info = null;
		if (myPackageSite != null)
		{
			if (myPackageSite.getPackageCount() != 0)
			{
				info = new PackageInfo[myPackageSite.getPackageCount()];
				for (int k = 0; k < myPackageSite.getPackageCount(); k++)
				{
					info[k] = myPackageSite.getPackageInfo(k);
				}
			}
		}

		MyTableModel myModel = new MyTableModel(info);
		TableSorter sorter = new TableSorter(myModel); //ADDED THIS
		//JTable table = new JTable(myModel);          //OLD
		myTable = new JTable(sorter);             //NEW
		sorter.addMouseListenerToHeaderInTable(myTable); //ADDED THIS
		myTable.setPreferredScrollableViewportSize(new Dimension(600, 400));

		//Create the scroll pane and add the table to it. 
		JScrollPane scrollPane = new JScrollPane(myTable);
		return scrollPane;
	}
	
	private JPanel makeTable()
	{
		JPanel browser = new JPanel(new BorderLayout());
		browser.add(fillPackages(), BorderLayout.CENTER);
		return browser;
	}
	
	private JPanel Help1()
	{
		JPanel panel = new JPanel();
		Box list = new Box(BoxLayout.Y_AXIS);
		list.add(new JLabel(" "));
		list.add(new JLabel("Steps to make a new Project site:"));
		list.add(new JLabel(" 1) Click the NEW button"));
		list.add(new JLabel(" 2) Browse to the directory in which to store the Project site XML file."));
		list.add(new JLabel(" 3) Type in the name of XML file to generate."));
		list.add(new JLabel(" 4) When the new window opens, fill in the name & description of the new Project site."));
		list.add(new JLabel(" "));
		list.add(new JLabel("Steps to open an existing Project site:"));
		list.add(new JLabel(" 1) Click the Open button"));
		list.add(new JLabel(" 2) Browse to the directory in which to store the Project site XML file."));
		list.add(new JLabel(" "));
		list.add(new JLabel(" "));
		list.setEnabled(false);
		panel.add(list);
		panel.setBorder(new LineBorder(Color.BLACK));
		return panel;
	}
	
	private JPanel Help2()
	{
		JPanel panel = new JPanel();
		Box list = new Box(BoxLayout.Y_AXIS);
		list.add(new JLabel(" "));
		list.add(new JLabel("Steps to add projects  to an empty Project site:"));
		list.add(new JLabel(" 1) Click the ADD button"));
		list.add(new JLabel(" 2) Choose the files you wish to include in the project, choosing to preserve the root or not."));
		list.add(new JLabel(" 3) Fill in the properties of this project"));
		list.add(new JLabel(" 4) Indicate the absolute URL of the project as placed on the web."));
		list.add(new JLabel(" 5) Indicate the local directory in which to store the new project."));
		list.add(new JLabel(" 6) Post the projects & the project site on the web."));
		list.add(new JLabel(" "));
		list.add(new JLabel(" "));
		list.setEnabled(false);
		panel.add(list);
		panel.setBorder(new LineBorder(Color.BLACK));
		return panel;
	}
	
	
	private void initGui()
	{   	
	// add components to frame, make it exit when closed
	// default for contentPane is BorderLayout, use this
	
		this.getContentPane().add(makeButtons(),    BorderLayout.NORTH);
		myBrowser = makeTable();
		myBottomPanel = makeBottomPanel();
		if (myPackageSite != null)
		{
			if (myPackageSite.getPackageCount() == 0)
			{
				myBrowser = Help2();
			}
		}
		else
		{
			myBrowser = Help1();
		}
		this.getContentPane().add(myBrowser,    BorderLayout.CENTER);
		this.getContentPane().add(myBottomPanel, BorderLayout.SOUTH);
		makeMenu();
		pack();

	}
	
	private JPanel makeBottomPanel()
	{
		if (myPackageSite != null)
		{
			return new JPanel();
		}
		JLabel instructions = new JLabel("Choose \"New\" to create or \"Open\" to open a Project Site");
		JPanel bottomPanel = new JPanel(new BorderLayout());
		bottomPanel.add(instructions, BorderLayout.WEST);
		return bottomPanel;
	}
    
	public static void main(String[] args) 
	{
		Publisher b = new Publisher();
	}
}
