package edu.duke.cs.publisher;

import java.awt.Component;
import java.awt.Graphics;
import java.net.URL;

import javax.swing.ImageIcon;

public class ResizableIcon extends ImageIcon
{
	public ResizableIcon(String s)
	{
		super(s);
	}
	public ResizableIcon(URL url)
	{
		super(url);
	}
	
    /**
     * paints the Icon onto the Component
     * @param c is the Component to which you would like to resize your icon on
     * @param g is the Graphics with which you use to draw the image
     * @param x is the x pos
     * @param y is the y pos
     */

    public void paintIcon(Component c, Graphics g, int x, int y)
    {
		int w = c.getWidth();
		int h = c.getHeight();
		g.drawImage(this.getImage(), 0, 0, w, h, c);
    }
    
}
