/*
 * Created on Jun 11, 2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package edu.duke.cs.snarfer;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;

import edu.duke.cs.snarfer.ClientEngine;
import edu.duke.cs.snarfer.FetchListener;
import edu.duke.cs.snarfer.PackageEntry;
import edu.duke.cs.snarfer.PackageException;
import edu.duke.cs.snarfer.PackageInfo;
import edu.duke.cs.snarfer.PackageSite;
/**
 * @author Administrator
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class Client implements FetchListener
{
    private BufferedReader reader;
    private int overwriteFlag;

    public Client (BufferedReader reader)
    {
         this.reader = reader;
         overwriteFlag = 0;
    }

    public static void main (String[] args)
    {
        ClientEngine engine = new ClientEngine ();
        try
	{
            String url = args[0];
            if (! url.endsWith(".xml"))
            {
                if (! url.endsWith("/"))
                {
                    url += "/";
                }
                url += "root.xml";
            }
            if (url.indexOf("//") == -1)
            {
                url = "http://" + url;
            }
            PackageSite site = new PackageSite(new URL(url));
            System.out.println("Site: " + site.getName());
            engine.addSite(site);
        }
        catch (MalformedURLException e)
	{
            System.err.println("Bad site URL");
            System.exit(1);
        }
        catch (PackageException e)
	{
            System.out.println(e);
            System.exit(1);
        }
        engine.refreshIndex();
    
        Set infoCollection = engine.getPackageInfos();
        Object[] infoObjects = infoCollection.toArray();
        PackageInfo[] infos = new PackageInfo[infoObjects.length];
        int i;
        for (i=0;i<infos.length;i++)
            infos[i] = (PackageInfo)infoObjects[i];
        for (i=0; i<infos.length;i++) {
            System.out.print((i+1)+"\t");
            for (int j=0;j<infos[i].getCategory().length;j++) {
                System.out.print(infos[i].getCategory()[j]+"/");
            }
            System.out.println(infos[i].getName()+" [Version "+infos[i].getVersion()+", publisher '"+infos[i].getPublisher()+"']");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        int choice=0;
        System.out.println("Enter a project number:");
        while (choice == 0)
	{
            try
	    {
                String choiceStr = reader.readLine();
                choice = Integer.parseInt(choiceStr);
            }
            catch (NumberFormatException e)
	    {
                System.out.println("Enter a valid package number:");
                choice = 0;
            }
            catch (IOException e)
	    {
                e.printStackTrace();
                System.exit(1);
            }
            if (choice > infos.length)
	    {
                choice = 0;
	    }
        }
        choice--;
        Package pkg = null;
        try {
            pkg = new Package(infos[choice]);
        } catch (PackageException e) {
            System.err.println("Unable to retrieve project description: "+e);
            System.exit(1);
        }
        System.out.println("Project information for '"+pkg.getInfo().getName()+"':");
        System.out.println("Version:    "+pkg.getInfo().getVersion());
        System.out.println("Publisher:  "+pkg.getInfo().getPublisher());
        System.out.println("Description: ");
        System.out.println("\t"+pkg.getDescription());
        System.out.println("Continue with installation? (y/n)");
        try {
            String answer = reader.readLine().toLowerCase();
            if (!answer.equals("yes") && !answer.equals("y"))
                System.exit(0);
        } catch (IOException e1) {
            System.exit(1);
        }
        System.out.println("Enter directory to download "+pkg.getInfo().getName()+" to:");
        File dir = null;
        while (dir == null) {
            try {
                dir = new File(reader.readLine());
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
            if (!dir.exists()) {
                dir.mkdirs();
                dir.mkdir();
            }
            if (!dir.exists() || !dir.isDirectory()) {
                System.out.println("You must enter a directory that exists or can be created:");
                dir = null;
            }
        }
        try {
            engine.fetchPackage(new Package(infos[choice]), dir, new Client(reader));
            System.out.println("Done.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onArchivedFileProgress (int bytes)
    {
    }

    public void onBeginArchivedFile (PackageEntry archive, File f, long size)
    {
        System.out.println("Extracting " + f.getName() + " from archive...");
    }

    public void onBeginEntry (PackageEntry entry, long size)
    {
        System.out.println("Getting "+(entry.isArchive()?"archive":"file")
            +" from "+entry.getURL()+", "+size/1024+" KB...");
    }

    public void onEntryInstalled (PackageEntry entry)
    {
    }

    public void onEntryProgress (int bytes)
    {
    }

    public boolean onFileExists (File f)
    {
        if (overwriteFlag == 1)
            return true;
        if (overwriteFlag == -1)
            return false;

        System.out.println("Overwrite file '"+f.getAbsolutePath()+"'? (y/n/ya/na)");
        while (true)
	{
	    try
	    {
		String s = reader.readLine().toLowerCase();
		if (s.equals("n")) return false;
		if (s.equals("y")) return true;
		if (s.equals("na")) {
		    overwriteFlag = -1;
		    return false;
		}
		if (s.equals("ya")) {
		    overwriteFlag = 1;
		    return true;
		}
		System.out.println("Enter y, n, ya, or na: ");
	    }
	    catch (IOException e)
	    {
		System.err.println(e);
		System.exit(1);
	    }
	}
    }

    public void onFileInstalled (File f)
    {
    }
}
