/*
 * Created on May 29, 2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package edu.duke.cs.snarfer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

import edu.duke.cs.snarfer.FetchListener;
import edu.duke.cs.snarfer.PackageEntry;
import edu.duke.cs.snarfer.PackageException;
import edu.duke.cs.snarfer.PackageInfo;
import edu.duke.cs.snarfer.PackageSite;
import edu.duke.cs.util.Util;
/**
 * @author jett
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class ClientEngine
{
    private ArrayList sites;
    private Set infos;
    private Map siteMap;
    private Map infoMap;
    
    public ClientEngine ()
    {
        sites = new ArrayList();
        infos = new TreeSet();
        siteMap = new HashMap();
        infoMap = new HashMap();
    }

    public void addSite (URL siteURL)
	throws PackageException
    {
        sites.add(new PackageSite(siteURL));
    }

    public void addSite (PackageSite site)
    {
        sites.add(site);
    }

    public void removeSite (URL siteURL)
    {
    }

    public void refreshIndex ()
    {
        infos.clear();
        siteMap.clear();
        infoMap.clear();

        for (int i = 0; i < sites.size(); i++)
	{
            PackageSite site = (PackageSite)sites.get(i);
            for (int j = 0; j < site.getPackageCount(); j++)
	    {
                PackageInfo info = site.getPackageInfo(j);
                infos.add(info);
                if (j == 0)
                    siteMap.put(site, new HashSet());
                ((Collection)siteMap.get(site)).add(info);
                infoMap.put(info, site);
            }
        }
    }

    public Collection getSites ()
    {
        return sites;
    }

    public PackageSite getSiteFor (PackageInfo info)
    {
        return (PackageSite)infoMap.get(info);
    }

    public Collection getPackageInfosFor (PackageSite site)
    {
        return (Collection)siteMap.get(site);
    }

    public Set getPackageInfos ()
    {
        return infos;
    }

    public void fetchPackage (PackageInfo info, File prefix) 
        throws PackageException, IOException, InterruptedException
    {
        fetchPackage(new Package(info), prefix, null);
    }

    public void fetchPackage (Package pkg, File prefix, FetchListener listener) 
        throws PackageException, IOException, InterruptedException
    {
        if (!prefix.exists() && prefix.isDirectory())
            throw new FileNotFoundException("'"+prefix+"' is not a directory");

        for (int i = 0; i < pkg.getEntryCount(); i++)
	{
            checkInterrupted();
            PackageEntry entry = pkg.getEntry(i);
            fetchEntry(entry, prefix, listener);
            listener.onEntryInstalled(entry);
        }
    }

    public boolean fetchArchive (PackageEntry entry, File prefix, FetchListener listener)
        throws PackageException, IOException, InterruptedException
    {
        if (!prefix.exists())
        {
            prefix.mkdirs();
        }

        URL url = entry.getURL();
        URLConnection conn = url.openConnection();
        checkInterrupted();
        listener.onBeginEntry(entry, conn.getContentLength());
        ZipInputStream in = new ZipInputStream(conn.getInputStream());
        byte[] buf = new byte[4096];
        int bytesRead;

        ZipEntry z = in.getNextEntry();
        while (z != null)
	{
            checkInterrupted();
            String fname =Util.stripRoot(z.getName());
            File outFile = new File(prefix, fname);
            if (z.isDirectory()) {
                outFile.mkdirs();
                outFile.mkdir();
            }
            else if (!outFile.exists() || listener.onFileExists(outFile)) {    
                listener.onBeginArchivedFile(entry, outFile, z.getSize());
                OutputStream out = Util.openOutput(outFile);
                while ((bytesRead=in.read(buf))!=-1) {
                    checkInterrupted();
                    out.write(buf,0,bytesRead);
                    listener.onArchivedFileProgress(bytesRead);
                }
                out.close();
            }
            listener.onFileInstalled(outFile);
            listener.onEntryProgress((int)z.getCompressedSize());            
            z = in.getNextEntry();
        }
        in.close();
        listener.onEntryInstalled(entry);
        return true;
    }

    public boolean fetchEntry (PackageEntry entry, File prefix, FetchListener listener) 
        throws PackageException, IOException, InterruptedException
    {
        int i,bytes;
        byte[] buf = new byte[4096];
        if (entry.isArchive())
	{
            fetchArchive(entry, prefix, listener);
	}
        else
	{
	    try
	    {
		URLConnection conn = entry.getURL().openConnection();
		checkInterrupted();
		String filename = Util.getFileName(entry.getURL());
		InputStream in = conn.getInputStream();
		File outFile = new File(prefix,filename);
		if (outFile.exists() &&
		    !listener.onFileExists(outFile))
		{
		    in.close();
		    return false;
		}
		outFile.mkdirs();
		outFile.mkdir();    
		listener.onBeginEntry(entry, conn.getContentLength());
		OutputStream out = Util.openOutput(outFile);
		while ((bytes = in.read(buf))!=-1)
		{
		    checkInterrupted();
		    listener.onEntryProgress(bytes);
		    out.write(buf,0,bytes);
		}
		in.close();
		out.close();
		listener.onFileInstalled(outFile);
		listener.onEntryInstalled(entry);
		return true;
	    }
	    catch (FileNotFoundException e)
	    {
		throw new PackageException("Bad output file",e);
	    }
	    catch (IOException e)
	    {
		throw new PackageException("IO error", e);
	    }
	}
        return false;
    }

    protected void checkInterrupted ()
	throws InterruptedException
    {
        if (Thread.interrupted())
	{
            throw new InterruptedException(); 
	}
    }
}
