package edu.duke.cs.snarfer;

import java.net.URL;
import java.util.Arrays;
import java.util.StringTokenizer;

public class PackageInfo implements Comparable {
	private String myName = "";
	private String myVersion = "";
	private String myPublisher = "";
	private String[] myCategory;
	private URL myURL;
	private String myType="";

	public PackageInfo(URL url) {
		myURL = url;
	}

	public PackageInfo(String name, String version, String publisher,
			String[] category, URL url, String type) {
		myName = name;
		myVersion = version;
		myPublisher = publisher;
		myCategory = (String[]) category.clone();
		myURL = url;
		myType = type;
	}

	public String getName() {
		return myName;
	}

	public String getVersion() {
		return myVersion;
	}

	public String getPublisher() {
		return myPublisher;
	}

	public String[] getCategory() {
		return myCategory;
	}

	public URL getURL() {
		return myURL;
	}

	public String getType() {
		return myType;
	}

	public void setCategory(String[] category) {
		myCategory = category;
	}

	public void setName(String name) {
		myName = name;
	}

	public void setPublisher(String publisher) {
		myPublisher = publisher;
	}

	public void setURL(URL url) {
		myURL = url;
	}

	public void setVersion(String version) {
		myVersion = version;
	}

	public void setType(String type) {
		myType = type;
	}

	public boolean equals(Object o) {
		if (compareTo(o) == 0)
			return Arrays.equals(myCategory, ((PackageInfo) o).getCategory());
		return false;
	}

	public static int versionCompare(String a, String b) {
		StringTokenizer ta = new StringTokenizer(a, ".");
		StringTokenizer tb = new StringTokenizer(b, ".");
		while (ta.hasMoreTokens() && tb.hasMoreTokens()) {
			int na = Integer.parseInt(ta.nextToken());
			int nb = Integer.parseInt(tb.nextToken());
			if (na < nb)
				return -1;
			if (nb < na)
				return 1;
		}
		if (ta.hasMoreTokens())
			return 1;
		return 0;
	}

	public int compareTo(Object o) {
		if (!(o instanceof PackageInfo))
			return -1;

		PackageInfo other = (PackageInfo) o;
		int byName = myName.compareTo(other.getName());
		int byVersion = versionCompare(myVersion, other.getVersion());
		int byPublisher = myPublisher.compareTo(other.getPublisher());
		int byURL = myURL.toString().compareTo(other.getURL().toString());
		return byName != 0 ? byName : (byVersion != 0 ? byVersion
				: (byPublisher != 0 ? byPublisher : (byURL != 0 ? byURL : 0)));
	}
}
