package edu.duke.cs.snarfer;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

import edu.duke.cs.snarfer.PackageException;
import edu.duke.cs.snarfer.PackageInfo;
import edu.duke.cs.util.Util;


public class PackageSite 
{
    private URL myURL;
    private String myName;
    private ArrayList myPackages;

    public PackageSite (String name, File f)
    {
	myName = name;
	myPackages = new ArrayList();
	try
	{
	    myURL = f.toURL();
	}
	catch (MalformedURLException e)
	{
	    System.out.println("Invalid file specified.");
	}
    }

    public PackageSite (String name, Collection pkgInfos)
    {
	myName = name;
	myPackages=new ArrayList(pkgInfos);
    }

    public PackageSite (URL url)
	throws PackageException
    {
	myURL = url;
	update();
    }

    public void update ()
	throws PackageException
    {
	try
	{
	    DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
	    Document doc = builder.parse(myURL.openStream());
	    Element root = doc.getDocumentElement();
	    buildFrom(root);
	}
	catch (ParserConfigurationException e)
	{
	    throw new PackageException("Could not create XML parser", e);
	}
	catch (FactoryConfigurationError e)
	{
	    throw new PackageException("Could not create XML parser",e);
	}
	catch (SAXException e)
	{
	    throw new PackageException("Could not parse XML", e);
	}
	catch (IOException e)
	{
	    throw new PackageException("Error fetching descriptor", e);
	}
    }

    protected void buildFrom (Element root)
	throws PackageException
    {
	if (! root.getNodeName().equals("packages"))
	    throw new PackageException("Root of project site xml must be named \"packages\".");

	myName = root.getAttribute("name");
	NodeList packages = root.getElementsByTagName("package");
	myPackages = new ArrayList();
		
	for (int i = 0; i < packages.getLength(); i++)
	{
	    Element p = (Element)packages.item(i);
	    String name = p.getAttribute("name");
	    String cat = p.getAttribute("category");
	    String version = p.getAttribute("version");
	    String path = p.getAttribute("url");
	    String publisher = p.getAttribute("publisher");
	    String type = p.getAttribute("type");
	    URL url;
	    try {
		url = new URL(myURL, path);
	    }
	    catch (MalformedURLException e) {
		throw new PackageException("Bad file URL", e);
	    }
	    StringTokenizer tokens = new StringTokenizer(cat,"/",false);
	    int numTokens = tokens.countTokens();
	    String[] cats = new String[numTokens];			
	    for (int j = 0; j < numTokens; j++)
	    {
		cats[j] = tokens.nextToken();
	    } 
	    myPackages.add(new PackageInfo(name, version, publisher, cats, url, type));
	}		
    }

    public String getName ()
    {
	return myName;
    }

    public int getPackageCount()
    {
	return myPackages.size();
    }

    public PackageInfo getPackageInfo (int i)
    {
	if (i >= myPackages.size())
	    return null;
	return (PackageInfo) myPackages.get(i);
    }

    public URL getURL ()
    {
	return myURL;
    }

    public void setURL (URL url)
    {
	myURL = url;
    }

    public String concatenate (String[] s, char separator)
    {
    	String retString="";
    	int k;
    	for (k = 0; k < s.length - 1; k++)
    	{
    		retString += s[k] + separator;
    	}

    	retString += s[k];
        return retString;
    }
	
    public Document toDOM ()
    {
	Document doc = Util.createDOM();
	Element root = doc.createElement("packages");
	root.setAttribute("name", myName);
	for (int k = 0; k < myPackages.size(); k++)
	{
	    PackageInfo p = getPackageInfo(k);
	    Element el = doc.createElement("package");
	    el.setAttribute("category", concatenate(p.getCategory(), '/'));
	    el.setAttribute("name", p.getName());
	    el.setAttribute("url", p.getURL().toString());
	    el.setAttribute("publisher", p.getPublisher());
	    el.setAttribute("version", p.getVersion());
	    el.setAttribute("type", p.getType());
	    root.appendChild(el);
	}
	doc.appendChild(root);
	return doc;		
    }
	
    public void addPackageInfo(PackageInfo info)
    {
	myPackages.add(info);
    }
    
    public void removePackageInfo (int index)
    {
	myPackages.remove(index);
    }

    public void removePackageInfo (URL url)
    {
	for (int k = 0; k < myPackages.size(); k++)
	{
	    PackageInfo info = getPackageInfo(k);
	    String f = info.getURL().toString();
	    if (f.equals(url.toString()))
	    {
		myPackages.remove(k);
	    }
	}
    }	

	/*public void addPackage(String name, String desc, String ver, String[] cat, String path) 
	 {
		URL url = null;
		try {
			url = new URL(myURL, path);
		} catch (MalformedURLException e) {
			System.out.println("Invalid URL specified.");
		}
		PackageInfo info = new PackageInfo(name, desc, ver, cat, url);
		myPackages.add(info);
	 }*/
}
