/*
 * Created on Jun 2, 2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package edu.duke.cs.snarfer.eclipse;

import java.net.MalformedURLException;
import java.net.URL;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import edu.duke.cs.snarfer.eclipse.Strings;
import edu.duke.cs.snarfer.eclipse.UI;
/**
 * @author jett
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
class EditSiteDialog extends Dialog
{
    private Viewer viewer;
    private Text urlField;
    private Label fieldLabel, statusLabel;
    private URL url;

    public EditSiteDialog (Viewer viewer, Shell parent, URL editUrl)
    {
	super(parent);
	this.viewer = viewer;
	parent.setText(Strings.getString("SiteViewPart.edit.dlg.title"));
	url=editUrl;
    }

    public URL getURL ()
    {
	return url;
    }
    public String getValue()
    {
    	return url.toString();
    }
    public void setURL(URL s)
    {
    	urlField.setText(s.toString());
    }
    protected void cancelPressed ()
    {
	super.cancelPressed();
    }

    protected void okPressed ()
    {
	super.okPressed();
    }

    protected Control createDialogArea (Composite parent)
    {
	parent = (Composite)super.createDialogArea(parent);
	GridLayout grid = new GridLayout();
	grid.numColumns = 1;
	parent.setLayout(grid);
	Label l = new Label(parent, SWT.NONE);
	l.setText(Strings.getString("SiteViewPart.edit.text"));
	Composite urlPanel = UI.createGridPanel(parent, GridData.FILL_HORIZONTAL,2);
	fieldLabel = UI.createLabel(urlPanel,Strings.getString("NewSiteDialog.url")); //$NON-NLS-1$
	urlField = UI.createWideField(urlPanel);
	urlField.setText(url.toString());
	urlField.addModifyListener(new ModifyListener()
	    {
		public void modifyText(ModifyEvent e) {
		    verifyURL();
		}
	    });
	statusLabel = UI.createWideLabel(parent,""); //$NON-NLS-1$
	return parent;
    }
    
    private void verifyURL ()
    {
	try
	{
	    String u = urlField.getText();
	    if (u.endsWith(".xml") == false)
	    {
		if (u.endsWith("/") == false)
		{
		    u += "/";
		}
		u += "root.xml";
	    }
	    if (u.indexOf("//") == -1)
	    {
		u = "http://" + u;
	    }
	    url = new URL(u);
	    statusLabel.setText(Strings.getString("NewSiteDialog.status.valid")); //$NON-NLS-1$
	    getButton(IDialogConstants.OK_ID).setEnabled(true);
	}
	catch (MalformedURLException e) {
	    getButton(IDialogConstants.OK_ID).setEnabled(false);
	    statusLabel.setText(Strings.getString("NewSiteDialog.status.invalid")); //$NON-NLS-1$
	}
    }

    protected Control createButtonBar (Composite parent)
    {
	Control ret = super.createButtonBar(parent);
	verifyURL();
	return ret;
    }
}
