/*
 * 
 * Created on Jun 3, 2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package edu.duke.cs.snarfer.eclipse;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
//import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

import edu.duke.cs.snarfer.ClientEngine;
import edu.duke.cs.snarfer.FetchListener;
import edu.duke.cs.snarfer.Package;
import edu.duke.cs.snarfer.PackageEntry;
import edu.duke.cs.snarfer.PackageException;

import edu.duke.cs.util.*;

/**
 * @author Ethan
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class InstallWizard extends Wizard 
{
    protected class Page1 extends WizardPage
        implements Runnable,FetchListener
    {
        private Text destPath;
        private Button browseButton, defaultCheck;
        private ProgressBar fileProgress, totalProgress;
        private Label statusText, fileText;
        private Thread worker;
        private boolean isComplete=false;
        private int overwrite=OverwriteDialog.NO;
        private OverwriteDialog overwriteDlg;
        private File currArchivedFile;
        private int currArchivedFileBytes, currEntryBytes;
        private long currEntrySize;
        private PackageEntry currEntry;
        private int installedEntryCount;
        
        private boolean myBadLocationFlag = false;

        public Page1 ()
        {
        		super(Strings.getString("InstallWizard.title")); //$NON-NLS-1$
            	//setTitle(Strings.getString("InstallWizard.page1.title"));//,  //$NON-NLS-1$
			//setDescription(Strings.getString("InstallWizard.page1.description"));//		
        	}
	
        public void createControl (Composite parent)
        {
        		setTitle(Strings.getString("InstallWizard.page1.title"));//,  //$NON-NLS-1$
			setDescription(Strings.getString("InstallWizard.page1.description"));//		

            Composite page = UI.createGridPanel(parent,GridData.FILL_BOTH,1);
            Composite checkPanel = new Composite(page,SWT.NULL);
            checkPanel.setLayout(new GridLayout(2,false));
            defaultCheck = new Button(checkPanel, SWT.CHECK);
            defaultCheck.addSelectionListener(new SelectionAdapter()
	    {
                public void widgetSelected(SelectionEvent e)
		{

                    if (defaultCheck.getSelection())
                    {
                        String path = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile().getAbsolutePath();
                        destPath.setText(path);
                        destPath.setEnabled(false);
                        destPath.setEditable(false);
                        browseButton.setEnabled(false);
                    }
                    else
                    {
                        destPath.setText("");
                        destPath.setEnabled(true);
                        destPath.setEditable(true);
                        browseButton.setEnabled(true);
                    }
                }
            });
        
            Label checkLabel = new Label(checkPanel, SWT.NULL);
            checkLabel.setText("Use Default");

            Composite destPanel = UI.createGridPanel(page, GridData.FILL_HORIZONTAL, 2);
            destPath = UI.createWideField(destPanel);
            IWorkspace i = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot i2 = i.getRoot();
            String path = i2.getLocation().toFile().getAbsolutePath();
            destPath.setText("");//(path);
            destPath.forceFocus();
            destPath.addModifyListener(new ModifyListener()
		{
		    public void modifyText(ModifyEvent e)
		    {
			onModify();
		    }
		});
            
            browseButton = new Button(destPanel, SWT.PUSH);
            browseButton.setText(Strings.getString("InstallWizard.page1.browseButton")); //$NON-NLS-1$
            browseButton.addSelectionListener(new SelectionAdapter()
		{
		    public void widgetSelected(SelectionEvent e)
		    {
		    	onBrowse();
		    }
		});
            
           
            
            Composite progressPanel = UI.createGridPanel(page, GridData.FILL_HORIZONTAL,1);
            fileText = UI.createWideLabel(progressPanel, ""); //$NON-NLS-1$
            fileProgress = UI.createProgressBar(progressPanel, 100);
            try{
            	totalProgress = UI.createProgressBar(progressPanel, pkg.getEntryCount());
            }catch(Exception e){
            	totalProgress = UI.createProgressBar(progressPanel, 0);
            }
            statusText = UI.createWideLabel(page,""); //$NON-NLS-1$
            statusText.setAlignment(SWT.CENTER);
            defaultCheck.setSelection(false);
            destPath.setEnabled(true);
            destPath.setEditable(true);
            browseButton.setEnabled(true);
            setControl(page);
        }

        protected void onBrowse ()
	{
            DirectoryDialog dlg = new DirectoryDialog(this.getShell());
            dlg.setFilterPath(destPath.getText());
            dlg.setMessage(Strings.getString("InstallWizard.page1.dirPrompt")); //$NON-NLS-1$
            dlg.setText(Strings.getString("InstallWizard.page1.dirDlgTitle")); //$NON-NLS-1$
            String choice = dlg.open();
            if (choice != null) {
                destPath.setText(choice);
                onModify();
            }
        }

        protected void onModify ()
	{
            getWizard().getContainer().updateButtons();
        }

        public void run ()
	{
            installedEntryCount = 0;
            UI.asyncSetText(statusText, Strings.getString("InstallWizard.status.fetching")); //$NON-NLS-1$
            ClientEngine engine = new ClientEngine();
            Iterator it = pkg.getEntries().iterator();
            int i = 0;
            while (it.hasNext())
	    {
                PackageEntry entry = (PackageEntry)it.next();
                UI.asyncSetText(fileText, entry.getURL().toString());
                try {                    
                    engine.fetchEntry(entry, destination, this);
                    i++;
                    UI.asyncSetProgress(totalProgress,i);
                } catch (PackageException e) {
                    UI.asyncSetText(statusText,e.getMessage());
                    return;
                } catch (IOException e) {
                    UI.asyncSetText(statusText,e.getMessage());
                    return;
                } catch (InterruptedException e) {
                    return;
                }
            }
            getShell().getDisplay().syncExec(new Runnable()
		{ 
		    public void run ()
		    { 
			fileText.setVisible(false);
			statusText.setText(Strings.getString("InstallWizard.status.finished")); //$NON-NLS-1$
			fileProgress.setVisible(false);
			totalProgress.setSelection(totalProgress.getMaximum());
			page2.refresh();
			isComplete = true;
			getWizard().getContainer().showPage(page2);
		    }
		});
        }

        public boolean onFileExists (File f)
	{
            if (overwrite == OverwriteDialog.YESTOALL)
                return true;
            else if (overwrite == OverwriteDialog.NOTOALL)
                return false;
            overwriteDlg = new OverwriteDialog(getShell(), Strings.getString("InstallWizard.overwrite.title"), f.getAbsolutePath(), true); //$NON-NLS-1$
            getShell().getDisplay().syncExec(new Runnable(){public void run() {
                overwrite = overwriteDlg.open();
            }});
            return (overwrite == OverwriteDialog.YES ||
                    overwrite == OverwriteDialog.YESTOALL);
        }

        public void onFileInstalled (File f)
	{
            if (f.getName().equals(IProjectDescription.DESCRIPTION_FILE_NAME))
                projectFiles.add(f);
            installedFiles.add(f);
            if (f.isDirectory())
                directories.add(f);
            f = f.getParentFile();
            while (f!=null && !f.equals(destination)&& !directories.contains(f)) {
                directories.add(f);
                f = f.getParentFile();
            }
        }

        public void onArchivedFileProgress (int bytes)
	{
            currArchivedFileBytes += bytes;
            UI.asyncSetText(fileText, "Getting "+currArchivedFile.getName() //$NON-NLS-1$
                            +": "+(currArchivedFileBytes/1024)+"K"); //$NON-NLS-1$ //$NON-NLS-2$
        }

        public void onBeginArchivedFile(PackageEntry archive, File f, long size)
	{
            currArchivedFile = f;
            currArchivedFileBytes = 0;
        }

        public void onBeginEntry(PackageEntry entry, long size)
	{
            currEntry = entry;
            currEntrySize = size;
            currEntryBytes = 0;
            if (entry.isArchive())
                UI.asyncSetText(statusText, Strings.getString("InstallWizard.status.archiveprefix")+entry.getURL()); //$NON-NLS-1$
            else
                UI.asyncSetText(statusText, Strings.getString("InstallWizard.status.fileprefix")+entry.getURL()); //$NON-NLS-1$
            
            UI.asyncSetProgress(fileProgress, 0);
        }

        public void onEntryInstalled (PackageEntry entry)
	{
        }

        public void onEntryProgress (int bytes)
	{
            currEntryBytes += bytes;
            UI.asyncSetProgress(fileProgress, (int)(100*currEntryBytes/(double)currEntrySize));
        }

        public IWizardPage getNextPage ()
	{
            SnarferPlugin.getDefault().setLastInstallLocation(destination);
            try {
                SnarferPlugin.getDefault().saveSettings();
            } catch (IOException e) {
                System.err.println("Error saving plugin settings: "+e);
            }
            worker = new Thread(this);
            worker.start();
            return this;
        }

        public boolean canFlipToNextPage ()
	{
            File root = new File(destPath.getText());
            destination = new File(root.getAbsolutePath(),pkg.getInfo().getName());
            return root.isDirectory();
        }
    }

    protected class Page2 extends WizardPage
    {
        private Composite page, projectPanel, importPanel, optionPanel;
        private Composite myTable;
        private Label projectText,  statusText;
        //private Text importName;
        private Button importCheck;
        private Combo importCombo;
        private Tree typeTable;
        private ArrayList projectButtons;
        private Object myType;
        private String projName;
        
        public Page2 ()
        {
            super(Strings.getString("InstallWizard.title"),        //$NON-NLS-1$
		      Strings.getString("InstallWizard.page2.title"),  //$NON-NLS-1$
		      PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(org.eclipse.ui.ide.IDE.SharedImages.IMG_OBJ_PROJECT));
            projectButtons = new ArrayList();
            setPageComplete(false);
        }

        public ArrayList getChosenProjects ()
        {
            ArrayList ret = new ArrayList();    

            for (int i=0;i<projectButtons.size();i++)
            {
                Button b = (Button)projectButtons.get(i);
                if (b.getSelection())
                    ret.add(b.getData());
            }

            return ret;
        }

        public String getImportName ()
	{
            return projName;//importName.getText();
        }

        public String getImportDirectory ()
	{
            return importCombo.getItem(importCombo.getSelectionIndex());
        }

        public boolean isImportChecked ()
	{
            return importCheck.getSelection();
        }

        public String getType()
        {
            String type = "";
            if (pkg.getInfo().getType()!=null)
            {
            	type=pkg.getInfo().getType().toLowerCase();
            	if (myProjectFactory.isValidType(type))
            		return type;
            }
            return myType.toString().toLowerCase();
        }
        
        protected void createNaturesTable ()
        {
        	String type = "";
            if (pkg.getInfo().getType()!=null)
            {
            	type=pkg.getInfo().getType().toLowerCase();
            	if (myProjectFactory.isValidType(type))
            		return;
            }
            Label label = UI.createLabel(optionPanel,"Select type of project:");
            ((GridData)label.getLayoutData()).horizontalSpan=1;
            Tree table = new Tree(optionPanel, SWT.BORDER | SWT.SINGLE);

            GridData naturesLayout = new GridData(GridData.FILL_HORIZONTAL);
            naturesLayout.horizontalSpan=1;
            table.setLayoutData(naturesLayout);

            String[] types = myProjectFactory.getValidTypes();
            for (int k =0; k < types.length; k++)
            {
                TreeItem item = new TreeItem(table, SWT.LEFT);
                item.setText(myProjectFactory.getDescription(types[k]));
                item.setData(types[k]);
            }

            typeTable = table;
            typeTable.addSelectionListener(new SelectionListener() {
    			public void widgetSelected(SelectionEvent e) {
    					TreeItem[] selected = typeTable.getSelection();
    					if (selected!=null)
    						setType(selected[0].getData());
    			}
    			public void widgetDefaultSelected(SelectionEvent e) {
    				typeTable.deselectAll();
    			}
    		});
        }

        private void setType(Object s)
        {
        	myType=s;
        }
        public void createControl (Composite parent)
	{
            page = UI.createGridPanel(parent,GridData.FILL_BOTH,1);
            statusText = UI.createWideLabel(page,""); //$NON-NLS-1$

            projectPanel = UI.createGridPanel(page,GridData.FILL_BOTH,1);

            importPanel = UI.createGridPanel(page,GridData.FILL_HORIZONTAL,1);
            Composite checkPanel = UI.createGridPanel(importPanel,GridData.FILL_HORIZONTAL,2);            
            optionPanel = UI.createGridPanel(importPanel,GridData.FILL_HORIZONTAL,2);    
            importCheck = new Button(checkPanel, SWT.CHECK);
            importCheck.setSelection(true);
            importCheck.addSelectionListener(new SelectionAdapter(){
                public void widgetSelected(SelectionEvent e) {
                    optionPanel.setVisible(importCheck.getSelection());
                }
            });
            Label importLabel = UI.createWideLabel(checkPanel,Strings.getString("InstallWizard.import.prompt")); //$NON-NLS-1$
            Label nameLabel = UI.createLabel(optionPanel,Strings.getString("InstallWizard.import.name")); //$NON-NLS-1$
            Text importName = UI.createWideField(optionPanel);
            try{
            	importName.setText(pkg.getInfo().getName());
            }catch(Exception e){
            	importName.setText("");
            }
            projName=importName.getText();
            String path = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile().getAbsolutePath();
            if (destination.getAbsolutePath().indexOf(path) == 0)
            {
                importName.setEditable(false);
                importName.setEnabled(false);
            }
            
            Label comboLabel = UI.createLabel(optionPanel,Strings.getString("InstallWizard.import.dir")); //$NON-NLS-1$
            importCombo = new Combo(optionPanel, SWT.DROP_DOWN|SWT.BORDER|SWT.SIMPLE|SWT.READ_ONLY);
            importCombo.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
            createNaturesTable();
            optionPanel.setVisible(true);
            projectPanel.setVisible(false);
            importPanel.setVisible(false);

            projectText = UI.createWideLabel(projectPanel,Strings.getString("InstallWizard.projects.prompt")); //$NON-NLS-1$

            setControl(page);
            myTable = new Composite(projectPanel, SWT.BORDER);
        }

        public void refresh ()
	{
            final IWorkspace workspace = ResourcesPlugin.getWorkspace();
            if (projectFiles.size()>0) 
            {    
                Iterator it = projectFiles.iterator();
                myTable.setLayoutData(new GridData(GridData.FILL_BOTH));
                GridLayout grid = new GridLayout(2, false);
                grid.horizontalSpacing = 10;
                myTable.setLayout(grid);
                while (it.hasNext()) {
                    File pf = (File)it.next();
                    IProjectDescription description=null;
                    try {
                        description = workspace.loadProjectDescription(new Path(pf.getAbsolutePath()));
                        String path = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile().getAbsolutePath();
                        if (description.getLocation().toFile().getAbsolutePath().indexOf(path) == 0)
                        {
                            description.setName(description.getLocation().toFile().getName());
                        }
                        
                        description.setLocation(new Path(pf.getParent()));
                    } catch (CoreException e1) {
                        e1.printStackTrace();
                        continue;
                    }
                    Button check = new Button(myTable, SWT.CHECK);
                    check.setData(description);
                    check.setSelection(true);
                    projectButtons.add(check);
                    Label project = UI.createWideLabel(myTable, 
                        description.getName()+" ("+pf.getParentFile().getAbsolutePath()+")"); //$NON-NLS-1$ //$NON-NLS-2$
                }
                myTable.layout(true);
                projectPanel.setVisible(true);
                projectPanel.layout(true);
            }
            else {
                importCombo.add(destination.getAbsolutePath());
                for (Iterator it =directories.iterator();it.hasNext();) {
                    File dir = (File)it.next();
                    if (dir.getParentFile().equals(destination))
                        importCombo.add(dir.getAbsolutePath());
                }
                importCombo.select(directories.size()>0?1:0);
                importPanel.setVisible(true);
                statusText.setText(Strings.getString("InstallWizard.status.complete")); //$NON-NLS-1$
            }
            ((Composite)getControl()).layout(true);
            ((Composite)getControl()).redraw();
            setPageComplete(true);
        }

        public boolean canFlipToNextPage ()
	{
            return false;
        }
    }
    
    private Package pkg;
    private File destination;
    private Page1 page1;
    private Page2 page2;
    private ArrayList installedFiles;
    private Set directories;
    private Set projectFiles;
    private Set chosenProjects;
    private ProjectFactory myProjectFactory;
    private ProjectLoader myLoader;

    public InstallWizard(Package pkg, File destination)
                  throws NullPointerException
     {
         myProjectFactory = new ProjectFactory();
         myLoader = new ProjectLoader(getShell());

        this.destination = destination;
        UI.setDisplay(Display.getCurrent());
        this.pkg = pkg;
        projectFiles = new TreeSet(); 
        installedFiles = new ArrayList();
        directories = new TreeSet();
        
        this.setWindowTitle("Install Package "+pkg.getInfo().getName()+" version "+pkg.getInfo().getVersion()); //$NON-NLS-1$ //$NON-NLS-2$
    }

    public boolean performFinish ()
    {
        PackageInstallRecord record = new PackageInstallRecord(pkg.getInfo(), destination.getAbsolutePath(), new Date());
        SnarferPlugin.getDefault().getHistory().add(record);
        try {
            SnarferPlugin.getDefault().saveSettings();
        } catch (IOException e) {
            System.err.println(Strings.getString("InstallWizard.save.error")+e); //$NON-NLS-1$
        }
        if (page2 == null) 
            return true;
        ArrayList projects = page2.getChosenProjects();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (page2.isImportChecked() && projectFiles.size() == 0) 
        {
            File projDir = new File(page2.getImportDirectory());
            File projFile = new File(projDir, IProjectDescription.DESCRIPTION_FILE_NAME);
            String type = page2.getType().toLowerCase();
            //System.out.println(" type "+type);
            if (myProjectFactory.isValidType(type))
            {
                myProjectFactory.makeProject(type,projDir, page2.getImportName());
            }
            
            if (projFile.exists())
            {
                IProjectDescription desc = null;
                try {
                    desc =
                        workspace.loadProjectDescription(
                            new Path(projFile.getAbsolutePath()));
                } catch (CoreException e1) {
                    e1.printStackTrace();
                }
                desc.setLocation(new Path(projFile.getParent()));
                  IProject project = workspace.getRoot().getProject(desc.getName());
                myLoader.loadProject(desc,project,null);
            }
        }
        else
        {
            Iterator it = projects.iterator();
            while (it.hasNext()) {
                IProjectDescription desc  = (IProjectDescription)it.next();
                IProject project = workspace.getRoot().getProject(desc.getName());
                myLoader.loadProject(desc,project,null);
            }
        }
        return true;
    }

    public void addPages ()
    {
        super.addPages();
        page1 = new Page1();
        page2 = new Page2();
        addPage(page1);
        addPage(page2);
    }

    public boolean performCancel ()
    {
        if (page1 != null &&
	    page1.worker != null &&
	    page1.worker.isAlive())
	{
            page1.worker.interrupt();
            try
	    {
                page1.worker.join();
            }
	    catch (InterruptedException e)
	    {
            }
        }
        return super.performCancel();
    }

    public boolean canFinish ()
    {
        return page2.isPageComplete();
    }
}
