package edu.duke.cs.snarfer.eclipse;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

import edu.duke.cs.snarfer.Package;
import edu.duke.cs.snarfer.PackageException;
import edu.duke.cs.snarfer.PackageInfo;
import edu.duke.cs.snarfer.eclipse.InstallWizard;
import edu.duke.cs.snarfer.eclipse.PackageContentProvider;
import edu.duke.cs.snarfer.eclipse.PackageInstallRecord;
import edu.duke.cs.snarfer.eclipse.PackageLabelProvider;
import edu.duke.cs.snarfer.eclipse.SnarferPlugin;
import edu.duke.cs.snarfer.eclipse.Strings;
import edu.duke.cs.snarfer.eclipse.UI;

public class PackageViewPart extends ViewPart {
	private PackageInfo info;
	private Package myPkg;
	private String statusMsg;
	private ScrolledComposite window;
	private Label name, version, publisher, statusLabel;
	private Text infoText;
	private StyledText descText;
	private PackageContentProvider contentProvider;
	private PackageLabelProvider labelProvider;
	private Button installButton;
	
	public PackageViewPart() {
		statusMsg = Strings.getString("PackageViewPart.status.none"); //$NON-NLS-1$
	}

	public void setPackageInfo(PackageInfo pinfo) {
		this.info = pinfo;
		if (info == null) {
			window.setVisible(false);
			return;
		}
		IRunnableWithProgress getter = new IRunnableWithProgress() {
			public void run(IProgressMonitor monitor) {
				monitor.beginTask("Reading project information from "+info.getURL()+Strings.getString("PackageViewPart...._3"),1); //$NON-NLS-1$ //$NON-NLS-2$
				try {
					myPkg = new Package(info);
					statusMsg = ""; //$NON-NLS-1$
					//window.
					statusLabel.dispose();
				}
				catch (PackageException e) {
					myPkg = null;
					statusMsg = Strings.getString("PackageViewPart.status.error")+e.getMessage();						 //$NON-NLS-1$
					statusLabel.setText(statusMsg);
				}
				monitor.done();
			}
		};
		try {
			new ProgressMonitorDialog(getSite().getShell()).run(true, true, getter);
		} catch (Exception e) {
		}
		if (myPkg != null)
			info = myPkg.getInfo();		
		name.setText(info.getName());
		//url.setText(info.getURL().toString());
		version.setText(info.getVersion());
		publisher.setText(info.getPublisher());
		PackageInstallRecord record = SnarferPlugin.getDefault().getLastInstall(info.getName());
		if (record != null) {
			infoText.setText("Version "+ record.getInfo().getVersion()+ //$NON-NLS-1$
							" of this project was installed "+ //$NON-NLS-1$
							record.getInstallDate()+" at location '"+ //$NON-NLS-1$
							record.getLocation()+"'."); //$NON-NLS-1$
		}
		else if (myPkg!=null){
			infoText.setText(Strings.getString("PackageViewPart.info.noInstall")); //$NON-NLS-1$
		}
		else {
			infoText.setVisible(false);
		}
		if (myPkg != null) {	
			descText.setText(myPkg.getDescription());
			descText.layout(true);
			descText.setVisible(true);
		}
		else {
			descText.setVisible(false);
		}
		window.setMinSize(window.getContent().computeSize(SWT.DEFAULT, SWT.DEFAULT));
		window.setVisible(true);
		window.layout(true);
		window.redraw();
	}

	public void createPartControl(Composite parent2)  
	{
		parent2.setLayout(new FillLayout());
		
		ScrolledComposite sc = new ScrolledComposite(parent2, SWT.H_SCROLL | SWT.V_SCROLL | SWT.BORDER);
		sc.setAlwaysShowScrollBars(false);
		sc.setExpandHorizontal(true);
		sc.setExpandVertical(true);
		
		Composite parent = new Composite(sc, SWT.NONE);
		GridLayout layout = new GridLayout(1, false);
		parent.setLayout(layout);
		window = sc;

		Color blue = new Color(this.getSite().getShell().getDisplay(), 0,0,255);
		
		statusLabel = UI.createLabel(parent,""); //$NON-NLS-1$
		statusLabel.setForeground(blue);

		installButton = new Button(parent,SWT.LEFT);
		installButton.setText(Strings.getString("PackageViewPart.installButton")); //$NON-NLS-1$
		installButton.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent e) {
				onInstall();
			}
		});
		
		Composite infoPanel = UI.createGridPanel(parent, GridData.FILL_HORIZONTAL,2);
		Label nameLabel = UI.createLabel(infoPanel, "Project:"); //$NON-NLS-1$
		nameLabel.setForeground(blue);
		name = UI.createWideLabel(infoPanel,""); //$NON-NLS-1$
		//Label urlLabel = UI.createLabel(infoPanel, "URL:"); //$NON-NLS-1$
		//urlLabel.setForeground(blue);
		//url = UI.createWideLabel(infoPanel,""); //$NON-NLS-1$
		Label versionLabel = UI.createLabel(infoPanel, "Version:"); //$NON-NLS-1$
		versionLabel.setForeground(blue);
		version = UI.createWideLabel(infoPanel,""); //$NON-NLS-1$
		Label pubLabel =UI.createLabel(infoPanel, "Publisher:"); //$NON-NLS-1$
		pubLabel.setForeground(blue);
		publisher = UI.createWideLabel(infoPanel,""); //$NON-NLS-1$
		infoText = new Text(infoPanel, SWT.MULTI|SWT.WRAP);
		infoText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		((GridData)infoText.getLayoutData()).horizontalSpan = 2;
		infoText.setForeground(blue);
		infoText.setEditable(false);
		infoText.setBackground(publisher.getBackground());

		Label descLabel = UI.createLabel(parent,"Description:"); //$NON-NLS-1$
		descLabel.setForeground(blue);
				
		descText = new StyledText(parent, SWT.WRAP);
		descText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		descText.setEditable(false);
		descText.setBackground(publisher.getBackground());
		
		setPackageInfo(null);
		
		sc.setContent(parent);
		sc.setMinSize(parent.computeSize(SWT.DEFAULT, SWT.DEFAULT));
	}

	public void setFocus()  {
	}
	
	protected void onInstall() {

			//System.out.println("info " + myPkg.getInfo().getName()+" version "+myPkg.getInfo().getVersion());
	    	Wizard installWiz = new InstallWizard(myPkg, SnarferPlugin.getDefault().getLastInstallLocation());

			WizardDialog dialog =
				new WizardDialog(
					PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(),
					installWiz);
			dialog.open();
	}
}
