package edu.duke.cs.snarfer.eclipse;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

import edu.duke.cs.snarfer.PackageException;
import edu.duke.cs.snarfer.PackageInfo;
import edu.duke.cs.snarfer.PackageSite;
import edu.duke.cs.snarfer.eclipse.PackageInstallRecord;
import edu.duke.cs.snarfer.eclipse.Strings;
import edu.duke.cs.util.Util;
/**
 * The main plugin class to be used in the desktop.
 */
public class SnarferPlugin extends AbstractUIPlugin {
	//The shared instance.

	private static SnarferPlugin plugin;
	private static URL pluginURL;
	private Set mySiteURLs;
	private Map mySitesByURL;
	private Map myInfosBySite;
	private File myLastInstallDir;
	private ArrayList myHistory;
	private DateFormat myDateFormat;
	private DocumentBuilder documentBuilder;
	
	public static InputStream openInput(String name) throws IOException {
		File inFile = getDefault().getStateLocation().append(name).toFile();
		return new FileInputStream(inFile);
	}
	public static OutputStream openOutput(String name) throws IOException {
		return Util.openOutput(getDefault().getStateLocation().append(name).toFile());
	}
	/**
	 * The constructor.
	 */
	public SnarferPlugin(IPluginDescriptor descriptor) {
		super(descriptor);
		plugin = this;
		myDateFormat = new java.text.SimpleDateFormat(Strings.getString("SnarferPlugin.dateFormat")); //$NON-NLS-1$
		try {
			documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
			pluginURL = Platform.resolve(descriptor.getInstallURL());
			InputStream in = openInput(Strings.getString("SnarferPlugin.settings.filename")); //$NON-NLS-1$
			readSettings(Util.parseXML(in));
			in.close();
		}
		catch (ParserConfigurationException x) {
			readSettings(null);
		}
		catch (SAXException x) {
			readSettings(null);
		}
		catch (FileNotFoundException e) {
			readSettings(null);
		}
		catch (IOException e) {
			readSettings(null);
			e.printStackTrace();
		}
		mySitesByURL = new HashMap();
		myInfosBySite = new HashMap();
	}

	private void readSettings(Document doc) {
		mySiteURLs = new HashSet();
		myHistory = new ArrayList();
		if (doc == null) {
			myLastInstallDir = new File(""); //$NON-NLS-1$
			return;
		}
		Element root = doc.getDocumentElement();
		myLastInstallDir = new File(root.getAttribute(Strings.getString("SnarferPlugin.xml.installdir"))); //$NON-NLS-1$
		NodeList sites = root.getElementsByTagName(Strings.getString("SnarferPlugin.xml.site")); //$NON-NLS-1$
		int i;
		for (i=0;i<sites.getLength();i++) {
			Element site = (Element)sites.item(i);
			URL siteURL;
			try {
				siteURL = new URL(site.getAttribute(Strings.getString("SnarferPlugin.xml.siteurl"))); //$NON-NLS-1$
				mySiteURLs.add(siteURL);
			}
			catch (MalformedURLException e) {
				e.printStackTrace();
			}
		}
		NodeList history = root.getElementsByTagName(Strings.getString("SnarferPlugin.xml.install")); //$NON-NLS-1$
		for (i=0;i<history.getLength();i++) {
			Element record = (Element)history.item(i);
			String name = record.getAttribute(Strings.getString("SnarferPlugin.xml.name")); //$NON-NLS-1$
			String version = record.getAttribute(Strings.getString("SnarferPlugin.xml.version")); //$NON-NLS-1$
			String publisher = record.getAttribute(Strings.getString("SnarferPlugin.xml.publisher")); //$NON-NLS-1$
			String loc = record.getAttribute(Strings.getString("SnarferPlugin.xml.location")); //$NON-NLS-1$
			URL url=null;
			Date date=null;
			try {
				date = myDateFormat.parse(record.getAttribute(Strings.getString("SnarferPlugin.xml.date"))); //$NON-NLS-1$
				url = new URL(record.getAttribute(Strings.getString("SnarferPlugin.xml.pkgurl"))); //$NON-NLS-1$
				
			} catch (MalformedURLException e) {
				url = null;
			} catch (ParseException e) {
				date = null;
			}		
			PackageInfo info = new PackageInfo(name, version, publisher, new String[0], url, "");
			myHistory.add(new PackageInstallRecord(info, loc, date));
		}
	}
	public void saveSettings() throws IOException {
		Document doc = documentBuilder.newDocument();
		Element root = doc.createElement(Strings.getString("SnarferPlugin.xml.root")); //$NON-NLS-1$
		Element sites = doc.createElement(Strings.getString("SnarferPlugin.xml.sites")); //$NON-NLS-1$
		Element history = doc.createElement(Strings.getString("SnarferPlugin.xml.history")); //$NON-NLS-1$
		root.setAttribute(Strings.getString("SnarferPlugin.xml.installdir"),myLastInstallDir.toString()); //$NON-NLS-1$
		for (Iterator it = mySiteURLs.iterator();it.hasNext();) {
			Element site = doc.createElement(Strings.getString("SnarferPlugin.xml.site")); //$NON-NLS-1$
			site.setAttribute(Strings.getString("SnarferPlugin.xml.siteurl"), it.next().toString()); //$NON-NLS-1$
			sites.appendChild(site);
		}
		for (int i =0;i<myHistory.size();i++) {
			Element install = doc.createElement(Strings.getString("SnarferPlugin.xml.install")); //$NON-NLS-1$
			PackageInstallRecord record = (PackageInstallRecord)myHistory.get(i);
			install.setAttribute(Strings.getString("SnarferPlugin.xml.name"),record.getInfo().getName()); //$NON-NLS-1$
			install.setAttribute(Strings.getString("SnarferPlugin.xml.version"),record.getInfo().getVersion()); //$NON-NLS-1$
			install.setAttribute(Strings.getString("SnarferPlugin.xml.publisher"),record.getInfo().getPublisher()); //$NON-NLS-1$
			install.setAttribute(Strings.getString("SnarferPlugin.xml.pkgurl"),record.getInfo().getURL().toString()); //$NON-NLS-1$
			install.setAttribute(Strings.getString("SnarferPlugin.xml.location"), record.getLocation()); //$NON-NLS-1$
			install.setAttribute(Strings.getString("SnarferPlugin.xml.date"), myDateFormat.format(record.getInstallDate())); //$NON-NLS-1$
			history.appendChild(install);
		}
		root.appendChild(sites);
		root.appendChild(history);
		doc.appendChild(root);
		OutputStream xmlOut = openOutput(Strings.getString("SnarferPlugin.settings.new")); //$NON-NLS-1$
		Util.writeXML(xmlOut,doc);
		xmlOut.close();
		File oldSettings = getStateLocation().append(Strings.getString("SnarferPlugin.settings.filename")).toFile(); //$NON-NLS-1$
		File oldOldSettings = getStateLocation().append(Strings.getString("SnarferPlugin.settings.old")).toFile(); //$NON-NLS-1$
		File newSettings = getStateLocation().append(Strings.getString("SnarferPlugin.settings.new")).toFile(); //$NON-NLS-1$
		if (oldOldSettings.exists())
			oldOldSettings.delete(); 
		oldSettings.renameTo(getStateLocation().append(Strings.getString("SnarferPlugin.settings.old")).toFile()); //$NON-NLS-1$
		newSettings.renameTo(getStateLocation().append(Strings.getString("SnarferPlugin.settings.filename")).toFile()); //$NON-NLS-1$
	}
	/**
	 * Returns the shared instance.
	 */
	public Document newDocument() {
		return documentBuilder.newDocument();
	}
	public Collection getSiteURLs() {
		return mySiteURLs;
	}
	public Collection getHistory() {
		return myHistory;
	}
	public PackageInstallRecord getLastInstall(String pkgName) {
		Iterator it = myHistory.iterator();
		PackageInstallRecord record = null;
		while (it.hasNext()) { 
			PackageInstallRecord r = (PackageInstallRecord)it.next();
			if (r.getInfo().getName().toLowerCase().equals(pkgName.toLowerCase()) &&
				(record == null || r.getInstallDate().compareTo(record.getInstallDate()) > 0))
				record = r;
		}
		return record;
	}
	public File getLastInstallLocation() {
		return myLastInstallDir;
	}
	public void setLastInstallLocation(File dir) {
		myLastInstallDir = dir.isDirectory() ? dir : dir.getParentFile();
	}
	public PackageSite getSite(URL url) throws PackageException {
		if (mySitesByURL.containsKey(url))
			return (PackageSite)mySitesByURL.get(url);
		else
			return refreshSite(url);
	}
	public PackageSite refreshSite(URL url) throws PackageException {
		PackageSite site=null;
		try {
			site = new PackageSite(url);
		} catch (PackageException e) {
			mySitesByURL.remove(url);
			throw e;
		}
		mySitesByURL.put(url, site);
		return site;
	}
	public void uncacheSite(URL url) {
		mySitesByURL.remove(url);
	}
	
	public static SnarferPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns the workspace instance.
	 */
	public static IWorkspace getWorkspace() {
		return ResourcesPlugin.getWorkspace();
	}

	public static ImageDescriptor getImageDescriptor(String name) {
		try {
			URL installURL = getDefault().getDescriptor().getInstallURL();
			URL url = new URL(installURL, name);
			return ImageDescriptor.createFromURL(url);
		}
		catch (MalformedURLException e) {
			e.printStackTrace();
			return ImageDescriptor.getMissingImageDescriptor();
		}
	}
	/* (non-Javadoc)
	 * @see org.eclipse.core.runtime.Plugin#startup()
	 */
}
