/*
 * Created on Jun 6, 2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package edu.duke.cs.snarfer.eclipse;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

import edu.duke.cs.snarfer.PackageException;
import edu.duke.cs.snarfer.PackageInfo;
import edu.duke.cs.snarfer.PackageSite;
import edu.duke.cs.snarfer.eclipse.PackageInstallRecord;
import edu.duke.cs.snarfer.eclipse.SnarferPlugin;
/**
 * @author Administrator
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class UpdateChecker implements IRunnableWithProgress {
	private ArrayList mySiteURLs;
	private ArrayList myHistory;
	private Map updates, siteMap;
	private org.eclipse.swt.widgets.Shell shell;
	public UpdateChecker(org.eclipse.swt.widgets.Shell shell, Collection urls, Collection history) {
		mySiteURLs = new ArrayList();
		myHistory = new ArrayList();
		mySiteURLs.addAll(urls);
		myHistory.addAll(history);
	}
	private static boolean less(PackageInfo a, PackageInfo b) {
		return PackageInfo.versionCompare(a.getVersion(), b.getVersion()) < 0;
	}
	public void run(IProgressMonitor monitor) {
		int i,j;
		ArrayList sites = new ArrayList();
		monitor.beginTask("Contacting project sites...", mySiteURLs.size());
		Map pkgMap = new HashMap();
		siteMap = new HashMap();
		for (i=0;i<mySiteURLs.size();i++) {
			try {
				monitor.subTask("Contacting "+mySiteURLs.get(i));
				PackageSite site = SnarferPlugin.getDefault().getSite((URL)mySiteURLs.get(i));
				for (j=0;j<site.getPackageCount();j++) {
					PackageInfo info = site.getPackageInfo(j);
					siteMap.put(info, site);
					PackageInfo saved = (PackageInfo)pkgMap.get(info.getName());
					if (saved == null || less(saved,info))
						pkgMap.put(info.getName(), info);
				}
			} catch (PackageException e) {
			}
			monitor.worked(1);
		}
		updates = new HashMap();
		for (i=0;i<myHistory.size();i++) {
			PackageInstallRecord record = (PackageInstallRecord)myHistory.get(i);
			PackageInfo info = (PackageInfo)pkgMap.get(record.getInfo().getName());
			if (info == null)
				continue;
			if (less(record.getInfo(), info)) {
				PackageInfo[] infos = (PackageInfo[])updates.get(info.getName());
				if (infos == null)
					updates.put(info.getName(),new PackageInfo[]{record.getInfo(), info});
				else if (less(infos[0], record.getInfo()))
					infos[0] = record.getInfo();
			}
			else
				updates.remove(info.getName());
		}
		monitor.done();
	}
	public Map getUpdates() {
		return updates;
	}
	public Map getSiteMap() {
		return siteMap;
	}
}
