/*
 * Created on Jun 9, 2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package edu.duke.cs.snarfer.eclipse;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

import edu.duke.cs.snarfer.Package;
import edu.duke.cs.snarfer.PackageException;
import edu.duke.cs.snarfer.PackageInfo;
import edu.duke.cs.snarfer.PackageSite;
import edu.duke.cs.snarfer.eclipse.InstallWizard;
import edu.duke.cs.snarfer.eclipse.PackageInstallRecord;
import edu.duke.cs.snarfer.eclipse.SnarferPlugin;
import edu.duke.cs.snarfer.eclipse.Strings;
import edu.duke.cs.snarfer.eclipse.UI;

/**
 * @author Administrator
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class UpdateDialog extends Dialog {
	private Map updates, siteMap;
	private Set installSet;
	private Table table;
	public static int INSTALL = Dialog.OK+1; 
	public UpdateDialog(Shell parent, Map updates, Map siteMap) {
		super(parent);
		this.updates = updates;
		this.siteMap = siteMap;
		installSet = new HashSet();
	}
	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.Dialog#buttonPressed(int)
	 */
	protected void buttonPressed(int buttonId) {
		if (buttonId == INSTALL) {
			Iterator it = installSet.iterator();
			while (it.hasNext()) {
				PackageInfo info = (PackageInfo)it.next();
				Package pkg;
				try {
					pkg = new Package(info);
				} catch (PackageException e) {
					MessageDialog.openError(getShell(), Strings.getString("UpdateDialog.error.title"), //$NON-NLS-1$
						"The project information for '"+info.getName()+"' could not be retrieved from "+info.getURL()+", or has an invalid format."); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
					continue;
				}
				PackageInstallRecord record = SnarferPlugin.getDefault().getLastInstall(info.getName());
				Wizard installWiz = new InstallWizard(pkg, new File(record.getLocation()));
				WizardDialog dlg = new WizardDialog(getShell(), installWiz);
				dlg.open();
			}
		}
		super.buttonPressed(buttonId);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.window.Window#configureShell(org.eclipse.swt.widgets.Shell)
	 */
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(Strings.getString("UpdateDialog.title")); //$NON-NLS-1$
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.Dialog#createButtonsForButtonBar(org.eclipse.swt.widgets.Composite)
	 */
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, INSTALL, Strings.getString("UpdateDialog.installButton"), false).setEnabled(false); //$NON-NLS-1$
		createButton(parent, Dialog.OK, Strings.getString("UpdateDialog.dismissButton"), true); //$NON-NLS-1$
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.Dialog#createDialogArea(org.eclipse.swt.widgets.Composite)
	 */
	protected Control createDialogArea(Composite parent) {
		Composite panel = UI.createGridPanel(parent,GridData.FILL_BOTH,1);
		Label infoLabel = UI.createWideLabel(panel, Strings.getString("UpdateDialog.foundlist")); //$NON-NLS-1$
		table = new Table(panel, SWT.BORDER|SWT.CHECK);
		table.setLayoutData(new GridData(GridData.FILL_BOTH));
		TableColumn nameCol = new TableColumn(table, SWT.LEFT);
		TableColumn oldCol = new TableColumn(table, SWT.LEFT);
		TableColumn newCol = new TableColumn(table, SWT.LEFT);
		TableColumn siteCol = new TableColumn(table, SWT.LEFT);
		nameCol.setText(Strings.getString("UpdateDialog.nameCol")); //$NON-NLS-1$
		nameCol.setWidth(200);
		nameCol.setResizable(true);
		oldCol.setText(Strings.getString("UpdateDialog.oldVersionCol")); //$NON-NLS-1$
		oldCol.setWidth(100);
		oldCol.setResizable(true);
		newCol.setText(Strings.getString("UpdateDialog.newVersionCol")); //$NON-NLS-1$
		newCol.setWidth(100);
		newCol.setResizable(true);
		siteCol.setText(Strings.getString("UpdateDialog.siteCol")); //$NON-NLS-1$
		siteCol.setWidth(200);
		siteCol.setResizable(true);
		fillTable(table);
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		table.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				onChecked(((TableItem)e.item).getChecked(), (PackageInfo)((TableItem)e.item).getData());
			}
		});
		return parent;
	}
	protected void fillTable(Table table) {
		Iterator it = updates.entrySet().iterator();
		while (it.hasNext()) {
			Map.Entry entry = (Map.Entry)it.next();
			PackageInfo[] infos = (PackageInfo[])entry.getValue();
			TableItem item = new TableItem(table, SWT.NONE);
			item.setText(0, entry.getKey().toString());
			item.setText(1, infos[0].getVersion());
			item.setText(2, infos[1].getVersion());
			item.setText(3, ((PackageSite)siteMap.get(infos[1])).getURL().toString());
			item.setData(infos[1]);
		}
	}
	private void onChecked(boolean checked, PackageInfo info) {
		if (checked)
			installSet.add(info);
		else
			installSet.remove(info);
		getButton(INSTALL).setEnabled(!installSet.isEmpty());
	}
}
