/*
 * Created on Aug 11, 2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package edu.duke.cs.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.core.boot.BootLoader;

/**
 * @author jett
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class GPProject extends ProjectMaker
{
	private final String myType1 = "gp";
	private final String myType2 = "GP Project";
	private final boolean canSnarf = false;
	private String[] myLibraries;
	
	public GPProject() 
	{
		File path = new File(BootLoader.getInstallURL().getFile());
		path = new File(path,"plugins");
		path = new File(path,"edu.duke.cs.GPProject");
		path = new File(path,"gp.jar");
		myLibraries = new String[1];
		myLibraries[0] = path.toString();
	}
	
	public boolean isVisible() {
		return canSnarf;
	}

	public String getName() {
		return myType1;
	}

	public String getDescription() {
		return myType2;
	}
	
	public void makeProject(File projectDir, String projectName)
	{	
		createClassPathFile(projectDir, null, myLibraries, null);
		writeGPFiles(projectDir, projectName);
		createProjectFile(projectDir, projectName, JavaProject.NATURES, JavaProject.BUILD_SPEC, JavaProject.BUILD_SPEC);
	}
	
	private void writeGPFiles(File projectDir, String projectName)
	{
		writeIndexFile(projectDir, projectName);
		writeAppletFile(projectDir, projectName);
	}
	
	private void writeIndexFile(File projectDir, String name)
	{
		File indexHTML = new File(projectDir.getAbsoluteFile(), "index.html");
		try
		{
			FileOutputStream out = new FileOutputStream(indexHTML);
			String text =
			"<HTML>\n\t<HEAD>\n\t\t<TITLE></TITLE>\n\t</HEAD>\n\t<BODY>\n\n"+
			"<H1>My Java Applet</H1>\n<APPLET\n\t\tcode=\""+name+"\"\n\t\t"+
			"codeBase=\".\"\n\t\tarchive=\"gp.jar\"\n\t\twidth=400\n\t\theight=400>\n"+
			"</APPLET>\n\n\t</BODY>\n</HTML>";
			out.write(text.getBytes());
			out.close();
		}
		catch (IOException e)
		{
		}
	}
	
	
	private void writeAppletFile(File projectDir, String projectName)
	{
		File f = new File(projectDir.getAbsolutePath(), projectName + ".java");
		try
		{
			FileOutputStream out = new FileOutputStream(f);
			String name = f.getName().substring(0, f.getName().indexOf("."));
			String text =
				appletText1 + name + appletText2 + name + "()" + appletText3;
			out.write(text.getBytes());
			out.close();
		}
		catch (IOException e)
		{
		}
	}
	
	private final String appletText1 =
		"/*\n* Authors: YOUR NAME\n"
			+ "*          YOUR PARTNER'S NAME\n"
			+ "* Date:    TODAY'S DATE* Course:  CPS 4\n"
			+ "* Purpose: PRACTICE JAVA\n"
			+ "*/\n"
			+ "public class ";
	private final String appletText2 =
		" extends GP.Containers.Applet\n"
			+ "{\n/*\n"
			+ "* The program starts within this function when the\n"
			+ "* applet is constructed.\n"
			+ "*/\n\tpublic ";
	private final String appletText3 = "\n\t{\n\n\t}\n}";
	
}
