/*
 * Created on Aug 15, 2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package edu.duke.cs.util;

/**
 * @author jett
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.*;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.*;
import org.eclipse.jface.operation.*;
import org.eclipse.swt.layout.GridLayout;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.*;
import java.io.*;


/**
 * This is a sample new wizard. Its role is to create a new file 
 * resource in the provided container. If the container resource
 * (a folder or a project) is selected in the workspace 
 * when the wizard is opened, it will accept it as the target
 * container. The wizard creates one file with the extension
 * "java". If a sample multi-page editor (also available
 * as a template) is registered for the same extension, it will
 * be able to open it.
 */
public abstract class NewProjectWizard extends Wizard implements INewWizard
{
	protected NewProjectWizardPage page;
	protected ISelection selection;
	protected ProjectFactory myFactory;
	
	/**
	 * Constructor for GPWizard.
	 */
	public NewProjectWizard()
	{
		super();
		setNeedsProgressMonitor(true);
		myFactory = new ProjectFactory();
	}
	/**
	 * Adding the page to the wizard.
	 */
	public abstract void addPages();
	
	/**
	 * This method is called when 'Finish' button is pressed in
	 * the wizard. We will create an operation and run it
	 * using wizard as execution context.
	 */
	public boolean performFinish()
	{
		final String dirName = page.getDirectoryName() + File.separatorChar + page.getFileName();
		final String fileName = page.getFileName();
		IRunnableWithProgress op = new IRunnableWithProgress()
		{
			public void run(IProgressMonitor monitor)
				throws InvocationTargetException
			{
				try
				{
					monitor.beginTask("Creating project", 1);
					File projectDir = new File(dirName);
					projectDir.mkdir();
					projectDir.mkdirs();
					doFinish(projectDir, fileName, monitor);
				}
				catch (CoreException e)
				{
					throw new InvocationTargetException(e);
				}
				finally
				{
					monitor.done();
				}
			}
		};
		try
		{
			op.run(
				new ProgressMonitorPart(
					new Composite(getShell(), 0),
					new GridLayout(1, true)));
		}
		catch (InvocationTargetException e)
		{
			return false;
		}
		catch (InterruptedException e)
		{
			e.printStackTrace();
			return false;
		}
		return true;
	}

	/**
	 * The worker method. It will find the container, create the
	 * file if missing or just replace its contents, and open
	 * the editor on the newly created file.
	 */
	protected abstract void doFinish(
		File projectDir,
		String fileName,
		IProgressMonitor monitor)
		throws CoreException;

	protected void loadProject(File projectDir, IPath toLoad) throws CoreException
	{
		File projFile = new File(projectDir, IProjectDescription.DESCRIPTION_FILE_NAME);
		IWorkspace workspace = ResourcesPlugin.getWorkspace();
		
		IProjectDescription desc =
				workspace.loadProjectDescription(
					new Path(projFile.getAbsolutePath()));

		desc.setLocation(new Path(projFile.getParent()));
		
		IProject project = workspace.getRoot().getProject(desc.getName());
	
		ProjectLoader loader = new ProjectLoader(getShell());
		IFile loadFile = project.getFile(toLoad);
		loader.loadProject(desc, project, loadFile);
	}

	/**
	 * We will accept the selection in the workbench to see if
	 * we can initialize from it.
	 * @see IWorkbenchWizard#init(IWorkbench, IStructuredSelection)
	 */
	public void init(IWorkbench workbench, IStructuredSelection selection)
	{
		this.selection = selection;
	}
}