/*
 * Created on Aug 15, 2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package edu.duke.cs.util;

import java.io.File;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.*;
import org.eclipse.jface.viewers.*;
/**
 * The "New" wizard page allows setting the container for
 * the new file as well as the file name. The page
 * will only accept file name without the extension OR
 * with the extension that matches the expected one (java).
 */
public abstract class NewProjectWizardPage extends WizardPage
{
	protected Text directoryText;
	protected Text fileText;
	protected Button defaultCheck;
	protected Label dirLabel;
	protected Button button;
	/**
	 * Constructor for SampleNewWizardPage.
	 * @param pageName
	 */
	public NewProjectWizardPage(ISelection selection)
	{
		super("wizardPage");
		setTitle("");
		setDescription("");
	}
	/**
	 * @see IDialogPage#createControl(Composite)
	 */
	public void createControl(Composite parent)
	{
		Composite container = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout(1, false);
		container.setLayout(layout);
		
		Composite namePanel = new Composite(container, SWT.NULL);
		namePanel.setLayout(new GridLayout(2,false));
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		namePanel.setLayoutData(gd);

		
		Label label = new Label(namePanel, SWT.NULL);
		label.setText("Project name:");
		fileText = new Text(namePanel, SWT.BORDER | SWT.SINGLE);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		fileText.setLayoutData(gd);
		fileText.addModifyListener(new ModifyListener()
		{
			public void modifyText(ModifyEvent e)
			{
				dialogChanged();
			}
		});

		Label contents = new Label(container, SWT.NULL);
		contents.setText("Project Contents:");
		
		Composite root = new Composite(container, SWT.BORDER);
		root.setLayout(new GridLayout(3, false));
		gd = new GridData(GridData.FILL_HORIZONTAL);
		root.setLayoutData(gd);
		
		defaultCheck = new Button(root, SWT.CHECK);
		defaultCheck.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent e) {
				if (defaultCheck.getSelection())
				{
					IWorkspace i = ResourcesPlugin.getWorkspace();
					IWorkspaceRoot i2 = i.getRoot();
					String path = i2.getLocation().toFile().getAbsolutePath();
					directoryText.setText(path);
					directoryText.setEnabled(false);
					directoryText.setEditable(false);
					dirLabel.setEnabled(false);
					button.setEnabled(false);
				}
				else
				{
					directoryText.setText("");
					directoryText.setEnabled(true);
					directoryText.setEditable(true);
					dirLabel.setEnabled(true);
					button.setEnabled(true);
				}
			}
		});
		
		Label checkLabel = new Label(root, SWT.NULL);
		checkLabel.setText("Use Default");
		checkLabel.setVisible(true);
		Label blank = new Label(root, SWT.NULL);
		blank.setText("");		
		
		
		dirLabel = new Label(root, SWT.NULL);
		dirLabel.setText("&Directory:");
		directoryText = new Text(root, SWT.BORDER | SWT.SINGLE);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		directoryText.setLayoutData(gd);
		
		IWorkspace i = ResourcesPlugin.getWorkspace();
		IWorkspaceRoot i2 = i.getRoot();
		String path = i2.getLocation().toFile().getAbsolutePath();
		directoryText.setText(path);
		
		directoryText.addModifyListener(new ModifyListener()
		{
			public void modifyText(ModifyEvent e)
			{
				dialogChanged();
			}
		});
		button = new Button(root, SWT.PUSH);
		button.setText("Browse...");
		button.addSelectionListener(new SelectionAdapter()
		{
			public void widgetSelected(SelectionEvent e)
			{
				handleBrowse();
			}
		});
		
		initialize();
		dialogChanged();
		setControl(container);
	}

	protected void initialize()
	{
		fileText.setText("");
		defaultCheck.setSelection(true);
		directoryText.setEnabled(false);
		directoryText.setEditable(false);
		dirLabel.setEnabled(false);
		button.setEnabled(false);
	}
	/**
	 * Uses the standard container selection dialog to
	 * choose the new value for the container field.
	 */
	protected void handleBrowse()
	{
		DirectoryDialog dialog = new DirectoryDialog(getShell());
		dialog.setMessage("Choose location for project");
		String dir = dialog.open();
		if (dir != null)
		{
			directoryText.setText(dir);
		}
	}
	protected void dialogChanged() 
	{
		String dirName = getDirectoryName();
		String fileName = getFileName();
		if (dirName.length() == 0)
		{
			updateStatus("Directory must be specified");
			return;
		}
		File f = new File(dirName);
		if ( !f.isDirectory() )
		{
			updateStatus("Directory must be a valid directory");
			return;
		}
		
		if (fileName.length() == 0)
		{
			updateStatus("File name must be specified");
			return;
		}
		if (fileName.indexOf(".") != -1 || fileName.indexOf(" ") != -1)
		{
			updateStatus("Project name may not contain punctuation or spaces");
			return;
		}
		if (Character.isLowerCase(fileName.charAt(0)))
		{
			updateStatus("Project name must begin with capital letter");
			return;
		}
		updateStatus(null);
	}
	
	protected void updateStatus(String message)
	{
		setErrorMessage(message);
		setPageComplete(message == null);
	}
	public String getDirectoryName()
	{
		return directoryText.getText();
	}
	public String getFileName()
	{
		return fileText.getText();
	}
}