/*
 * Created on Aug 15, 2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package edu.duke.cs.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;

/**
 * @author jett
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class TapestryProject extends ProjectMaker
{
	private final String myType1 = "tapestry";
	private final String myType2 = "Tapestry Project";
	private final boolean canSnarf = false;
	public TapestryProject() {
	}
	
	public boolean isVisible() {
		return canSnarf;
	}

	public String getName() {
		return myType1;
	}

	public String getDescription() {
		return myType2;
	}

	public void makeProject(File projectDir, String projectName)
	{
		createCdtProject(projectDir);
		createTapestryFiles(projectDir, projectName);
		createProjectFile(projectDir, projectName, CppProject.NATURES, CppProject.BUILD_SPEC, CppProject.PERSPECTIVE);
	}
	
	private void createTapestryFiles(File projectDir, String projectName)
	{
		File makefile = new File(projectDir,"Makefile");
		if (makefile.exists())
		{
			return;
		}
		try {
			makefile.createNewFile();
			FileWriter writer = new FileWriter(makefile);
			
			String makeFileTxt =
				"##############################################################################\n" +
				"#\n" +
				"#  Sample Makefile for C++ applications\n" +
				"#    Works for single and multiple file programs.\n" +
				"#    Works on several different versions of Unix.\n" +
				"#    written by Robert Duvall\n" +
				"#\n" +
				"##############################################################################\n" +
				"\n" +
				"\n" +
				"##############################################################################\n" +
				"# Application specific variables --- change these to customize your compile\n" +
				"# EXEC      name of the executable file\n" +
				"# SRC_FILES space separated list of all source code files that must be linked\n" +
				"#           to create the executable (i.e., not template files)\n" +
				"# INC_FILES space separated list of header and template files --- add to this\n" +
				"#	    list only if you have files that do not have a corresponding .cpp\n" +
				"#   	    files listed in SRC_FILES\n" +
				"# ARCH	    system on which you are compiling\n" +
				"#           Possible values: CPS, ACPUB, LINUX, CYGWIN, MINGW\n" +
				"# COURSE    current course you are in\n" +
				"##############################################################################\n" +
				"EXEC   	  = " + projectName.toLowerCase() + ".exe\n" +
				"SRC_FILES = " + projectName.toLowerCase() + ".cpp\n" +
				"INC_FILES = $(SRC_FILES:%.cpp=%.h)\n" +
				"ARCH	  = MINGW\n" +
				"RM       = del\n" +
				"\n" +
				"##############################################################################\n" +
				"# Where to find course related header files (and their libraries) \n" +
				"# --- typically only need to set this at the start of the semester\n" +
				"# SYSINC_DIR space separated list of system directories where to find headers\n" +
				"# SYSLIB_DIR space separated list of system directories where to find libraries\n" +
				"# SYSLIB_LIB space separated list of system libraries needed\n" +
				"# SYSLIB_RUN space separated list of system libraries needed at runtime\n" +
				"# COURSE_DIR space separated list of course directories where to find files\n" +
				"# COURSE_LIB space separated list of course libraries needed\n" +
				"##############################################################################\n" +
				"# Where to find OpenGL headers\n" +
				"SYSINC_CPS_DIR 	   = \n" +
				"SYSINC_ACPUB_DIR   = \n" +
				"SYSINC_LINUX_DIR   = \n" +
				"SYSINC_CYGWIN_DIR  = \n" +
				"SYSINC_MINGW_DIR   = \n" +
				"SYSINC_DIR         = $(SYSINC_$(ARCH)_DIR:%=-I%/include)\n" +
				"# Where to find OpenGL libraries\n" +
				"SYSLIB_CPS_DIR 	   = \n" +
				"SYSLIB_ACPUB_DIR   = \n" +
				"SYSLIB_LINUX_DIR   = \n" +
				"SYSLIB_CYGWIN_DIR  = \n" +
				"SYSLIB_MINGW_DIR  = \n" +
				"SYSLIB_DIR         = $(SYSLIB_$(ARCH)_DIR:%=-L%/lib)\n" +
				"# Where to find OpenGL libraries at runtime\n" +
				"SYSLIB_CPS_RUN 	   = \n" +
				"SYSLIB_ACPUB_RUN   = \n" +
				"SYSLIB_LINUX_RUN   = \n" +
				"SYSLIB_CYGWIN_RUN  = \n" +
				"SYSLIB_MINGW_RUN   = \n" +
				"SYSLIB_RUN         = $(SYSLIB_$(ARCH)_RUN:%=-R%/lib)\n" +
				"# What system libraries to link to\n" +
				"SYSLIB_CPS_LIB 	   = \n" +
				"SYSLIB_ACPUB_LIB   = \n" +
				"SYSLIB_LINUX_LIB   = \n" +
				"SYSLIB_CYGWIN_LIB  = \n" +
				"SYSLIB_MINGW_LIB   = \n" +
				"SYSLIB_LIB	   = $(SYSLIB_$(ARCH)_LIB:%=-l%)\n" +
				"\n" +
				"# Where to find course specific libraries (and what they are)\n" +
				"COURSE_CPS_DIR 	  = /usr/project/courses\n" +
				"COURSE_ACPUB_DIR  = /afs/acpub/project/cps/tapestry/2.95\n" +
				"COURSE_LINUX_DIR  = /usr/local\n" +
				"COURSE_CYGWIN_DIR = /usr/local\n" +
				"COURSE_MINGW_DIR  = " +
				"COURSE_DIR        = $(COURSE_$(ARCH)_DIR)\n" +
				"# What course specific libraries to link to\n" +
				"COURSE_LIB	  = -ltapestry \n" +
				"\n" +
				"\n" +
				"##############################################################################\n" +
				"# Compiler specifications\n" +
				"# These match the variable names given in /usr/share/lib/make/make.rules\n" +
				"# so that make's generic rules work to compile our files.\n" +
				"# gmake prefers CXX and CXXFLAGS for c++ programs\n" +
				"##############################################################################\n" +
				"# Which compiler should be used\n" +
				"CCC		= g++\n" +
				"CXX		= $(CCC)\n" +
				"\n" +
				"# What flags should be passed to the compiler\n" +
				"DEBUG_LEVEL	= -g\n" +
				"EXTRA_CCFLAGS   = -Wall \n" +
				"CCFLAGS		= $(VERBOSE) $(DEBUG_LEVEL) $(EXTRA_CCFLAGS)\n" +
				"CXXFLAGS	= $(CCFLAGS)\n" +
				"\n" +
				"# What flags should be passed to the C pre-processor\n" +
				"#   In other words, where should we look for files to include - note,\n" +
				"#   you should never need to include compiler specific directories here\n" +
				"#   because each compiler already knows where to look for its system\n" +
				"#   files (unless you want to override the defaults)\n" +
				"#\n" +
				"CPPFLAGS  	= -I. $(SYSINC_DIR) -I$(COURSE_DIR)/include\n" +
				"\n" +
				"\n" +
				"# What flags should be passed to the linker\n" +
				"#   In other words, where should we look for libraries to link with - note,\n" +
				"#   you should never need to include compiler specific directories here\n" +
				"#   because each compiler already knows where to look for its system files.\n" +
				"#\n" +
				"LDFLAGS		= -L. $(SYSLIB_DIR) -L$(COURSE_DIR)/lib \n" +
				"\n" +
				"\n" +
				"# What libraries should be linked with\n" +
				"LDLIBS		= $(COURSE_LIB) $(SYSLIB_LIB)\n" +
				"\n" +
				"\n" +
				"# All source files have associated object files\n" +
				"OFILES		= $(SRC_FILES:%.cpp=%.o)\n" +
				"\n" +
				"\n" +
				"###########################################################################\n" +
				"# Additional rules make should know about in order to compile our files\n" +
				"###########################################################################\n" +
				"# all is the default rule\n" +
				"all	: $(EXEC)\n" +
				"\n" +
				"\n" +
				"# exec depends on the object files\n" +
				"$(EXEC) : $(OFILES)\n" +
				"	$(LINK.cc) -o $(EXEC) $(OFILES) $(LDLIBS)\n" +
				"\n" +
				"\n" +
				"# depend figures out header file dependecies\n" +
				"# use each time you add a new header file\n" +
				"depend:\n" +
				"	makedepend -- $(CXXFLAGS) -- -Y $(SRC_FILES)\n" +
				"\n" +
				"\n" +
				"# clean up after you're done\n" +
				"clean	:\n" +
				"	$(RM) $(OFILES) $(EXEC)\n" +
				"\n" +
				"# compile a single .cpp file into an object (.o) file\n" +
				"# for later linking with other .o files\n" +
				".cpp.o:\n" +
				"	$(COMPILE.cc) $<\n" +
				"\n" +
				"# compile a single .cpp file into an executable file\n" +
				".cpp:\n" +
				"	$(LINK.cc) $< -o $@ $(LDLIBS)\n" +
				"\n" +
				"\n" +
				"# DO NOT DELETE THIS LINE -- make depend depends on it.\n" +
				"\n";

			
			writer.write(makeFileTxt);
			writer.close();
		} catch (IOException e) {}
		File cpp = new File(projectDir,projectName.toLowerCase() + ".cpp");
		cpp.delete();
		try {
			cpp.createNewFile();
			FileWriter writer = new FileWriter(cpp);
			writer.write(cppFileTxt);
			writer.close();
		} catch (IOException e) {}	
	}
	private final String cppFileTxt =
		"#include <iostream>\n" +
		"#include <string>\n" +	
		"using namespace std;\n\n" +
		"#include \"utils.h\"\n\n" +
		"// Name: " + System.getProperty("user.name") +"\n" +
		"// Date: " + new Date() + "\n\n" + 	
		"int main(int argc, char * argv[])\n" +
		"{\n\n" +
		"\tWaitForReturn();\n" +
		"\treturn 0;\n" +
		"}\n";
}
