/*******************************************************************************
 * Copyright (c) 2004 Duke University
 *
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.cs.duke.edu/csed/ambient/copyright.html
 * 
*******************************************************************************/
package edu.duke.cs.prof;

import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.plugin.*;
import org.eclipse.core.runtime.*;
import org.eclipse.core.resources.*;
import java.util.*;
//import org.eclipse.jface.preference.IPreferenceStore;
//import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.PlatformUI;
/**
 * The main plugin class to be used in the desktop.
 */
public class ProfPlugin extends AbstractUIPlugin {
	
	public final static String PLUGIN_ID = "edu.duke.cs.prof";
	
	//The shared instance.
	private static ProfPlugin plugin;
	//Resource bundle.
	private ResourceBundle resourceBundle;
	
	/**
	 * The constructor.
	 */
	public ProfPlugin(IPluginDescriptor descriptor) {
		super(descriptor);
		plugin = this;
		try {
			resourceBundle= ResourceBundle.getBundle("edu.duke.cs.prof.ProfPluginResources");
		} catch (MissingResourceException x) {
			resourceBundle = null;
		}
	}

	/**
	 * Returns the shared instance.
	 */
	public static ProfPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns the workspace instance.
	 */
	public static IWorkspace getWorkspace() {
		return ResourcesPlugin.getWorkspace();
	}

	public static IWorkbenchWindow getActiveWorkbenchWindow() {
		return getDefault().getWorkbench().getActiveWorkbenchWindow();
	}

	/**
	 * Returns the string from the plugin's resource bundle,
	 * or 'key' if not found.
	 */
	public static String getResourceString(String key) {
		//ResourceBundle bundle= (ResourceBundle)WorkbenchPlugin.getDefault().getBundle();
		ResourceBundle bundle = ProfPlugin.getDefault().getResourceBundle(); 
		try {
			return bundle.getString(key);
		} catch (MissingResourceException e) {
			return key;
		}
	}

	/**
	 * Returns the plugin's resource bundle,
	 */
	public ResourceBundle getResourceBundle() {
		return resourceBundle;
	}
	
	/**
	 * Writes the current status to the log
	 */
	public static void log(IStatus status) {
		getDefault().getLog().log(status);
	}

	public static void log(Throwable e) {
		log(new Status(IStatus.ERROR, PLUGIN_ID, IStatus.ERROR, "Ambient Prof Error", e)); //$NON-NLS-1$
	}
	
	public static Shell getActiveWorkbenchShell() {
		return getActiveWorkbenchWindow().getShell();
	}

	/**
	 * Returns the current page chosen on the workbench
	 */
	public static WorkbenchPage getWorkbenchPage(){
		//TODO from getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage());
		return (WorkbenchPage)(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage());
	}

}

