/*******************************************************************************
 * Copyright (c) 2004 Duke University
 *
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.cs.duke.edu/csed/ambient/copyright.html
 * 
*******************************************************************************/
package edu.duke.cs.prof.remote;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.swing.ProgressMonitor;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import com.jcraft.jsch.UserInfo;

import edu.duke.cs.prof.ui.publish.publishWizardPages.ProjectPublishPage3;

public class SFTPTool {
	private JSch mySFTP;

	private Session mySession;

	private Channel myChannel;

	private BufferedReader myBufferedReader;

	private OutputStream myWriter;

	private ProjectPublishPage3 myPage;

	public SFTPTool() {
		mySFTP = new JSch();
	}

	public SFTPTool(ProjectPublishPage3 page) {
		myPage = page;
	}

	public void openSession(String user, String host) throws JSchException {
		mySession = mySFTP.getSession(user, host, 22);
	}

	public void connect(String password) throws JSchException,
			IOException {
		UserInfo ui = new User(password);
		mySession.setUserInfo(ui);
		mySession.connect();
		
		myChannel = mySession.openChannel("sftp");
		myChannel.connect();
	}

	public void sendCommand(String cmd) throws 
			 SftpException {
		
		int mode = ChannelSftp.OVERWRITE;
		SftpProgressMonitor monitor=new MyProgressMonitor();
		
		((ChannelSftp)myChannel).put(cmd,".", mode);
	}

	public void disconnect() {
		mySession.disconnect();
	}
	
	public static class MyProgressMonitor implements SftpProgressMonitor{
	    ProgressMonitor monitor;
	    long count=0;
	    long max=0;
	    public void init(int op, String src, String dest, long max){
	      this.max=max;
	      monitor=new ProgressMonitor(null, 
					  ((op==SftpProgressMonitor.PUT)? 
					   "put" : "get")+": "+src, 
					  "",  0, (int)max);
	      count=0;
	      monitor.setProgress((int)this.count);
	      monitor.setMillisToDecideToPopup(1000);
	    }
	    public boolean count(long count){
	      this.count+=count;
	      monitor.setProgress((int)this.count);
	      monitor.setNote("Completed "+this.count+" out of "+max+".");
	      return !(monitor.isCanceled());
	    }
	    public void end(){
	      monitor.close();
	    }
	  }
	
	public static void main(String args[]) throws IOException, IOException, JSchException, UnsupportedEncodingException, SftpException{
		SFTPTool tool = new SFTPTool();
		tool.openSession("dartmouth","localhost");
		System.out.println("session opened");
		tool.connect("king_pacho");
		System.out.println("connection made");
		tool.sendCommand("README");
		tool.disconnect();

	}
}
