package edu.duke.cs.prof.ui.preferences;


import org.eclipse.jface.preference.*;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.jface.preference.IPreferenceStore;


/**
 * This class represents a preference page that
 * is contributed to the Preferences dialog. By 
 * subclassing <samp>FieldEditorPreferencePage</samp>, we
 * can use the field support built into JFace that allows
 * us to create a page that is small and knows how to 
 * save, restore and apply itself.
 * <p>
 * This page is used to modify preferences only. They
 * are stored in the preference store that belongs to
 * the main plug-in class. That way, preferences can
 * be accessed directly via the preference store.
 */

public class SubmitPreferences extends FieldEditorPreferencePage
	implements IWorkbenchPreferencePage 
	{
	public static final String P_HOST = "submit.host";
	public static final String COURSE_DIR = "submit.cs.courseDir";

	public SubmitPreferences() {
		super(GRID);
		setPreferenceStore(WorkbenchPlugin.getDefault().getPreferenceStore());
		setDescription("Settings for Duke's Submit tool.");
		initializeDefaults();
	}
/**
 * Sets the default values of the preferences.
 */
	private void initializeDefaults() {
		IPreferenceStore store = getPreferenceStore();
		store.setDefault(P_HOST, "submit.cs.duke.edu");
		store.setDefault(COURSE_DIR,"$USR/courses");
		return;
	}
	
/**
 * Creates the field editors. Field editors are abstractions of
 * the common GUI blocks needed to manipulate various types
 * of preferences. Each field editor knows how to save and
 * restore itself.
 */

	public void createFieldEditors() {
		addField(new StringFieldEditor(P_HOST, 
				"&Submit server address", getFieldEditorParent()));
		addField(new IntegerFieldEditor(COURSE_DIR, 
				"&Remote location for project submission ", getFieldEditorParent()));
	}
	
	public void init(IWorkbench workbench) {
	}
}