package edu.duke.cs.prof.ui.publish.publishWizardPages;

import java.util.List;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;

import edu.duke.ambient.ui.checkin.pages.AmbientExportPage;
import edu.duke.cs.prof.ui.wizards.ProjectPublishWizard;
public class ProjectPublishPage1 extends AmbientExportPage {
	public final static int PROGRESS_BUSYCURSOR = 2;
	private Button myAPTButton;;
	private ProjectPublishWizard myWizard;
	
	private final boolean DEBUG = true;
	
	public ProjectPublishPage1(IStructuredSelection selection, 
			ProjectPublishWizard wiz) {
		this("AmbientExportPage", selection);
		setTitle("Publish Project");
		setDescription("Please select the project to be published.");
		
		myWizard = wiz;
	}

	
	protected ProjectPublishPage1(
		String pageName,
		IStructuredSelection selection) {
		super(pageName, selection);
	}

	public IProject getSelectedProject(){
		List resourcesToExport = getSelectedResources();
		return  ((IResource) (resourcesToExport.get(0))).getProject();
	}

	
	protected void createOptionsGroupButtons(Group optionsGroup) {
		Font font = optionsGroup.getFont();
		Label destinatonLabel = new Label(optionsGroup, SWT.NONE);
		destinatonLabel.setText("Select the project you want to publish.");	
		
		myAPTButton = new Button(optionsGroup,SWT.CENTER | SWT.CHECK);
		myAPTButton.setVisible(false);
		myAPTButton.setText("Publish Project for Snarfing");
		myAPTButton.addListener(SWT.Selection, new Listener(){
			public void handleEvent(Event event) {
				
			}
			
		});
	}
	
	public IWizardPage getNextPage(){
		if (!myAPTButton.getSelection()){
			return myWizard.geSecondPage();
		}else{
			return myWizard.getThirdPage(ProjectPublishWizard.PUBLISH_APT_INDEX);
		}

	}
}
	

