
package edu.duke.cs.prof.ui.publish.publishWizardPages;

//import java.awt.Toolkit;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.ui.internal.dialogs.DialogUtil;
import org.eclipse.ui.model.WorkbenchLabelProvider;

//import edu.duke.ambient.AmbientGlobals;
import edu.duke.ambient.ui.checkin.AmbientResourceTreeGroup;
import edu.duke.ambient.ui.checkin.pages.AmbientCheckoutPage;
import edu.duke.cs.prof.ui.wizards.ProjectPublishWizard;


public class ProjectPublishPage2 extends AmbientCheckoutPage{
	private Button myNewProjectButton,  myPublishButton;
	private ProjectPublishWizard myWizard;
	//private Toolkit myBeeper = Toolkit.getDefaultToolkit();
	private ICVSRemoteFolder mySelectedProject;
	
	public ProjectPublishPage2(ProjectPublishWizard wiz) {
		super(AmbientCheckoutPage.STANDARD_TYPE);
		myWizard = wiz;
	}
	
	protected void putMessages(){
    	setTitle("Publish Project");
		setDescription("Please select the destination project.");
	}
	
	public void createControl(Composite parent) {
		Composite composite = new Composite(parent, SWT.NULL);
		composite.setLayout(new GridLayout());
		GridData data = new GridData(GridData.FILL_BOTH);
		data.heightHint = 200;
		composite.setLayoutData(data);
		composite.setFont(parent.getFont());

		Label projectLabel = new Label(composite, SWT.NONE);
		projectLabel.setText("Available Projects");

		try {
			myViewer = new AmbientResourceTreeGroup(composite, getTreeInput(),
					getContentProvider(), WorkbenchLabelProvider
							.getDecoratingWorkbenchLabelProvider(), null,
					WorkbenchLabelProvider
							.getDecoratingWorkbenchLabelProvider(), SWT.NONE,
					DialogUtil.inRegularFontMode(parent));
		} catch (NegativeArraySizeException e) {
			return;
		}
		
		Label infoLabel = new Label(composite, SWT.NONE);
		projectLabel.setText(
				"Select the parent folder and choose \"Start New Project\" to setup the \"folders\n" +
				"for a new project.");
		makeButtonBar(composite);
		setControl(composite);
		return;
	}
	
	private boolean  checkInput(Button button){
		boolean ok = true;
		if (getDestinationFolder()== null){
			button.setSelection(false);
			//myBeeper.beep();
			MessageDialog.openError(getContainer().getShell(),
					"ERROR",
					"Please select a project");
			ok = false;
		}
		
		getWizard().getContainer().updateButtons();
		return ok;
	}
	
	private void makeButtonBar(Composite parent){
		Composite bar = new Composite(parent,SWT.NONE);
		bar.setLayout(new GridLayout(2,false));

		myPublishButton = new Button(bar,SWT.RIGHT | SWT.CHECK);
		myNewProjectButton = new Button(bar,SWT.CENTER | SWT.CHECK);
		
		myPublishButton.setText("Publish project");
		myNewProjectButton.setText("Start new project");
		
		myPublishButton.addListener(SWT.Selection, new Listener(){
			public void handleEvent(Event event) {
				myNewProjectButton.setSelection(false);
				if(checkInput(myPublishButton)){
					myWizard.updateThirdPage(ProjectPublishWizard.PUBLISH_PROJECT_INDEX);
				}
			}
			
		});
		
		
		myNewProjectButton.addListener(SWT.Selection,new Listener(){

			public void handleEvent(Event event) {
				myPublishButton.setSelection(false);
				if(checkInput(myNewProjectButton)){
					myWizard.updateThirdPage(ProjectPublishWizard.NEW_PROJECT_INDEX);
				}
			}});	

		
	}
	
	public ICVSRemoteFolder getDestinationFolder(){
		try{
			if (myViewer == null){
				return null;	
			}
			
			Object[] selectedProject = myViewer.getSelectedResources().toArray();
		    if (selectedProject.length == 0){
		    	return null;
		    }
		    
		    mySelectedProject = (ICVSRemoteFolder) selectedProject[0];
			return mySelectedProject;
		}catch(Exception  e){ }
		
		return null;
	}
	
	public boolean canFlipToNextPage(){
		if (myNewProjectButton.getSelection() || myPublishButton.getSelection()){
			return true;
		}
		return false;
	}
	
	
	public IWizardPage getNextPage(){
		if (myNewProjectButton.getSelection()){
			myWizard.updateThirdPage(ProjectPublishWizard.NEW_PROJECT_INDEX);
			myWizard.setCurrentThirdPage(ProjectPublishWizard.NEW_PROJECT_INDEX);
			return myWizard.getThirdPage(ProjectPublishWizard.NEW_PROJECT_INDEX);
		}
		if (this.myPublishButton.getSelection()){
			myWizard.updateThirdPage(ProjectPublishWizard.PUBLISH_PROJECT_INDEX);
			myWizard.setCurrentThirdPage(ProjectPublishWizard.PUBLISH_PROJECT_INDEX);
			return myWizard.getThirdPage(ProjectPublishWizard.PUBLISH_PROJECT_INDEX);
		}
		return null;
	}
}
