package edu.duke.cs.prof.ui.publish.publishWizardPages;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.ui.internal.WorkbenchPlugin;

import com.jcraft.jsch.JSchException;

import edu.duke.ambient.ui.preferences.AmbientPreferenceConstants;
import edu.duke.cs.prof.ProfGlobals;
import edu.duke.cs.prof.remote.SSHTool;
import edu.duke.cs.prof.ui.wizards.ProjectPublishWizard;
import edu.duke.cs.prof.utils.ProjectPublisher;


public class ProjectPublishPage3 extends WizardPage {
	//private ScrolledComposite myScroller;
	private Text myUser,myPass,myProject;
	private boolean myNewProjectFlag =false;
	protected ProjectPublishWizard myWizard;
	private SSHTool mySSHTool = null;
    private String myHost = WorkbenchPlugin.getDefault().getPreferenceStore().getString(AmbientPreferenceConstants.HOST);
	private StreamReader myReader;
	private BufferedReader myStream;
    private Button myDoneButton;
    //private List list;
    
	public ProjectPublishPage3(ProjectPublishWizard wiz) {
		super("Start Project");
    	setTitle("Publish Project");
		myWizard =wiz;
	}

	
	public void createControl(Composite parent) {
		Composite composite = new Composite(parent, SWT.NULL);
		composite.setLayout(new GridLayout(1,false));
		GridData data = new GridData(GridData.FILL_BOTH);
		data.heightHint = 200;
		data.widthHint = 500;
		composite.setLayoutData(data);
		composite.setFont(parent.getFont());
		
		initControl(composite);
	}
	
	public void initControl(Composite composite){		
		createTextArea(composite);
		createInputArea(composite);
		setControl(composite);
	}
	
	protected void createTextArea(Composite parent){
		/*Label projectLabel = new Label(parent, SWT.NONE);
		projectLabel.setText("Server Messages are in the .messages file");
		
		Composite c = new Composite(parent, SWT.NONE);
		c.setLayout(new GridLayout(1,false));
		
		list = new List(c, SWT.NONE);
		list.setVisible(false);
		/*myScroller = new ScrolledComposite(c, SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL);
		myScroller.setLayout(new GridLayout(1, false));

		//myScroller.setAlwaysShowScrollBars(true);
		list = new List(myScroller, SWT.NONE);
		list.setSize(list.computeSize(500,200));
		myScroller.setContent(list);
		list.add(" ");*/
	}

	public void createInputAreaLabels(Composite c){
		if (myNewProjectFlag){
			Label projectLabel = new Label(c,SWT.LEFT);
			projectLabel.setText("Project Name: ");
	
		    myProject = new Text(c,SWT.BORDER);
		    myProject.setToolTipText("project name");
		}
	
		Label loginLabel = new Label(c,SWT.LEFT);
		loginLabel.setText("Login into");
		Label serverLabel = new Label(c,SWT.LEFT);
	
		serverLabel.setText(myHost);
	}
	protected void createInputArea(Composite parent){
		Composite c = new Composite(parent, SWT.NONE);
		c.setLayout(new GridLayout(2,false));
		
		createInputAreaLabels(c);
		int style = SWT.SINGLE|SWT.LEFT|SWT.BORDER;
		
		
		
		Label userLabel = new Label(c,SWT.LEFT);
		userLabel.setText("Username:");
		
		myUser = new Text(c,SWT.BORDER);
		myUser.setText(WorkbenchPlugin.getDefault().getPreferenceStore().
				getString(AmbientPreferenceConstants.USER_ID));
		myUser.setToolTipText("Username");
		
		Label PassLabel = new Label(c,SWT.LEFT);
		PassLabel.setText("Password:");

		myPass = new Text(c,style);
		myPass.setEchoChar('*');
		myPass.setToolTipText("Password");
		
		myPass.addModifyListener(new ModifyListener(){
			public void modifyText(ModifyEvent e)
			{	
				//myDoneButton.setEnabled(true);
				myWizard.enableFinish(true);
			}
		});
		
	}
	
	protected void enableDoneButton(boolean enable){
		myWizard.enableFinish(enable);
		getContainer().updateButtons();		
	}
	public void sendCommand(String command) throws UnsupportedEncodingException,
	                                                           IOException{
		mySSHTool.sendCommand(command);
	}
	
	public boolean startConnection(ProjectPublisher p){
		if (mySSHTool != null){
			return false;
		}
		
		boolean badFlag = false;
		//list.removeAll();
		mySSHTool = new SSHTool();
			try {
				mySSHTool.openSession(myUser.getText(),myHost);
			} catch (JSchException e) {
				badFlag = true;
			}
			
			try {
				myStream = mySSHTool.connect(myPass.getText());
			} catch (JSchException e1) {
				
				MessageDialog
				.openInformation(
						getShell(),
						"Error", "ERROR: cannot connect to host " + myHost + "\nPlease try again!");
		
				//list.add("ERROR: cannot connect to host " + myHost);
				//list.add("\nPlease try again!");
				badFlag = true;
			} catch (IOException e1) {
				e1.printStackTrace();
				badFlag = true;
			}
			
			if (!badFlag){
				myReader = new StreamReader(myStream,p);
				setPreviousPage(this);
				new Thread(myReader).start();
				myPass.setEditable(false);
				myUser.setEditable(false);
				myWizard.enableFinish(true);
				getContainer().updateButtons();
			}else{
				mySSHTool.disconnect();
				mySSHTool = null;
			}
			
		    return false;
	}
	
	public boolean finish(){
		return false;
	}
	
	public IProject getProject(){
		return myWizard.getSelectedProject();
	}
	
	public ICVSRemoteFolder getRemoteFolder(){
		return myWizard.getSelectedDestination();
	}
	
	/*public String getLastMesssage(){
		try{
			//return list.getItem(list.getItemCount()-1);
		}catch(Exception e){}
		return "";
	}*/
//TODO	
	class StreamReader implements Runnable{
		private boolean myHaltFlag = false;
		BufferedReader myBufferedReader;
		ProjectPublisher myPublisher;
		
		public StreamReader(BufferedReader reader,ProjectPublisher p){
			myBufferedReader = reader;
			myPublisher = p;
		}
		private void halt(){
			myHaltFlag = false;
		}
		
		public synchronized void run() {
			try{
				while (!myHaltFlag){
				    final String out = myBufferedReader.readLine() ;
				    if (out==null){
				    	break;
				    }
				    Display.getDefault().asyncExec(new Runnable(){
				    	public void run(){
				    		try{
				    		    //list.add(out);
				    			//list.setSelection(list.getItemCount()-1);
				    			//list.showSelection();
				    		}catch(Exception e){
				    			System.out.println(e.getMessage());
				    			mySSHTool.disconnect();
				    			return;
				    		}
				    	}
				    });
				    if (out.equalsIgnoreCase(ProfGlobals.SUCCESS_FLAG)){
				    	Display.getDefault().asyncExec(new Runnable(){
					    	public void run(){
					    		try{
							    	myPublisher.publishProject();
					    		}catch(Exception e){
					    			mySSHTool.disconnect();
					    			return;
					    		}
					    	}
					    });
				    }
				    if (out.equalsIgnoreCase(ProfGlobals.ERROR_FLAG)){
				    	mySSHTool.disconnect();
				
					    Display.getDefault().asyncExec(new Runnable(){
					    	public void run(){
					    		try{
					    			MessageDialog.openError(getContainer().getShell(),
											"ERROR",ProfGlobals.EXEC_ERROR);
					    		}catch(Exception e){
					    			return;
					    		}
					    	}
					    });
					   
		    			return;
				    }
				    wait(100);
				}
		
			}catch(Exception ex){
				ex.printStackTrace();
				mySSHTool.disconnect();
				return;
			}
		}
	}

	public void performUpdate(){}
	
	public String getBinDir(){
		String repo = WorkbenchPlugin.getDefault().
	         getPreferenceStore().getString(AmbientPreferenceConstants.ROOT);

		return (repo + "/" + ProfGlobals.BIN_DIR);
	}
	
	public String getDestPath(){
		String repo = WorkbenchPlugin.getDefault().
        getPreferenceStore().getString(AmbientPreferenceConstants.ROOT);
		return (repo + "/" + getRemoteFolder().getRepositoryRelativePath());
	}
	
	public String getCourse(){
		String relativePath  = getRemoteFolder().getRepositoryRelativePath();
		return relativePath.split("/")[0];
	}
}
