package edu.duke.cs.prof.ui.publish.publishWizardPages;

import java.io.IOException;
import java.io.UnsupportedEncodingException;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import edu.duke.ambient.AmbientGlobals;
import edu.duke.cs.prof.ProfGlobals;
import edu.duke.cs.prof.ui.wizards.ProjectPublishWizard;
import edu.duke.cs.prof.utils.ProjectPublisher;


public class PublishProjectPage extends StartNewProjectPage{

	private Text myProjectField;
	
	public PublishProjectPage(ProjectPublishWizard wiz) {
		super(wiz);
		setTitle("Publish Project");
		setDescription("Publish Project");
	}
	
	public void initControl(Composite parent){
		createTextArea(parent);
		createProjectLabel(parent);
		createInputArea(parent);
		setControl(parent);
	}
	
	public boolean finish(){
		ProjectPublisher publisher = new ProjectPublisher(this,AmbientGlobals.SKELETON);
	
		startConnection(publisher);
		try {
			String cmd = getBinDir() + "/./" + ProfGlobals.PUBLISH_SCRIPT + " " +
			       getDestPath() + "/" + AmbientGlobals.SKELETON;
			sendCommand(cmd);
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		return true;
	}
	
	public void performUpdate(){
		enableDoneButton(true);
		updatePathLabel();
	}
}