/*******************************************************************************
 * Copyright (c) 2004 Duke University
 *
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.cs.duke.edu/csed/ambient/copyright.html
 * 
*******************************************************************************/
package edu.duke.cs.prof.ui.publish.publishWizardPages;



import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import edu.duke.cs.prof.ui.wizards.ProjectPublishWizard;



public class PublishSnarfPage extends StartNewProjectPage{

	private Label userLabel,authorLabel,versionLabel,typeLabel,urlLabel,
	        descLabel;
	private Text authorText,versionText,typeText,urlText,locationText,descText;
	
	public PublishSnarfPage(ProjectPublishWizard wiz) {
		super(wiz);
		setTitle("Publish Project");
		setDescription("Publish Project for Snarfing");

	}
	
	public void createInputAreaLabels(Composite c){
		// do nothing
	}
	
	public void initControl(Composite parent){
		createTextArea(parent);
		createProjectLabel(parent);
		
		Composite c = new Composite(parent, SWT.NONE);
		c.setLayout(new GridLayout(4,false));
		
		int style = SWT.RIGHT|SWT.BORDER;
		
		userLabel = new Label(c,SWT.LEFT);
		userLabel.setText("Location");
		locationText = new Text(c,style);

		
		userLabel.setToolTipText("Enter the location on the remote host, e.g. godzilla.acpub.duke.edu:~pkn/public_html/cps108/weeklies/weekly1");
		
		// who created the project?
		authorLabel = new Label(c, SWT.LEFT);
		authorLabel.setText("Author: ");
		authorLabel.setToolTipText("Set the author of the project");
		authorText = new Text(c,SWT.BORDER);
		// project version
		
		versionLabel = new Label(c,SWT.LEFT);
		versionLabel.setText("Vesrion: ");
		versionText = new Text(c,SWT.BORDER);
		
		//my type
		typeLabel = new Label(c,SWT.LEFT);
		typeLabel.setText("Type: ");
		typeLabel.setToolTipText("Set the project type(C++,Java)");
		typeText = new Text(c,SWT.BORDER);
		
		//my URL
		
		urlLabel = new Label(c, SWT.LEFT);
		urlLabel.setText("URL: ");
		urlLabel.setToolTipText("Example: http://www.cs.duke.edu");
		urlText = new Text(c, SWT.BORDER);

		// description
		
		descLabel = new Label(c,SWT.LEFT);
		descLabel.setText("Description");
		descLabel.setToolTipText("Project description, exampleL CPS 108");
		descText = new Text(c, SWT.BORDER);
		
		createInputArea(parent);
		setControl(parent);
	}
	
	public boolean finish(){
		try{
			String[] location = locationText.getText().split(":");
			String server = location[0];
			String path = location[1];			
			//this.getDisplay().removeAll();
			
			showMessage("Project: " + getProject().getName() + "\n");
			showMessage("Location: " + locationText.getText() + "\n");
			showMessage("Website: " + urlText.getText() + "\n");
			showMessage("Author: " + authorText.getText() + "\n");
			showMessage("Description " + descText.getText() + "\n");
			showMessage("Version " + versionText.getText() + "\n");
			showMessage("Language " + typeText.getText() + "\n");
			showMessage("Please Confirm before publishing.");
			
			MessageDialog.openConfirm(getShell(),"Publish for Snarfing",
					"Please confirm the information shown below before publishing:\n" +
					"Project: " + getProject().getName() + "\n"+
					"Location: " + locationText.getText() + "\n"+
					"Author: " + authorText.getText() + "\n"+
					"Description " + descText.getText() + "\n"+
					"Version " + versionText.getText() + "\n"+
					"Language " + typeText.getText() + "\n");
		}catch(Exception e){
			e.printStackTrace();
		}

		return true;//false;
	}
	
	public void performUpdate(){
		enableDoneButton(true);
		updatePathLabel();
	}
	
	private void showMessage(final String msg){
		//MessageDialog.openInformation(getShell(),"Error", "");

		/*final List list = this.getDisplay();
		Display.getDefault().asyncExec(new Runnable(){
	    	public void run(){
	    		try{
	    		    list.add(msg);
	    			list.setSelection(list.getItemCount()-1);
	    			list.showSelection();
	    		}catch(Exception e){
	    			System.out.println(e.getMessage());
	    			return;
	    		}
	    	}
	    });*/
	}
}