package edu.duke.cs.prof.ui.publish.publishWizardPages;

import java.io.IOException;
import java.io.UnsupportedEncodingException;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.WorkbenchPlugin;

import edu.duke.ambient.AmbientGlobals;
import edu.duke.ambient.ui.preferences.AmbientPreferenceConstants;
import edu.duke.cs.prof.ProfGlobals;
import edu.duke.cs.prof.ui.wizards.ProjectPublishWizard;
import edu.duke.cs.prof.utils.ProjectPublisher;

public class StartNewProjectPage extends ProjectPublishPage3 {

	protected Text myProjectField;

	private String myProjectPath;

	private Label myProjectLabel;

	public StartNewProjectPage(ProjectPublishWizard wiz) {
		super(wiz);
		setTitle("Publish Project");
		setDescription("Starting a new project.");
	}

	public void initControl(Composite parent) {
		createTextArea(parent);
		createProjectLabel(parent);
		createProjectField(parent);
		createInputArea(parent);
		setControl(parent);
	}

	protected void createProjectLabel(Composite parent) {
		Composite c = new Composite(parent, SWT.NONE);
		c.setLayout(new GridLayout(1, false));
		myProjectLabel = new Label(c, SWT.NONE);
		
		myProjectLabel.setText("                                                    ");
	}

	public void performUpdate() {
		enableDoneButton(true);
		updatePathLabel();
		if (myProjectPath.endsWith(AmbientGlobals.PROJECT_EXT)) {
			MessageDialog.openError(myWizard.getShell(), "ERROR",
					ProfGlobals.NEW_PROJECT_ERRROR);
			myProjectLabel.setText("Project path: ERROR");
			enableDoneButton(false);
			return;
		}
	}

	void updatePathLabel() {
		myProjectPath = myWizard.getSelectedDestination()
				.getRepositoryRelativePath();
		myProjectLabel.setText("Current Chosen Path: " + myProjectPath +"/... ");
	}

	protected void createProjectField(Composite parent) {
		Composite c = new Composite(parent, SWT.NONE);
		c.setLayout(new GridLayout(2, false));

		Label label = new Label(c, SWT.LEFT);
		label.setText("Project Name: ");

		int style = SWT.SINGLE | SWT.BORDER;
		myProjectField = new Text(c, style);
		myProjectField.setToolTipText("project name");
	}

	public boolean canFlipToNextPage() {
		return false;
	}

	public boolean finish() {
		String module = myProjectField.getText() + AmbientGlobals.PROJECT_EXT
				+ "/" + AmbientGlobals.SKELETON;
		ProjectPublisher publisher = new ProjectPublisher(this, module);
		String root = WorkbenchPlugin.getDefault().getPreferenceStore()
				.getString(AmbientPreferenceConstants.ROOT);

		startConnection(publisher);
		try {
			String cmd = getBinDir() + "/" + ProfGlobals.SETUP_PROJECT_SCRIPT
					+ " " + getDestPath() + "/" + myProjectField.getText()
					+ " " + getCourse();
			sendCommand(cmd);

			cmd = getBinDir() + "/" + ProfGlobals.SETUP_STUDENTS_SCRIPT + " "
					+ getCourse() + " " + getDestPath() + "/"
					+ myProjectField.getText() + " " + root;
			sendCommand(cmd);
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}

		return true;
	}
}