/*
 * Created on Aug 15, 2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package edu.duke.cs.prof.ui.wizards;

import java.io.File;
import java.util.ArrayList;

/**
 * @author jett
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class ProjectFactory 
{
	private ProjectMaker[] myMakers;
	
	public ProjectFactory()
	{
		myMakers = new ProjectMaker[1];
		myMakers[0] = new JavaProject();
		
	}
	
	public void addType(ProjectMaker maker)
	{
		ProjectMaker[] moreMakers = new ProjectMaker[myMakers.length + 1];
		int k;
		for (k = 0; k < myMakers.length; k++)
		{
			moreMakers[k] = myMakers[k];
		}
		moreMakers[k] = maker;
		myMakers = moreMakers;
	}
	
	public String[] getValidTypes()
	{
		ArrayList typeArray = new ArrayList();
		for (int k = 0; k < myMakers.length; k++)
		{
			if (myMakers[k].isVisible())
			{
				typeArray.add(myMakers[k].getName());		
			}
		}
		
		String[] types = new String[typeArray.size()];
		for (int k = 0; k < types.length; k++)
		{
			types[k] = (String) typeArray.get(k);
		}
		return types;
	}
	
	public String[] getAllTypes()
	{
		String[] types = new String[myMakers.length];
		for (int k = 0; k < types.length; k++)
		{
			types[k] = myMakers[k].getName();
		}
		return types;
	}
	
	public boolean isValidType(String type)
	{
		for (int k = 0; k < myMakers.length; k++)
		{
			String makerType = myMakers[k].getName();
			if (makerType.equals(type))
			{
				return true;
			}
		}
		return false;
	}
	
	public void makeProject(String type, File projectDir, String projectName)
	{
		for (int k = 0; k < myMakers.length; k++)
		{
			String makerType = myMakers[k].getName();
			if (makerType.equals(type))
			{
				myMakers[k].makeProject(projectDir, projectName);
				return;
			}
		}
	}
	
	public String getDescription(String type)
	{
		for (int k = 0; k < myMakers.length; k++)
		{
			String makerType = myMakers[k].getName();
			if (makerType.equals(type))
			{
				return myMakers[k].getDescription();
			}
		}
		return null;
	}
}
