/*
 * Created on Aug 11, 2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package edu.duke.cs.prof.ui.wizards;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;

import org.eclipse.core.resources.IProjectDescription;
//import org.eclipse.ui.PlatformUI;
//import org.eclipse.ui.WorkbenchException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * @author jett
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public abstract class ProjectMaker 
{
	public abstract boolean isVisible();
	public abstract String getName();
	public abstract String getDescription();
	public abstract void makeProject(File projectDir, String projectName);
	
	protected void createProjectFile(File projectDir, String projectName, String[] projectNatures, String buildSpec, String perspective)
	{
		if (projectDir.isDirectory() == false)
			return;
		File f = new File(projectDir, IProjectDescription.DESCRIPTION_FILE_NAME);
		try {
				f.createNewFile();
			} catch (IOException e1) {
		}
		Document doc = Util.createDOM();
		Element root = doc.createElement("projectDescription");
		Element name = doc.createElement("name");
		name.appendChild(doc.createTextNode(projectName));
		root.appendChild(name);
		Element commment = doc.createElement("comment");
		commment.appendChild(doc.createTextNode("Auto-Generated Project File"));
		root.appendChild(commment);
		Element p = doc.createElement("projects");
		root.appendChild(p);
		
		Element spec = doc.createElement("buildSpec");
		Element command = doc.createElement("buildCommand");
		Element b1 = doc.createElement("name");
		b1.appendChild(doc.createTextNode(buildSpec));
		Element b2 = doc.createElement("arguments");
		command.appendChild(b1);
		command.appendChild(b2);
		spec.appendChild(command);
		root.appendChild(spec);

		Element natures = doc.createElement("natures");		
		for (int k = 0; k < projectNatures.length; k++)
		{
			Element nature = doc.createElement("nature");
			nature.appendChild(doc.createTextNode(projectNatures[k]));
			natures.appendChild(nature);
		}
		root.appendChild(natures);

		doc.appendChild(root);		
		OutputStream siteOut = null;
		try {
			siteOut = Util.openOutput(f);
		} catch (FileNotFoundException e) {
				}
		Util.writeXML(siteOut, doc);
		/*
		try {
			PlatformUI.getWorkbench().showPerspective(perspective,PlatformUI.getWorkbench().getActiveWorkbenchWindow());
		} catch (WorkbenchException e) {
		}*/
	}
	
	protected void createClassPathFile(File projectDir, String[] Sources, String[] Libraries, String Output)	
	{
		if (projectDir.isDirectory() == false)
			return;
		File f = new File(projectDir, ".classpath");
		try {
				f.createNewFile();
			} catch (IOException e1) {
		}
		Document doc = Util.createDOM();
		Element root = doc.createElement("classpath");
		Element entry = null;	
			
		if (Sources == null)
		{
			Sources = new String[1];
			Sources[0] = "";
		}

		if (Output == null)
		{
			Output = "";
		}
	
		for (int k = 0; k < Sources.length; k++)
		{
			entry = doc.createElement("classpathentry");
			entry.setAttribute("kind", "src");
			entry.setAttribute("path", Sources[k]);
			root.appendChild(entry);
		}	
		
		entry = doc.createElement("classpathentry");
		entry.setAttribute("kind", "con");
		entry.setAttribute("path", "org.eclipse.jdt.launching.JRE_CONTAINER");
		root.appendChild(entry);

		entry = doc.createElement("classpathentry");
		entry.setAttribute("kind", "output");
		entry.setAttribute("path", Output);
		root.appendChild(entry);	

		if (Libraries != null)
		{
			for (int k = 0; k < Sources.length; k++)
			{
				entry = doc.createElement("classpathentry");
				entry.setAttribute("kind", "lib");
				entry.setAttribute("path", Libraries[k]);
				root.appendChild(entry);
			}	
		}

		doc.appendChild(root);		
		OutputStream siteOut = null;
		try {
			siteOut = Util.openOutput(f);
		} catch (FileNotFoundException e) {
			}
		Util.writeXML(siteOut, doc);
	}
	
	protected void createCdtProject(File projectDir)
	{
		if (projectDir.isDirectory() == false)
			return;
		File f = new File(projectDir, ".cdtproject");
		try {
				f.createNewFile();
			} catch (IOException e1) {
		}
		Document doc = Util.createDOM();
		Element root = doc.createElement("cdtproject");
		root.setAttribute("id", "org.eclipse.cdt.core.make");
		
		Element ext = doc.createElement("extension");
		ext.setAttribute("id", "org.eclipse.cdt.core.makeBuilder");
		ext.setAttribute("point", "org.eclipse.cdt.core.CBuildModel");
		
		Element attrib = doc.createElement("attribute");
		attrib.setAttribute("key", "command");
		attrib.setAttribute("value", "make");
		
		ext.appendChild(attrib);
		root.appendChild(ext);
		doc.appendChild(root);		
		OutputStream siteOut = null;
		try {
			siteOut = Util.openOutput(f);
		} catch (FileNotFoundException e) {
				}
		Util.writeXML(siteOut, doc);
	}
}
