/*******************************************************************************
 * Copyright (c) 2004 Duke University
 *
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.cs.duke.edu/csed/ambient/copyright.html
 * 
*******************************************************************************/
/*******************************************************************************
 * This class is edited from the original ZipFileExportWizard in
 * org.eclipse.ui.wizards.datatransfer
 *******************************************************************************/
package edu.duke.cs.prof.ui.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.ui.*;
import org.eclipse.ui.plugin.AbstractUIPlugin;

import edu.duke.ambient.ui.checkin.pages.AmbientCheckoutPage;
import edu.duke.ambient.ui.wizards.AmbientExportWizard;
import edu.duke.cs.prof.ui.publish.publishWizardPages.ProjectPublishPage1;
import edu.duke.cs.prof.ui.publish.publishWizardPages.ProjectPublishPage2;
import edu.duke.cs.prof.ui.publish.publishWizardPages.ProjectPublishPage3;
import edu.duke.cs.prof.ui.publish.publishWizardPages.PublishSnarfPage;
import edu.duke.cs.prof.ui.publish.publishWizardPages.PublishProjectPage;
import edu.duke.cs.prof.ui.publish.publishWizardPages.StartNewProjectPage;
import edu.duke.cs.prof.ui.publish.publishWizardPages.UpdateProjectPage;

public class ProjectPublishWizard extends AmbientExportWizard {
	
	protected IWorkbench workbench;
	protected IStructuredSelection selection;
	private ProjectPublishPage1 myFirstPage;
	private AmbientCheckoutPage mySecondPage;
	private ProjectPublishPage3[] myThirdPages=
		new ProjectPublishPage3[10];
	
	private boolean myFinishEnableFlag = false;
	private IProject mySelectedProject;
	
	public static int NEW_PROJECT_INDEX = 0;
	public static int UPDATE_PROJECT_INDEX = 1;
	public static int PUBLISH_PROJECT_INDEX = 2;
	public static int PUBLISH_APT_INDEX = 3;
	
	
	private int myThirdPageIndex;

	public ProjectPublishWizard() {
		AbstractUIPlugin plugin = (AbstractUIPlugin) Platform
				.getPlugin(PlatformUI.PLUGIN_ID);
		IDialogSettings workbenchSettings = plugin.getDialogSettings();
		IDialogSettings section = workbenchSettings
				.getSection("ProjectPublishWizard");//$NON-NLS-1$
		if (section == null)
			section = workbenchSettings.addNewSection("ProjectPublishWizard");//$NON-NLS-1$
		setDialogSettings(section);
	}
	/*
	 * (non-Javadoc) Method declared on IWizard.
	 */
	public void addPages() {
		enableFinish(false);
		
		myFirstPage = new ProjectPublishPage1(selection,this);
		mySecondPage = new ProjectPublishPage2(this);

		addPage(myFirstPage);
		addPage(mySecondPage);
		
		myThirdPages[NEW_PROJECT_INDEX] = new StartNewProjectPage(this);
		myThirdPages[UPDATE_PROJECT_INDEX]   = new UpdateProjectPage(this);
		myThirdPages[PUBLISH_PROJECT_INDEX] = new PublishProjectPage(this);
		myThirdPages[PUBLISH_APT_INDEX] = new PublishSnarfPage(this);
		
		
		addPage(myThirdPages[NEW_PROJECT_INDEX]);
		addPage(myThirdPages[UPDATE_PROJECT_INDEX]);
		addPage(myThirdPages[PUBLISH_PROJECT_INDEX]);
		addPage(myThirdPages[PUBLISH_APT_INDEX]);
	}
	/**
	 * Returns the image descriptor with the given relative path.
	 */
	
	public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
		this.workbench = workbench;
		selection = currentSelection;
		//setWindowTitle(DataTransferMessages.getString("DataTransfer.export"));
		// //$NON-NLS-1$e
		setWindowTitle("Publish Project");
		setDefaultPageImageDescriptor(getImageDescriptor("wizban/exportzip_wiz.gif"));//$NON-NLS-1$
		setNeedsProgressMonitor(true);
	}


	public boolean performFinish() {
		//System.out.println(myThirdPageIndex);
		return myThirdPages[myThirdPageIndex].finish();
		/*if (myThirdPageIndex == NEW_PROJECT_INDEX){
			return ((StartNewProjectPage)myThirdPages[NEW_PROJECT_INDEX]).finish();
		}
		if (myThirdPageIndex == UPDATE_PROJECT_INDEX){
			return ((UpdateProjectPage)myThirdPages[UPDATE_PROJECT_INDEX]).finish();
		}
		if (myThirdPageIndex == PUBLISH_PROJECT_INDEX){
			return ((PublishProjectPage)myThirdPages[PUBLISH_PROJECT_INDEX]).finish();
		}*/
		//return true;
		//return false;
	}
	
	
	
	public IProject getSelectedProject(){
		return myFirstPage.getSelectedProject();
	}
	
	public ICVSRemoteFolder getSelectedDestination(){
		return ((ProjectPublishPage2) mySecondPage).getDestinationFolder();
	}
	
	public void updateThirdPage(int index){
		(myThirdPages[index]).performUpdate();
		
	}
	
	public IWizardPage geSecondPage(){
		return mySecondPage;
	}
	
	public IWizardPage getThirdPage(int index){
		return myThirdPages[index];
	}
	
	public void setCurrentThirdPage(int index){
		myThirdPageIndex = index;
	}
	
}

