/*
 * 
 * Created on Jun 3, 2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package edu.duke.cs.prof.ui.wizards;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import java.io.*;


/**
 * @author Duke Curious 2004
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class PublishWeeklyWizard extends Wizard 
{
	 final protected int PARAM_NO = 5;
	 
	 protected class Page1 extends WizardPage
    {
	 	  private Composite paramPanel;
	 	  private Button[] myAddButtons = new Button[PARAM_NO];
	 	  private Text[] myParamNames = new Text[PARAM_NO];
	 	  private Text[] myParamTypes = new Text[PARAM_NO];
	 	  private boolean[] myVisibles = new boolean[PARAM_NO];
	 	  private BufferedWriter myWriter;
	 	  private Text className, functionName, projectName, projectType, returnType, returnValue;
	 	  private ProjectFactory myFactory;
	 	  private int parameters;
	 	  
	public Page1 ()
    {
     	super("Set Weekly Project Information"); //$NON-NLS-1$
     	for (int i = 1; i<PARAM_NO; i++)
     		myVisibles[i] = false;
     	myVisibles[0]=true;
     	myFactory = new ProjectFactory();
     	parameters=0;
     }
	
     public void createControl (Composite parent)
     {
     	//setTitle("weekly publisher");//,  //$NON-NLS-1$
		setDescription("A java project will be created in your workspace containing "+
				"a java file and a weekly.spec file");//		

         Composite page = new Composite(parent,SWT.NONE);
         page.setLayoutData(new GridData(GridData.FILL_BOTH));
         page.setLayout(new GridLayout(1,false));
         
         Composite checkPanel = new Composite(page,SWT.NULL);
         checkPanel.setLayout(new GridLayout(4,false));
         
         Label projName = new Label(checkPanel,SWT.NULL);
         projName.setText("Weekly Project Name");
         projectName = new Text(checkPanel, SWT.BORDER);
         Label projType = new Label(checkPanel,SWT.NULL);
         projType.setText("Weekly Project Type");
         projectType = new Text(checkPanel, SWT.BORDER);
         
         Label classLabel = new Label(checkPanel, SWT.LEFT);
         classLabel.setText("Class Name");
         className = new Text(checkPanel, SWT.BORDER | SWT.SINGLE);
         Label label = new Label(checkPanel, SWT.LEFT);
         label.setText("Function Name");
         functionName = new Text(checkPanel,SWT.BORDER);
         Label returnLabel = new Label(checkPanel, SWT.LEFT);
         returnLabel.setText("Enter Return Type");
         returnType = new Text(checkPanel,SWT.BORDER);
         Label l = new Label(checkPanel, SWT.LEFT);
         l.setText("Enter Built-in Return Value");
         returnValue=new Text(checkPanel, SWT.BORDER);
         
         paramPanel = new Composite(page,SWT.NULL);
         paramPanel.setLayout(new GridLayout(3,false));
         Label type = new Label(paramPanel, SWT.LEFT);
         type.setText("Parameter Type");
         Label name = new Label(paramPanel, SWT.LEFT);
         name.setText("Parameter Name");
         Label empty = new Label(paramPanel, SWT.LEFT);
         
         for (int j=0; j<PARAM_NO;j++)
         {
         	myParamTypes[j]= new Text(paramPanel,SWT.BORDER);
         	myParamNames[j]= new Text(paramPanel,SWT.BORDER);
         	myAddButtons[j] = new Button(paramPanel,SWT.PUSH);
         	myAddButtons[j].setText("Add Parameter");
         	if (j>0)
         	{
         		myParamTypes[j].setVisible(false);
         		myParamNames[j].setVisible(false);
         		myAddButtons[j].setVisible(false);
         	}
         }
         for (int i=0; i<PARAM_NO-1;i++)
         {
         	myAddButtons[i].addSelectionListener(new SelectionAdapter()
	    {
                public void widgetSelected(SelectionEvent e)
		{
                	onAddParam();
		}
	    });
         }
         setControl(page);
     }
     
     private void onAddParam()
     {
     	int j=0;
     	for (int i=1;i<PARAM_NO; i++)
     		if (myVisibles[i]==false)
     		{
     			j=i;
     			myVisibles[i]=true;
     			break;
     		}
     	myParamTypes[j].setVisible(true);
 		myParamNames[j].setVisible(true);
 		if (j<PARAM_NO-1) 	myAddButtons[j].setVisible(true);
 		
     }
     
     public String getProjectName()
     {
     	return projectName.getText();
     }
     
     public String getProjectType()
     {
     	return projectType.getText();
     }
     
     public String getClassName()
     {
     	return className.getText();
     }
     
     public String getFunctionName()
     {
     	return functionName.getText();
     }
     public String getFunctionRetType()
     {
     	return returnType.getText();
     }
     public String getReturnValue()
     {
     	return returnValue.getText();
     }
     public int getParameters()
     {
     	return parameters;
     }
     public String getParamType(int index)
     {
     	return myParamTypes[index].getText();
     }
     public String getParamName(int index)
     {
     	return myParamNames[index].getText();
     }
     
     public boolean isPageComplete() 
     {
     	for (int j=0; j<PARAM_NO;j++)
     		if (myParamTypes[j].getText()!="" && 
     				myParamNames[j].getText()!="") parameters++;
				
	    return true;
	 }
 }
	 
	    private Page1 page1;
	    private ProjectFactory myFactory;
	    private ProjectLoader myLoader;
	    private String projectDir;
	    private IWorkspace workspace;
	    private File specFile, classFile;
	    
	    public PublishWeeklyWizard()
	     {
	         myFactory = new ProjectFactory();
	         myLoader = new ProjectLoader(getShell());
	         workspace = ResourcesPlugin.getWorkspace();
	         UI.setDisplay(Display.getCurrent());
	         this.setWindowTitle("Create Weekly Project"); //$NON-NLS-1$ //$NON-NLS-2$
	    }
	    private void createWeekly()
	    {
	    	String path = workspace.getRoot().getLocation().toFile().getAbsolutePath(); 
		    projectDir = path+File.separator+page1.getProjectName();
	     	File f = new File(projectDir);
		       
	     	myFactory.makeProject(page1.getProjectType(),f,page1.getProjectName());
	     	
	     	specFile = new File(f+File.separator+"Weekly.spec");
	     	classFile = new File(f+File.separator+page1.getClassName()+".java");
	     	try{
	     		specFile.createNewFile();
			   	classFile.createNewFile();
			   	
			} catch (IOException e){
				e.printStackTrace();
				}
	    }
	    private void showProject()
	    {
	    	File projFile = new File(projectDir, IProjectDescription.DESCRIPTION_FILE_NAME);
	    	if (projFile.exists())
           {
               IProjectDescription desc = null;
               try {
                   desc =
                       workspace.loadProjectDescription(
                           new Path(projFile.getAbsolutePath()));
               } catch (CoreException e1) {
                   e1.printStackTrace();
               }
               desc.setLocation(new Path(projFile.getParent()));
                 IProject project = workspace.getRoot().getProject(desc.getName());
               myLoader.loadProject(desc,project,null);
           }
	    }
	    protected void createClassFile()
	    {
	    	try {
	    		BufferedWriter out = new BufferedWriter(new FileWriter(classFile));
	        	out.write("public class "+page1.getClassName());
	        	out.newLine();
	        	out.write("{");
	        	out.newLine();
	        	out.write("\tpublic "+page1.getFunctionRetType()+" "+
	        		page1.getFunctionName()+"(");
	        	for (int i=0; i<page1.getParameters();i++)
	        	{
	        		out.write(page1.getParamType(i)+" "+page1.getParamName(i));
		        	if (i!=page1.getParameters()-1) out.write(", ");
	        	}
	        	out.write(")");out.newLine(); out.write("\t{"); out.newLine();
	        	out.write("\t\treturn "+page1.getReturnValue()+";");
	        	out.newLine(); out.write("\t}");out.newLine();out.write("}");
	        	out.close();
	    	} catch (IOException e) {
	    	}
	    }
	    protected void createSpecFile()
	    {
	    	try {
	    		BufferedWriter out = new BufferedWriter(new FileWriter(specFile));
	        	out.write(page1.getClassName());
	        	out.newLine();
	        	out.write(page1.getFunctionName());
	        	out.newLine();
	        	out.write(String.valueOf(page1.getParameters()));
				out.newLine();
	        	for (int i=0; i<page1.getParameters();i++)
	        	{
	        		out.write(page1.getParamType(i));
		        	out.newLine();
	        	}
	        	out.write(page1.getFunctionRetType());
	        	
	        	out.close();
	    	} catch (IOException e) {
	    	}
	    }
	    public boolean performFinish ()
	    {//TODO
	    	if (page1.isPageComplete())
	    	{
	    		createWeekly();
	    		createSpecFile();
	    		createClassFile();
	    		showProject();
	    	}   
	        return true;
	    }

	    public void addPages ()
	    {
	        super.addPages();
	        page1 = new Page1();
	        //page2 = new Page1();
	        addPage(page1);
	        //addPage(page2);
	    }

	    public boolean performCancel ()
	    {
	        
	        return super.performCancel();
	    }

	    public boolean canFinish ()
	    {
	        return page1.isPageComplete();
	    }
	}
