package edu.duke.cs.prof.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;

import org.eclipse.core.resources.IProject;

public class JarBuilder {
	private File jarFile;

	private BufferedInputStream myInput;

	private IProject myProject;
	private JarOutputStream myJarOutput;
	private byte[] myBuffer;
	
	public JarBuilder(IProject proj) {
		myProject = proj;
		myBuffer = new byte[1024];
	}

	public void makeJar(File file) throws FileNotFoundException, IOException{
		jarFile = new File("test.jar");
		myJarOutput = new JarOutputStream(
				new FileOutputStream(jarFile));
		jar(file);
		myJarOutput.close();
	}
	
	private void jar(File file) {

		
		int size;
		File tFile = file;
	
		try {
				if (file.isDirectory()) {
					JarEntry entry = new JarEntry(file.getName().endsWith(File.separator)
							? file.getName() + "."
									: file.getName() + File.separator + ".");
					entry.setSize(0);
					myJarOutput.putNextEntry(entry);
					
					
					File[] files = file.listFiles();

					for(int k=0;k<files.length;k++){
						tFile = new File(file,files[k].getName());
						jar(tFile);
					}
					myJarOutput.closeEntry();
				
				} else {
					System.out.println("Jarring file " + tFile.getCanonicalPath());
					JarEntry entry = new JarEntry(tFile.getName());
					try {
						myInput = new BufferedInputStream(new FileInputStream(
								tFile));
					} catch (FileNotFoundException e) {
					}
					
					
					entry.setSize(tFile.length());
					myJarOutput.putNextEntry(entry);

					while ((size = myInput.read(myBuffer)) != -1)
						myJarOutput.write(myBuffer, 0, size);
					myInput.close();
					myJarOutput.closeEntry();
				}
		
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	
	public static void main(String[] args) throws FileNotFoundException, IOException {
		File k = new File(
				"C:\\Program Files\\eclipse\\eclipse-SDK-3.0-win32\\eclipse\\workspace\\edu.duke.cs.prof\\src");
		new JarBuilder(null).makeJar(k);
	}
}
