package edu.duke.cs.prof.utils;


import java.io.File;
import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.ui.operations.ShareProjectOperation;
import edu.duke.ambient.ui.checkin.Shared;
import edu.duke.ambient.ui.checkin.jobs.CommitJob;
import edu.duke.cs.prof.ui.publish.publishWizardPages.ProjectPublishPage3;


public class ProjectPublisher {
	private IProject myProject;
    private ICVSRemoteFolder myRemoteFolder;
	private final static String PUBLISH_JOB_STR = " publishing project..."; 
	private final static String COMMIT_JOB_STR = " your files are being transfered...";
	private ProjectPublishPage3 myPage;
	private Shell myShell;
	private String myBinDirPath,myConfigPath,myModule;
	
	public ProjectPublisher(ProjectPublishPage3 page, String module){
		myPage = page;
		myModule = module;
		myRemoteFolder= myPage.getRemoteFolder();
		myProject = myPage.getProject();
		myShell = myPage.getShell();
		
		//System.out.println("Remote folder " + myRemoteFolder.getRepositoryRelativePath());
	}

	public void publishProject(){
		ReshareProjectJob reshareJob = new ReshareProjectJob(myRemoteFolder,
				myModule);
		reshareJob.setSystem(false);
		reshareJob.schedule();
		
	}
	
	class ReshareProjectJob extends Job {
		private ICVSRemoteFolder myTargetFolder;
		private String myModuleName;
		
		public ReshareProjectJob(ICVSRemoteFolder folder,String module) {
			super("");
			this.myTargetFolder = folder;
			this.myModuleName  = module;
		}

		protected IStatus run(IProgressMonitor monitor) {
			try {
				monitor.beginTask("", 100);
				try{
					File project = myProject.getLocation().toFile();
					new Shared().unmanage(project);
				}catch(Exception e){}
				String module = myTargetFolder.getRepositoryRelativePath() + "/"
						+ myModuleName;
				ICVSRepositoryLocation location = myTargetFolder.getRepository();

				try {
					ShareProjectOperation op = new ShareProjectOperation(
							myShell, location, myProject, module);
					op.run(monitor);
					return Status.OK_STATUS;

				} catch (InvocationTargetException e) {
		
				} catch (InterruptedException e) {
		
				}

			} finally {
				CommitJob commit = new CommitJob(myProject);
				commit.setSystem(false);
				commit.schedule();
				monitor.done();
			}
			return Status.CANCEL_STATUS;
		}
	}
}
